/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest;
import software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse;
import software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.TagResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.TagResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.UntagResourceResponse;

/**
 * Service client for accessing AWSSavingsPlans asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Savings Plans are a pricing model that offer significant savings on AWS usage (for example, on Amazon EC2 instances).
 * You commit to a consistent amount of usage, in USD per hour, for a term of 1 or 3 years, and receive a lower price
 * for that usage. For more information, see the <a
 * href="https://docs.aws.amazon.com/savingsplans/latest/userguide/">AWS Savings Plans User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SavingsplansAsyncClient extends SdkClient {
    String SERVICE_NAME = "savingsplans";

    /**
     * Create a {@link SavingsplansAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SavingsplansAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SavingsplansAsyncClient}.
     */
    static SavingsplansAsyncClientBuilder builder() {
        return new DefaultSavingsplansAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a Savings Plan.
     * </p>
     *
     * @param createSavingsPlanRequest
     * @return A Java Future containing the result of the CreateSavingsPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>ServiceQuotaExceededException A service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.CreateSavingsPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/CreateSavingsPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSavingsPlanResponse> createSavingsPlan(CreateSavingsPlanRequest createSavingsPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Savings Plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSavingsPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSavingsPlanRequest#builder()}
     * </p>
     *
     * @param createSavingsPlanRequest
     *        A {@link Consumer} that will call methods on {@link CreateSavingsPlanRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSavingsPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>ServiceQuotaExceededException A service quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.CreateSavingsPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/CreateSavingsPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSavingsPlanResponse> createSavingsPlan(
            Consumer<CreateSavingsPlanRequest.Builder> createSavingsPlanRequest) {
        return createSavingsPlan(CreateSavingsPlanRequest.builder().applyMutation(createSavingsPlanRequest).build());
    }

    /**
     * <p>
     * Describes the specified Savings Plans rates.
     * </p>
     *
     * @param describeSavingsPlanRatesRequest
     * @return A Java Future containing the result of the DescribeSavingsPlanRates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.DescribeSavingsPlanRates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlanRates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSavingsPlanRatesResponse> describeSavingsPlanRates(
            DescribeSavingsPlanRatesRequest describeSavingsPlanRatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Savings Plans rates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSavingsPlanRatesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSavingsPlanRatesRequest#builder()}
     * </p>
     *
     * @param describeSavingsPlanRatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSavingsPlanRatesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSavingsPlanRates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.DescribeSavingsPlanRates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlanRates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSavingsPlanRatesResponse> describeSavingsPlanRates(
            Consumer<DescribeSavingsPlanRatesRequest.Builder> describeSavingsPlanRatesRequest) {
        return describeSavingsPlanRates(DescribeSavingsPlanRatesRequest.builder().applyMutation(describeSavingsPlanRatesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified Savings Plans.
     * </p>
     *
     * @param describeSavingsPlansRequest
     * @return A Java Future containing the result of the DescribeSavingsPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.DescribeSavingsPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSavingsPlansResponse> describeSavingsPlans(
            DescribeSavingsPlansRequest describeSavingsPlansRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Savings Plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSavingsPlansRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSavingsPlansRequest#builder()}
     * </p>
     *
     * @param describeSavingsPlansRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSavingsPlansRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSavingsPlans operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.DescribeSavingsPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSavingsPlansResponse> describeSavingsPlans(
            Consumer<DescribeSavingsPlansRequest.Builder> describeSavingsPlansRequest) {
        return describeSavingsPlans(DescribeSavingsPlansRequest.builder().applyMutation(describeSavingsPlansRequest).build());
    }

    /**
     * <p>
     * Describes the specified Savings Plans offering rates.
     * </p>
     *
     * @param describeSavingsPlansOfferingRatesRequest
     * @return A Java Future containing the result of the DescribeSavingsPlansOfferingRates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.DescribeSavingsPlansOfferingRates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferingRates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSavingsPlansOfferingRatesResponse> describeSavingsPlansOfferingRates(
            DescribeSavingsPlansOfferingRatesRequest describeSavingsPlansOfferingRatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Savings Plans offering rates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSavingsPlansOfferingRatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSavingsPlansOfferingRatesRequest#builder()}
     * </p>
     *
     * @param describeSavingsPlansOfferingRatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSavingsPlansOfferingRatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSavingsPlansOfferingRates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.DescribeSavingsPlansOfferingRates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferingRates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSavingsPlansOfferingRatesResponse> describeSavingsPlansOfferingRates(
            Consumer<DescribeSavingsPlansOfferingRatesRequest.Builder> describeSavingsPlansOfferingRatesRequest) {
        return describeSavingsPlansOfferingRates(DescribeSavingsPlansOfferingRatesRequest.builder()
                .applyMutation(describeSavingsPlansOfferingRatesRequest).build());
    }

    /**
     * <p>
     * Describes the specified Savings Plans offerings.
     * </p>
     *
     * @param describeSavingsPlansOfferingsRequest
     * @return A Java Future containing the result of the DescribeSavingsPlansOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.DescribeSavingsPlansOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSavingsPlansOfferingsResponse> describeSavingsPlansOfferings(
            DescribeSavingsPlansOfferingsRequest describeSavingsPlansOfferingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Savings Plans offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSavingsPlansOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSavingsPlansOfferingsRequest#builder()}
     * </p>
     *
     * @param describeSavingsPlansOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSavingsPlansOfferingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSavingsPlansOfferings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.DescribeSavingsPlansOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSavingsPlansOfferingsResponse> describeSavingsPlansOfferings(
            Consumer<DescribeSavingsPlansOfferingsRequest.Builder> describeSavingsPlansOfferingsRequest) {
        return describeSavingsPlansOfferings(DescribeSavingsPlansOfferingsRequest.builder()
                .applyMutation(describeSavingsPlansOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ServiceQuotaExceededException A service quota has been exceeded.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ServiceQuotaExceededException A service quota has been exceeded.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ValidationException One of the input parameters is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SavingsplansException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SavingsplansAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }
}
