/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest;
import software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse;
import software.amazon.awssdk.services.savingsplans.model.InternalServerException;
import software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.ResourceNotFoundException;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansException;
import software.amazon.awssdk.services.savingsplans.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.savingsplans.model.TagResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.TagResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.UntagResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.ValidationException;

/**
 * Service client for accessing AWSSavingsPlans. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Savings Plans are a pricing model that offer significant savings on AWS usage (for example, on Amazon EC2 instances).
 * You commit to a consistent amount of usage, in USD per hour, for a term of 1 or 3 years, and receive a lower price
 * for that usage. For more information, see the <a
 * href="https://docs.aws.amazon.com/savingsplans/latest/userguide/">AWS Savings Plans User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SavingsplansClient extends SdkClient {
    String SERVICE_NAME = "savingsplans";

    /**
     * Create a {@link SavingsplansClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SavingsplansClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SavingsplansClient}.
     */
    static SavingsplansClientBuilder builder() {
        return new DefaultSavingsplansClientBuilder();
    }

    /**
     * <p>
     * Creates a Savings Plan.
     * </p>
     *
     * @param createSavingsPlanRequest
     * @return Result of the CreateSavingsPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws ServiceQuotaExceededException
     *         A service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.CreateSavingsPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/CreateSavingsPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSavingsPlanResponse createSavingsPlan(CreateSavingsPlanRequest createSavingsPlanRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, SavingsplansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Savings Plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSavingsPlanRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSavingsPlanRequest#builder()}
     * </p>
     *
     * @param createSavingsPlanRequest
     *        A {@link Consumer} that will call methods on {@link CreateSavingsPlanRequest.Builder} to create a request.
     * @return Result of the CreateSavingsPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws ServiceQuotaExceededException
     *         A service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.CreateSavingsPlan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/CreateSavingsPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSavingsPlanResponse createSavingsPlan(Consumer<CreateSavingsPlanRequest.Builder> createSavingsPlanRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, SavingsplansException {
        return createSavingsPlan(CreateSavingsPlanRequest.builder().applyMutation(createSavingsPlanRequest).build());
    }

    /**
     * <p>
     * Describes the specified Savings Plans rates.
     * </p>
     *
     * @param describeSavingsPlanRatesRequest
     * @return Result of the DescribeSavingsPlanRates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlanRates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlanRates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSavingsPlanRatesResponse describeSavingsPlanRates(
            DescribeSavingsPlanRatesRequest describeSavingsPlanRatesRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, SavingsplansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Savings Plans rates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSavingsPlanRatesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSavingsPlanRatesRequest#builder()}
     * </p>
     *
     * @param describeSavingsPlanRatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSavingsPlanRatesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSavingsPlanRates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlanRates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlanRates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSavingsPlanRatesResponse describeSavingsPlanRates(
            Consumer<DescribeSavingsPlanRatesRequest.Builder> describeSavingsPlanRatesRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, SavingsplansException {
        return describeSavingsPlanRates(DescribeSavingsPlanRatesRequest.builder().applyMutation(describeSavingsPlanRatesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the specified Savings Plans.
     * </p>
     *
     * @param describeSavingsPlansRequest
     * @return Result of the DescribeSavingsPlans operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSavingsPlansResponse describeSavingsPlans(DescribeSavingsPlansRequest describeSavingsPlansRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, SavingsplansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Savings Plans.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSavingsPlansRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSavingsPlansRequest#builder()}
     * </p>
     *
     * @param describeSavingsPlansRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSavingsPlansRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSavingsPlans operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlans
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlans"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSavingsPlansResponse describeSavingsPlans(
            Consumer<DescribeSavingsPlansRequest.Builder> describeSavingsPlansRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, SavingsplansException {
        return describeSavingsPlans(DescribeSavingsPlansRequest.builder().applyMutation(describeSavingsPlansRequest).build());
    }

    /**
     * <p>
     * Describes the specified Savings Plans offering rates.
     * </p>
     *
     * @param describeSavingsPlansOfferingRatesRequest
     * @return Result of the DescribeSavingsPlansOfferingRates operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlansOfferingRates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferingRates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSavingsPlansOfferingRatesResponse describeSavingsPlansOfferingRates(
            DescribeSavingsPlansOfferingRatesRequest describeSavingsPlansOfferingRatesRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Savings Plans offering rates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSavingsPlansOfferingRatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSavingsPlansOfferingRatesRequest#builder()}
     * </p>
     *
     * @param describeSavingsPlansOfferingRatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSavingsPlansOfferingRatesRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSavingsPlansOfferingRates operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlansOfferingRates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferingRates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSavingsPlansOfferingRatesResponse describeSavingsPlansOfferingRates(
            Consumer<DescribeSavingsPlansOfferingRatesRequest.Builder> describeSavingsPlansOfferingRatesRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        return describeSavingsPlansOfferingRates(DescribeSavingsPlansOfferingRatesRequest.builder()
                .applyMutation(describeSavingsPlansOfferingRatesRequest).build());
    }

    /**
     * <p>
     * Describes the specified Savings Plans offerings.
     * </p>
     *
     * @param describeSavingsPlansOfferingsRequest
     * @return Result of the DescribeSavingsPlansOfferings operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlansOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSavingsPlansOfferingsResponse describeSavingsPlansOfferings(
            DescribeSavingsPlansOfferingsRequest describeSavingsPlansOfferingsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Savings Plans offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSavingsPlansOfferingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSavingsPlansOfferingsRequest#builder()}
     * </p>
     *
     * @param describeSavingsPlansOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSavingsPlansOfferingsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSavingsPlansOfferings operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlansOfferings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSavingsPlansOfferingsResponse describeSavingsPlansOfferings(
            Consumer<DescribeSavingsPlansOfferingsRequest.Builder> describeSavingsPlansOfferingsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        return describeSavingsPlansOfferings(DescribeSavingsPlansOfferingsRequest.builder()
                .applyMutation(describeSavingsPlansOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SavingsplansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ServiceQuotaExceededException
     *         A service quota has been exceeded.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SavingsplansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ServiceQuotaExceededException
     *         A service quota has been exceeded.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ServiceQuotaExceededException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, SavingsplansException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SavingsplansException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("savingsplans");
    }
}
