/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlanRatesRequest extends SavingsplansRequest implements
        ToCopyableBuilder<DescribeSavingsPlanRatesRequest.Builder, DescribeSavingsPlanRatesRequest> {
    private static final SdkField<String> SAVINGS_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSavingsPlanRatesRequest::savingsPlanId)).setter(setter(Builder::savingsPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanId").build()).build();

    private static final SdkField<List<SavingsPlanRateFilter>> FILTERS_FIELD = SdkField
            .<List<SavingsPlanRateFilter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlanRatesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanRateFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanRateFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSavingsPlanRatesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSavingsPlanRatesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ID_FIELD,
            FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String savingsPlanId;

    private final List<SavingsPlanRateFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeSavingsPlanRatesRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlanId = builder.savingsPlanId;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the Savings Plan.
     * </p>
     * 
     * @return The ID of the Savings Plan.
     */
    public String savingsPlanId() {
        return savingsPlanId;
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filters.
     */
    public List<SavingsPlanRateFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve additional results, make another call
     * with the returned token value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve additional results, make another
     *         call with the returned token value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlanRatesRequest)) {
            return false;
        }
        DescribeSavingsPlanRatesRequest other = (DescribeSavingsPlanRatesRequest) obj;
        return Objects.equals(savingsPlanId(), other.savingsPlanId()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSavingsPlanRatesRequest").add("SavingsPlanId", savingsPlanId())
                .add("Filters", filters()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanId":
            return Optional.ofNullable(clazz.cast(savingsPlanId()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlanRatesRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlanRatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSavingsPlanRatesRequest> {
        /**
         * <p>
         * The ID of the Savings Plan.
         * </p>
         * 
         * @param savingsPlanId
         *        The ID of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanId(String savingsPlanId);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SavingsPlanRateFilter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SavingsPlanRateFilter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlanRateFilter>.Builder} avoiding
         * the need to create one manually via {@link List<SavingsPlanRateFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanRateFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<SavingsPlanRateFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<SavingsPlanRateFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<SavingsPlanRateFilter>)
         */
        Builder filters(Consumer<SavingsPlanRateFilter.Builder>... filters);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve additional results, make another call
         * with the returned token value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve additional results, make
         *        another call with the returned token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SavingsplansRequest.BuilderImpl implements Builder {
        private String savingsPlanId;

        private List<SavingsPlanRateFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlanRatesRequest model) {
            super(model);
            savingsPlanId(model.savingsPlanId);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getSavingsPlanId() {
            return savingsPlanId;
        }

        @Override
        public final Builder savingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
            return this;
        }

        public final void setSavingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
        }

        public final Collection<SavingsPlanRateFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(SavingsPlanRateFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<SavingsPlanRateFilter> filters) {
            this.filters = SavingsPlanRateFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SavingsPlanRateFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanRateFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SavingsPlanRateFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<SavingsPlanRateFilter.BuilderImpl> filters) {
            this.filters = SavingsPlanRateFilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlanRatesRequest build() {
            return new DescribeSavingsPlanRatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
