/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlansOfferingsRequest extends SavingsplansRequest implements
        ToCopyableBuilder<DescribeSavingsPlansOfferingsRequest.Builder, DescribeSavingsPlansOfferingsRequest> {
    private static final SdkField<List<String>> OFFERING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::offeringIds))
            .setter(setter(Builder::offeringIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PAYMENT_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::paymentOptionsAsStrings))
            .setter(setter(Builder::paymentOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::productTypeAsString)).setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productType").build()).build();

    private static final SdkField<List<String>> PLAN_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::planTypesAsStrings))
            .setter(setter(Builder::planTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Long>> DURATIONS_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::durations))
            .setter(setter(Builder::durations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CURRENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::currenciesAsStrings))
            .setter(setter(Builder::currenciesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DESCRIPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::descriptions))
            .setter(setter(Builder::descriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVICE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::serviceCodes))
            .setter(setter(Builder::serviceCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USAGE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::usageTypes))
            .setter(setter(Builder::usageTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SavingsPlanOfferingFilterElement>> FILTERS_FIELD = SdkField
            .<List<SavingsPlanOfferingFilterElement>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanOfferingFilterElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanOfferingFilterElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSavingsPlansOfferingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_IDS_FIELD,
            PAYMENT_OPTIONS_FIELD, PRODUCT_TYPE_FIELD, PLAN_TYPES_FIELD, DURATIONS_FIELD, CURRENCIES_FIELD, DESCRIPTIONS_FIELD,
            SERVICE_CODES_FIELD, USAGE_TYPES_FIELD, OPERATIONS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> offeringIds;

    private final List<String> paymentOptions;

    private final String productType;

    private final List<String> planTypes;

    private final List<Long> durations;

    private final List<String> currencies;

    private final List<String> descriptions;

    private final List<String> serviceCodes;

    private final List<String> usageTypes;

    private final List<String> operations;

    private final List<SavingsPlanOfferingFilterElement> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeSavingsPlansOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.offeringIds = builder.offeringIds;
        this.paymentOptions = builder.paymentOptions;
        this.productType = builder.productType;
        this.planTypes = builder.planTypes;
        this.durations = builder.durations;
        this.currencies = builder.currencies;
        this.descriptions = builder.descriptions;
        this.serviceCodes = builder.serviceCodes;
        this.usageTypes = builder.usageTypes;
        this.operations = builder.operations;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The IDs of the offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the offerings.
     */
    public List<String> offeringIds() {
        return offeringIds;
    }

    /**
     * <p>
     * The payment options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The payment options.
     */
    public List<SavingsPlanPaymentOption> paymentOptions() {
        return SavingsPlanPaymentOptionListCopier.copyStringToEnum(paymentOptions);
    }

    /**
     * <p>
     * The payment options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The payment options.
     */
    public List<String> paymentOptionsAsStrings() {
        return paymentOptions;
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link SavingsPlanProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type.
     * @see SavingsPlanProductType
     */
    public SavingsPlanProductType productType() {
        return SavingsPlanProductType.fromValue(productType);
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link SavingsPlanProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type.
     * @see SavingsPlanProductType
     */
    public String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The plan type.
     */
    public List<SavingsPlanType> planTypes() {
        return SavingsPlanTypeListCopier.copyStringToEnum(planTypes);
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The plan type.
     */
    public List<String> planTypesAsStrings() {
        return planTypes;
    }

    /**
     * <p>
     * The durations, in seconds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The durations, in seconds.
     */
    public List<Long> durations() {
        return durations;
    }

    /**
     * <p>
     * The currencies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The currencies.
     */
    public List<CurrencyCode> currencies() {
        return CurrencyListCopier.copyStringToEnum(currencies);
    }

    /**
     * <p>
     * The currencies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The currencies.
     */
    public List<String> currenciesAsStrings() {
        return currencies;
    }

    /**
     * <p>
     * The descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The descriptions.
     */
    public List<String> descriptions() {
        return descriptions;
    }

    /**
     * <p>
     * The services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The services.
     */
    public List<String> serviceCodes() {
        return serviceCodes;
    }

    /**
     * <p>
     * The usage details of the line item in the billing report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The usage details of the line item in the billing report.
     */
    public List<String> usageTypes() {
        return usageTypes;
    }

    /**
     * <p>
     * The specific AWS operation for the line item in the billing report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The specific AWS operation for the line item in the billing report.
     */
    public List<String> operations() {
        return operations;
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filters.
     */
    public List<SavingsPlanOfferingFilterElement> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve additional results, make another call
     * with the returned token value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve additional results, make another
     *         call with the returned token value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(offeringIds());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(planTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(durations());
        hashCode = 31 * hashCode + Objects.hashCode(currenciesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(descriptions());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCodes());
        hashCode = 31 * hashCode + Objects.hashCode(usageTypes());
        hashCode = 31 * hashCode + Objects.hashCode(operations());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansOfferingsRequest)) {
            return false;
        }
        DescribeSavingsPlansOfferingsRequest other = (DescribeSavingsPlansOfferingsRequest) obj;
        return Objects.equals(offeringIds(), other.offeringIds())
                && Objects.equals(paymentOptionsAsStrings(), other.paymentOptionsAsStrings())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(planTypesAsStrings(), other.planTypesAsStrings())
                && Objects.equals(durations(), other.durations())
                && Objects.equals(currenciesAsStrings(), other.currenciesAsStrings())
                && Objects.equals(descriptions(), other.descriptions()) && Objects.equals(serviceCodes(), other.serviceCodes())
                && Objects.equals(usageTypes(), other.usageTypes()) && Objects.equals(operations(), other.operations())
                && Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSavingsPlansOfferingsRequest").add("OfferingIds", offeringIds())
                .add("PaymentOptions", paymentOptionsAsStrings()).add("ProductType", productTypeAsString())
                .add("PlanTypes", planTypesAsStrings()).add("Durations", durations()).add("Currencies", currenciesAsStrings())
                .add("Descriptions", descriptions()).add("ServiceCodes", serviceCodes()).add("UsageTypes", usageTypes())
                .add("Operations", operations()).add("Filters", filters()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringIds":
            return Optional.ofNullable(clazz.cast(offeringIds()));
        case "paymentOptions":
            return Optional.ofNullable(clazz.cast(paymentOptionsAsStrings()));
        case "productType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "planTypes":
            return Optional.ofNullable(clazz.cast(planTypesAsStrings()));
        case "durations":
            return Optional.ofNullable(clazz.cast(durations()));
        case "currencies":
            return Optional.ofNullable(clazz.cast(currenciesAsStrings()));
        case "descriptions":
            return Optional.ofNullable(clazz.cast(descriptions()));
        case "serviceCodes":
            return Optional.ofNullable(clazz.cast(serviceCodes()));
        case "usageTypes":
            return Optional.ofNullable(clazz.cast(usageTypes()));
        case "operations":
            return Optional.ofNullable(clazz.cast(operations()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlansOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSavingsPlansOfferingsRequest> {
        /**
         * <p>
         * The IDs of the offerings.
         * </p>
         * 
         * @param offeringIds
         *        The IDs of the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringIds(Collection<String> offeringIds);

        /**
         * <p>
         * The IDs of the offerings.
         * </p>
         * 
         * @param offeringIds
         *        The IDs of the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringIds(String... offeringIds);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param paymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOptionsWithStrings(Collection<String> paymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param paymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOptionsWithStrings(String... paymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param paymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOptions(Collection<SavingsPlanPaymentOption> paymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param paymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOptions(SavingsPlanPaymentOption... paymentOptions);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productType
         *        The product type.
         * @see SavingsPlanProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productType
         *        The product type.
         * @see SavingsPlanProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanProductType
         */
        Builder productType(SavingsPlanProductType productType);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planTypes
         *        The plan type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planTypesWithStrings(Collection<String> planTypes);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planTypes
         *        The plan type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planTypesWithStrings(String... planTypes);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planTypes
         *        The plan type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planTypes(Collection<SavingsPlanType> planTypes);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planTypes
         *        The plan type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planTypes(SavingsPlanType... planTypes);

        /**
         * <p>
         * The durations, in seconds.
         * </p>
         * 
         * @param durations
         *        The durations, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durations(Collection<Long> durations);

        /**
         * <p>
         * The durations, in seconds.
         * </p>
         * 
         * @param durations
         *        The durations, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durations(Long... durations);

        /**
         * <p>
         * The currencies.
         * </p>
         * 
         * @param currencies
         *        The currencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currenciesWithStrings(Collection<String> currencies);

        /**
         * <p>
         * The currencies.
         * </p>
         * 
         * @param currencies
         *        The currencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currenciesWithStrings(String... currencies);

        /**
         * <p>
         * The currencies.
         * </p>
         * 
         * @param currencies
         *        The currencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencies(Collection<CurrencyCode> currencies);

        /**
         * <p>
         * The currencies.
         * </p>
         * 
         * @param currencies
         *        The currencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencies(CurrencyCode... currencies);

        /**
         * <p>
         * The descriptions.
         * </p>
         * 
         * @param descriptions
         *        The descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(Collection<String> descriptions);

        /**
         * <p>
         * The descriptions.
         * </p>
         * 
         * @param descriptions
         *        The descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(String... descriptions);

        /**
         * <p>
         * The services.
         * </p>
         * 
         * @param serviceCodes
         *        The services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodes(Collection<String> serviceCodes);

        /**
         * <p>
         * The services.
         * </p>
         * 
         * @param serviceCodes
         *        The services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodes(String... serviceCodes);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageTypes
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTypes(Collection<String> usageTypes);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageTypes
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTypes(String... usageTypes);

        /**
         * <p>
         * The specific AWS operation for the line item in the billing report.
         * </p>
         * 
         * @param operations
         *        The specific AWS operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<String> operations);

        /**
         * <p>
         * The specific AWS operation for the line item in the billing report.
         * </p>
         * 
         * @param operations
         *        The specific AWS operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(String... operations);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SavingsPlanOfferingFilterElement> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SavingsPlanOfferingFilterElement... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlanOfferingFilterElement>.Builder}
         * avoiding the need to create one manually via {@link List<SavingsPlanOfferingFilterElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanOfferingFilterElement>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<SavingsPlanOfferingFilterElement>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<SavingsPlanOfferingFilterElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<SavingsPlanOfferingFilterElement>)
         */
        Builder filters(Consumer<SavingsPlanOfferingFilterElement.Builder>... filters);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve additional results, make another call
         * with the returned token value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve additional results, make
         *        another call with the returned token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SavingsplansRequest.BuilderImpl implements Builder {
        private List<String> offeringIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> paymentOptions = DefaultSdkAutoConstructList.getInstance();

        private String productType;

        private List<String> planTypes = DefaultSdkAutoConstructList.getInstance();

        private List<Long> durations = DefaultSdkAutoConstructList.getInstance();

        private List<String> currencies = DefaultSdkAutoConstructList.getInstance();

        private List<String> descriptions = DefaultSdkAutoConstructList.getInstance();

        private List<String> serviceCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> usageTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> operations = DefaultSdkAutoConstructList.getInstance();

        private List<SavingsPlanOfferingFilterElement> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansOfferingsRequest model) {
            super(model);
            offeringIds(model.offeringIds);
            paymentOptionsWithStrings(model.paymentOptions);
            productType(model.productType);
            planTypesWithStrings(model.planTypes);
            durations(model.durations);
            currenciesWithStrings(model.currencies);
            descriptions(model.descriptions);
            serviceCodes(model.serviceCodes);
            usageTypes(model.usageTypes);
            operations(model.operations);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getOfferingIds() {
            return offeringIds;
        }

        @Override
        public final Builder offeringIds(Collection<String> offeringIds) {
            this.offeringIds = UUIDsCopier.copy(offeringIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringIds(String... offeringIds) {
            offeringIds(Arrays.asList(offeringIds));
            return this;
        }

        public final void setOfferingIds(Collection<String> offeringIds) {
            this.offeringIds = UUIDsCopier.copy(offeringIds);
        }

        public final Collection<String> getPaymentOptionsAsStrings() {
            return paymentOptions;
        }

        @Override
        public final Builder paymentOptionsWithStrings(Collection<String> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copy(paymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentOptionsWithStrings(String... paymentOptions) {
            paymentOptionsWithStrings(Arrays.asList(paymentOptions));
            return this;
        }

        @Override
        public final Builder paymentOptions(Collection<SavingsPlanPaymentOption> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copyEnumToString(paymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentOptions(SavingsPlanPaymentOption... paymentOptions) {
            paymentOptions(Arrays.asList(paymentOptions));
            return this;
        }

        public final void setPaymentOptionsWithStrings(Collection<String> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copy(paymentOptions);
        }

        public final String getProductTypeAsString() {
            return productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(SavingsPlanProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public final Collection<String> getPlanTypesAsStrings() {
            return planTypes;
        }

        @Override
        public final Builder planTypesWithStrings(Collection<String> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copy(planTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder planTypesWithStrings(String... planTypes) {
            planTypesWithStrings(Arrays.asList(planTypes));
            return this;
        }

        @Override
        public final Builder planTypes(Collection<SavingsPlanType> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copyEnumToString(planTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder planTypes(SavingsPlanType... planTypes) {
            planTypes(Arrays.asList(planTypes));
            return this;
        }

        public final void setPlanTypesWithStrings(Collection<String> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copy(planTypes);
        }

        public final Collection<Long> getDurations() {
            return durations;
        }

        @Override
        public final Builder durations(Collection<Long> durations) {
            this.durations = DurationsListCopier.copy(durations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durations(Long... durations) {
            durations(Arrays.asList(durations));
            return this;
        }

        public final void setDurations(Collection<Long> durations) {
            this.durations = DurationsListCopier.copy(durations);
        }

        public final Collection<String> getCurrenciesAsStrings() {
            return currencies;
        }

        @Override
        public final Builder currenciesWithStrings(Collection<String> currencies) {
            this.currencies = CurrencyListCopier.copy(currencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currenciesWithStrings(String... currencies) {
            currenciesWithStrings(Arrays.asList(currencies));
            return this;
        }

        @Override
        public final Builder currencies(Collection<CurrencyCode> currencies) {
            this.currencies = CurrencyListCopier.copyEnumToString(currencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currencies(CurrencyCode... currencies) {
            currencies(Arrays.asList(currencies));
            return this;
        }

        public final void setCurrenciesWithStrings(Collection<String> currencies) {
            this.currencies = CurrencyListCopier.copy(currencies);
        }

        public final Collection<String> getDescriptions() {
            return descriptions;
        }

        @Override
        public final Builder descriptions(Collection<String> descriptions) {
            this.descriptions = SavingsPlanDescriptionsListCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(String... descriptions) {
            descriptions(Arrays.asList(descriptions));
            return this;
        }

        public final void setDescriptions(Collection<String> descriptions) {
            this.descriptions = SavingsPlanDescriptionsListCopier.copy(descriptions);
        }

        public final Collection<String> getServiceCodes() {
            return serviceCodes;
        }

        @Override
        public final Builder serviceCodes(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanServiceCodeListCopier.copy(serviceCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodes(String... serviceCodes) {
            serviceCodes(Arrays.asList(serviceCodes));
            return this;
        }

        public final void setServiceCodes(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanServiceCodeListCopier.copy(serviceCodes);
        }

        public final Collection<String> getUsageTypes() {
            return usageTypes;
        }

        @Override
        public final Builder usageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanUsageTypeListCopier.copy(usageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageTypes(String... usageTypes) {
            usageTypes(Arrays.asList(usageTypes));
            return this;
        }

        public final void setUsageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanUsageTypeListCopier.copy(usageTypes);
        }

        public final Collection<String> getOperations() {
            return operations;
        }

        @Override
        public final Builder operations(Collection<String> operations) {
            this.operations = SavingsPlanOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(String... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = SavingsPlanOperationListCopier.copy(operations);
        }

        public final Collection<SavingsPlanOfferingFilterElement.Builder> getFilters() {
            return filters != null ? filters.stream().map(SavingsPlanOfferingFilterElement::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<SavingsPlanOfferingFilterElement> filters) {
            this.filters = SavingsPlanOfferingFiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SavingsPlanOfferingFilterElement... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanOfferingFilterElement.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SavingsPlanOfferingFilterElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<SavingsPlanOfferingFilterElement.BuilderImpl> filters) {
            this.filters = SavingsPlanOfferingFiltersListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlansOfferingsRequest build() {
            return new DescribeSavingsPlansOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
