/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlansRequest extends SavingsplansRequest implements
        ToCopyableBuilder<DescribeSavingsPlansRequest.Builder, DescribeSavingsPlansRequest> {
    private static final SdkField<List<String>> SAVINGS_PLAN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansRequest::savingsPlanArns))
            .setter(setter(Builder::savingsPlanArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAVINGS_PLAN_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansRequest::savingsPlanIds))
            .setter(setter(Builder::savingsPlanIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSavingsPlansRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeSavingsPlansRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SavingsPlanFilter>> FILTERS_FIELD = SdkField
            .<List<SavingsPlanFilter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ARNS_FIELD,
            SAVINGS_PLAN_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATES_FIELD, FILTERS_FIELD));

    private final List<String> savingsPlanArns;

    private final List<String> savingsPlanIds;

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> states;

    private final List<SavingsPlanFilter> filters;

    private DescribeSavingsPlansRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlanArns = builder.savingsPlanArns;
        this.savingsPlanIds = builder.savingsPlanIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.states = builder.states;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the Savings Plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the Savings Plans.
     */
    public List<String> savingsPlanArns() {
        return savingsPlanArns;
    }

    /**
     * <p>
     * The IDs of the Savings Plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Savings Plans.
     */
    public List<String> savingsPlanIds() {
        return savingsPlanIds;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve additional results, make another call
     * with the returned token value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve additional results, make another
     *         call with the returned token value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The states.
     */
    public List<SavingsPlanState> states() {
        return SavingsPlanStateListCopier.copyStringToEnum(states);
    }

    /**
     * <p>
     * The states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The states.
     */
    public List<String> statesAsStrings() {
        return states;
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The filters.
     */
    public List<SavingsPlanFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanArns());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(statesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansRequest)) {
            return false;
        }
        DescribeSavingsPlansRequest other = (DescribeSavingsPlansRequest) obj;
        return Objects.equals(savingsPlanArns(), other.savingsPlanArns())
                && Objects.equals(savingsPlanIds(), other.savingsPlanIds()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(statesAsStrings(), other.statesAsStrings())
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSavingsPlansRequest").add("SavingsPlanArns", savingsPlanArns())
                .add("SavingsPlanIds", savingsPlanIds()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("States", statesAsStrings()).add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanArns":
            return Optional.ofNullable(clazz.cast(savingsPlanArns()));
        case "savingsPlanIds":
            return Optional.ofNullable(clazz.cast(savingsPlanIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "states":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlansRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSavingsPlansRequest> {
        /**
         * <p>
         * The Amazon Resource Names (ARN) of the Savings Plans.
         * </p>
         * 
         * @param savingsPlanArns
         *        The Amazon Resource Names (ARN) of the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArns(Collection<String> savingsPlanArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the Savings Plans.
         * </p>
         * 
         * @param savingsPlanArns
         *        The Amazon Resource Names (ARN) of the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArns(String... savingsPlanArns);

        /**
         * <p>
         * The IDs of the Savings Plans.
         * </p>
         * 
         * @param savingsPlanIds
         *        The IDs of the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanIds(Collection<String> savingsPlanIds);

        /**
         * <p>
         * The IDs of the Savings Plans.
         * </p>
         * 
         * @param savingsPlanIds
         *        The IDs of the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanIds(String... savingsPlanIds);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve additional results, make another call
         * with the returned token value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve additional results, make
         *        another call with the returned token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The states.
         * </p>
         * 
         * @param states
         *        The states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * The states.
         * </p>
         * 
         * @param states
         *        The states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * The states.
         * </p>
         * 
         * @param states
         *        The states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<SavingsPlanState> states);

        /**
         * <p>
         * The states.
         * </p>
         * 
         * @param states
         *        The states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(SavingsPlanState... states);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SavingsPlanFilter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SavingsPlanFilter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlanFilter>.Builder} avoiding the
         * need to create one manually via {@link List<SavingsPlanFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<SavingsPlanFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<SavingsPlanFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<SavingsPlanFilter>)
         */
        Builder filters(Consumer<SavingsPlanFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SavingsplansRequest.BuilderImpl implements Builder {
        private List<String> savingsPlanArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> savingsPlanIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private List<SavingsPlanFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansRequest model) {
            super(model);
            savingsPlanArns(model.savingsPlanArns);
            savingsPlanIds(model.savingsPlanIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            statesWithStrings(model.states);
            filters(model.filters);
        }

        public final Collection<String> getSavingsPlanArns() {
            return savingsPlanArns;
        }

        @Override
        public final Builder savingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnListCopier.copy(savingsPlanArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanArns(String... savingsPlanArns) {
            savingsPlanArns(Arrays.asList(savingsPlanArns));
            return this;
        }

        public final void setSavingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnListCopier.copy(savingsPlanArns);
        }

        public final Collection<String> getSavingsPlanIds() {
            return savingsPlanIds;
        }

        @Override
        public final Builder savingsPlanIds(Collection<String> savingsPlanIds) {
            this.savingsPlanIds = SavingsPlanIdListCopier.copy(savingsPlanIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanIds(String... savingsPlanIds) {
            savingsPlanIds(Arrays.asList(savingsPlanIds));
            return this;
        }

        public final void setSavingsPlanIds(Collection<String> savingsPlanIds) {
            this.savingsPlanIds = SavingsPlanIdListCopier.copy(savingsPlanIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Collection<String> getStatesAsStrings() {
            return states;
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = SavingsPlanStateListCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<SavingsPlanState> states) {
            this.states = SavingsPlanStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(SavingsPlanState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final void setStatesWithStrings(Collection<String> states) {
            this.states = SavingsPlanStateListCopier.copy(states);
        }

        public final Collection<SavingsPlanFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(SavingsPlanFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<SavingsPlanFilter> filters) {
            this.filters = SavingsPlanFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SavingsPlanFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SavingsPlanFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<SavingsPlanFilter.BuilderImpl> filters) {
            this.filters = SavingsPlanFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlansRequest build() {
            return new DescribeSavingsPlansRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
