/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlansResponse extends SavingsplansResponse implements
        ToCopyableBuilder<DescribeSavingsPlansResponse.Builder, DescribeSavingsPlansResponse> {
    private static final SdkField<List<SavingsPlan>> SAVINGS_PLANS_FIELD = SdkField
            .<List<SavingsPlan>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSavingsPlansResponse::savingsPlans))
            .setter(setter(Builder::savingsPlans))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlans").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlan> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlan::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSavingsPlansResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SavingsPlan> savingsPlans;

    private final String nextToken;

    private DescribeSavingsPlansResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlans = builder.savingsPlans;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the Savings Plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Savings Plans.
     */
    public List<SavingsPlan> savingsPlans() {
        return savingsPlans;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlans());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansResponse)) {
            return false;
        }
        DescribeSavingsPlansResponse other = (DescribeSavingsPlansResponse) obj;
        return Objects.equals(savingsPlans(), other.savingsPlans()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSavingsPlansResponse").add("SavingsPlans", savingsPlans()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlans":
            return Optional.ofNullable(clazz.cast(savingsPlans()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansResponse, T> g) {
        return obj -> g.apply((DescribeSavingsPlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSavingsPlansResponse> {
        /**
         * <p>
         * Information about the Savings Plans.
         * </p>
         * 
         * @param savingsPlans
         *        Information about the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlans(Collection<SavingsPlan> savingsPlans);

        /**
         * <p>
         * Information about the Savings Plans.
         * </p>
         * 
         * @param savingsPlans
         *        Information about the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlans(SavingsPlan... savingsPlans);

        /**
         * <p>
         * Information about the Savings Plans.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlan>.Builder} avoiding the need to
         * create one manually via {@link List<SavingsPlan>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlan>.Builder#build()} is called immediately and its
         * result is passed to {@link #savingsPlans(List<SavingsPlan>)}.
         * 
         * @param savingsPlans
         *        a consumer that will call methods on {@link List<SavingsPlan>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlans(List<SavingsPlan>)
         */
        Builder savingsPlans(Consumer<SavingsPlan.Builder>... savingsPlans);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SavingsplansResponse.BuilderImpl implements Builder {
        private List<SavingsPlan> savingsPlans = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansResponse model) {
            super(model);
            savingsPlans(model.savingsPlans);
            nextToken(model.nextToken);
        }

        public final Collection<SavingsPlan.Builder> getSavingsPlans() {
            return savingsPlans != null ? savingsPlans.stream().map(SavingsPlan::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder savingsPlans(Collection<SavingsPlan> savingsPlans) {
            this.savingsPlans = SavingsPlanListCopier.copy(savingsPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlans(SavingsPlan... savingsPlans) {
            savingsPlans(Arrays.asList(savingsPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlans(Consumer<SavingsPlan.Builder>... savingsPlans) {
            savingsPlans(Stream.of(savingsPlans).map(c -> SavingsPlan.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSavingsPlans(Collection<SavingsPlan.BuilderImpl> savingsPlans) {
            this.savingsPlans = SavingsPlanListCopier.copyFromBuilder(savingsPlans);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSavingsPlansResponse build() {
            return new DescribeSavingsPlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
