/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFiltersListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOptionListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductTypeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateOperationListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateServiceCode;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateServiceCodeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanRateUsageTypeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanType;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanTypeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansRequest;
import software.amazon.awssdk.services.savingsplans.model.UUIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSavingsPlansOfferingRatesRequest
extends SavingsplansRequest
implements ToCopyableBuilder<Builder, DescribeSavingsPlansOfferingRatesRequest> {
    private static final SdkField<List<String>> SAVINGS_PLAN_OFFERING_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::savingsPlanOfferingIds)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::savingsPlanOfferingIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanOfferingIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SAVINGS_PLAN_PAYMENT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::savingsPlanPaymentOptionsAsStrings)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::savingsPlanPaymentOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanPaymentOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SAVINGS_PLAN_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::savingsPlanTypesAsStrings)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::savingsPlanTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::productsAsStrings)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::productsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("products").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::serviceCodesAsStrings)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::serviceCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::usageTypes)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::usageTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::operations)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::operations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SavingsPlanOfferingRateFilterElement>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::filters)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlanOfferingRateFilterElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::nextToken)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeSavingsPlansOfferingRatesRequest.getter(DescribeSavingsPlansOfferingRatesRequest::maxResults)).setter(DescribeSavingsPlansOfferingRatesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_OFFERING_IDS_FIELD, SAVINGS_PLAN_PAYMENT_OPTIONS_FIELD, SAVINGS_PLAN_TYPES_FIELD, PRODUCTS_FIELD, SERVICE_CODES_FIELD, USAGE_TYPES_FIELD, OPERATIONS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> savingsPlanOfferingIds;
    private final List<String> savingsPlanPaymentOptions;
    private final List<String> savingsPlanTypes;
    private final List<String> products;
    private final List<String> serviceCodes;
    private final List<String> usageTypes;
    private final List<String> operations;
    private final List<SavingsPlanOfferingRateFilterElement> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeSavingsPlansOfferingRatesRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlanOfferingIds = builder.savingsPlanOfferingIds;
        this.savingsPlanPaymentOptions = builder.savingsPlanPaymentOptions;
        this.savingsPlanTypes = builder.savingsPlanTypes;
        this.products = builder.products;
        this.serviceCodes = builder.serviceCodes;
        this.usageTypes = builder.usageTypes;
        this.operations = builder.operations;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public boolean hasSavingsPlanOfferingIds() {
        return this.savingsPlanOfferingIds != null && !(this.savingsPlanOfferingIds instanceof SdkAutoConstructList);
    }

    public List<String> savingsPlanOfferingIds() {
        return this.savingsPlanOfferingIds;
    }

    public List<SavingsPlanPaymentOption> savingsPlanPaymentOptions() {
        return SavingsPlanPaymentOptionListCopier.copyStringToEnum(this.savingsPlanPaymentOptions);
    }

    public boolean hasSavingsPlanPaymentOptions() {
        return this.savingsPlanPaymentOptions != null && !(this.savingsPlanPaymentOptions instanceof SdkAutoConstructList);
    }

    public List<String> savingsPlanPaymentOptionsAsStrings() {
        return this.savingsPlanPaymentOptions;
    }

    public List<SavingsPlanType> savingsPlanTypes() {
        return SavingsPlanTypeListCopier.copyStringToEnum(this.savingsPlanTypes);
    }

    public boolean hasSavingsPlanTypes() {
        return this.savingsPlanTypes != null && !(this.savingsPlanTypes instanceof SdkAutoConstructList);
    }

    public List<String> savingsPlanTypesAsStrings() {
        return this.savingsPlanTypes;
    }

    public List<SavingsPlanProductType> products() {
        return SavingsPlanProductTypeListCopier.copyStringToEnum(this.products);
    }

    public boolean hasProducts() {
        return this.products != null && !(this.products instanceof SdkAutoConstructList);
    }

    public List<String> productsAsStrings() {
        return this.products;
    }

    public List<SavingsPlanRateServiceCode> serviceCodes() {
        return SavingsPlanRateServiceCodeListCopier.copyStringToEnum(this.serviceCodes);
    }

    public boolean hasServiceCodes() {
        return this.serviceCodes != null && !(this.serviceCodes instanceof SdkAutoConstructList);
    }

    public List<String> serviceCodesAsStrings() {
        return this.serviceCodes;
    }

    public boolean hasUsageTypes() {
        return this.usageTypes != null && !(this.usageTypes instanceof SdkAutoConstructList);
    }

    public List<String> usageTypes() {
        return this.usageTypes;
    }

    public boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public List<String> operations() {
        return this.operations;
    }

    public boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public List<SavingsPlanOfferingRateFilterElement> filters() {
        return this.filters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanOfferingIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanPaymentOptionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.productsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCodesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.operations());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansOfferingRatesRequest)) {
            return false;
        }
        DescribeSavingsPlansOfferingRatesRequest other = (DescribeSavingsPlansOfferingRatesRequest)((Object)obj);
        return Objects.equals(this.savingsPlanOfferingIds(), other.savingsPlanOfferingIds()) && Objects.equals(this.savingsPlanPaymentOptionsAsStrings(), other.savingsPlanPaymentOptionsAsStrings()) && Objects.equals(this.savingsPlanTypesAsStrings(), other.savingsPlanTypesAsStrings()) && Objects.equals(this.productsAsStrings(), other.productsAsStrings()) && Objects.equals(this.serviceCodesAsStrings(), other.serviceCodesAsStrings()) && Objects.equals(this.usageTypes(), other.usageTypes()) && Objects.equals(this.operations(), other.operations()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSavingsPlansOfferingRatesRequest").add("SavingsPlanOfferingIds", this.savingsPlanOfferingIds()).add("SavingsPlanPaymentOptions", this.savingsPlanPaymentOptionsAsStrings()).add("SavingsPlanTypes", this.savingsPlanTypesAsStrings()).add("Products", this.productsAsStrings()).add("ServiceCodes", this.serviceCodesAsStrings()).add("UsageTypes", this.usageTypes()).add("Operations", this.operations()).add("Filters", this.filters()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "savingsPlanOfferingIds": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanOfferingIds()));
            }
            case "savingsPlanPaymentOptions": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanPaymentOptionsAsStrings()));
            }
            case "savingsPlanTypes": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanTypesAsStrings()));
            }
            case "products": {
                return Optional.ofNullable(clazz.cast(this.productsAsStrings()));
            }
            case "serviceCodes": {
                return Optional.ofNullable(clazz.cast(this.serviceCodesAsStrings()));
            }
            case "usageTypes": {
                return Optional.ofNullable(clazz.cast(this.usageTypes()));
            }
            case "operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansOfferingRatesRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlansOfferingRatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SavingsplansRequest.BuilderImpl
    implements Builder {
        private List<String> savingsPlanOfferingIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> savingsPlanPaymentOptions = DefaultSdkAutoConstructList.getInstance();
        private List<String> savingsPlanTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> products = DefaultSdkAutoConstructList.getInstance();
        private List<String> serviceCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> usageTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();
        private List<SavingsPlanOfferingRateFilterElement> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansOfferingRatesRequest model) {
            super(model);
            this.savingsPlanOfferingIds(model.savingsPlanOfferingIds);
            this.savingsPlanPaymentOptionsWithStrings(model.savingsPlanPaymentOptions);
            this.savingsPlanTypesWithStrings(model.savingsPlanTypes);
            this.productsWithStrings(model.products);
            this.serviceCodesWithStrings(model.serviceCodes);
            this.usageTypes(model.usageTypes);
            this.operations(model.operations);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getSavingsPlanOfferingIds() {
            return this.savingsPlanOfferingIds;
        }

        @Override
        public final Builder savingsPlanOfferingIds(Collection<String> savingsPlanOfferingIds) {
            this.savingsPlanOfferingIds = UUIDsCopier.copy(savingsPlanOfferingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanOfferingIds(String ... savingsPlanOfferingIds) {
            this.savingsPlanOfferingIds(Arrays.asList(savingsPlanOfferingIds));
            return this;
        }

        public final void setSavingsPlanOfferingIds(Collection<String> savingsPlanOfferingIds) {
            this.savingsPlanOfferingIds = UUIDsCopier.copy(savingsPlanOfferingIds);
        }

        public final Collection<String> getSavingsPlanPaymentOptionsAsStrings() {
            return this.savingsPlanPaymentOptions;
        }

        @Override
        public final Builder savingsPlanPaymentOptionsWithStrings(Collection<String> savingsPlanPaymentOptions) {
            this.savingsPlanPaymentOptions = SavingsPlanPaymentOptionListCopier.copy(savingsPlanPaymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanPaymentOptionsWithStrings(String ... savingsPlanPaymentOptions) {
            this.savingsPlanPaymentOptionsWithStrings(Arrays.asList(savingsPlanPaymentOptions));
            return this;
        }

        @Override
        public final Builder savingsPlanPaymentOptions(Collection<SavingsPlanPaymentOption> savingsPlanPaymentOptions) {
            this.savingsPlanPaymentOptions = SavingsPlanPaymentOptionListCopier.copyEnumToString(savingsPlanPaymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanPaymentOptions(SavingsPlanPaymentOption ... savingsPlanPaymentOptions) {
            this.savingsPlanPaymentOptions(Arrays.asList(savingsPlanPaymentOptions));
            return this;
        }

        public final void setSavingsPlanPaymentOptionsWithStrings(Collection<String> savingsPlanPaymentOptions) {
            this.savingsPlanPaymentOptions = SavingsPlanPaymentOptionListCopier.copy(savingsPlanPaymentOptions);
        }

        public final Collection<String> getSavingsPlanTypesAsStrings() {
            return this.savingsPlanTypes;
        }

        @Override
        public final Builder savingsPlanTypesWithStrings(Collection<String> savingsPlanTypes) {
            this.savingsPlanTypes = SavingsPlanTypeListCopier.copy(savingsPlanTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanTypesWithStrings(String ... savingsPlanTypes) {
            this.savingsPlanTypesWithStrings(Arrays.asList(savingsPlanTypes));
            return this;
        }

        @Override
        public final Builder savingsPlanTypes(Collection<SavingsPlanType> savingsPlanTypes) {
            this.savingsPlanTypes = SavingsPlanTypeListCopier.copyEnumToString(savingsPlanTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanTypes(SavingsPlanType ... savingsPlanTypes) {
            this.savingsPlanTypes(Arrays.asList(savingsPlanTypes));
            return this;
        }

        public final void setSavingsPlanTypesWithStrings(Collection<String> savingsPlanTypes) {
            this.savingsPlanTypes = SavingsPlanTypeListCopier.copy(savingsPlanTypes);
        }

        public final Collection<String> getProductsAsStrings() {
            return this.products;
        }

        @Override
        public final Builder productsWithStrings(Collection<String> products) {
            this.products = SavingsPlanProductTypeListCopier.copy(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productsWithStrings(String ... products) {
            this.productsWithStrings(Arrays.asList(products));
            return this;
        }

        @Override
        public final Builder products(Collection<SavingsPlanProductType> products) {
            this.products = SavingsPlanProductTypeListCopier.copyEnumToString(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder products(SavingsPlanProductType ... products) {
            this.products(Arrays.asList(products));
            return this;
        }

        public final void setProductsWithStrings(Collection<String> products) {
            this.products = SavingsPlanProductTypeListCopier.copy(products);
        }

        public final Collection<String> getServiceCodesAsStrings() {
            return this.serviceCodes;
        }

        @Override
        public final Builder serviceCodesWithStrings(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanRateServiceCodeListCopier.copy(serviceCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodesWithStrings(String ... serviceCodes) {
            this.serviceCodesWithStrings(Arrays.asList(serviceCodes));
            return this;
        }

        @Override
        public final Builder serviceCodes(Collection<SavingsPlanRateServiceCode> serviceCodes) {
            this.serviceCodes = SavingsPlanRateServiceCodeListCopier.copyEnumToString(serviceCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodes(SavingsPlanRateServiceCode ... serviceCodes) {
            this.serviceCodes(Arrays.asList(serviceCodes));
            return this;
        }

        public final void setServiceCodesWithStrings(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanRateServiceCodeListCopier.copy(serviceCodes);
        }

        public final Collection<String> getUsageTypes() {
            return this.usageTypes;
        }

        @Override
        public final Builder usageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanRateUsageTypeListCopier.copy(usageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageTypes(String ... usageTypes) {
            this.usageTypes(Arrays.asList(usageTypes));
            return this;
        }

        public final void setUsageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanRateUsageTypeListCopier.copy(usageTypes);
        }

        public final Collection<String> getOperations() {
            return this.operations;
        }

        @Override
        public final Builder operations(Collection<String> operations) {
            this.operations = SavingsPlanRateOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(String ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = SavingsPlanRateOperationListCopier.copy(operations);
        }

        public final Collection<SavingsPlanOfferingRateFilterElement.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(SavingsPlanOfferingRateFilterElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<SavingsPlanOfferingRateFilterElement> filters) {
            this.filters = SavingsPlanOfferingRateFiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SavingsPlanOfferingRateFilterElement ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanOfferingRateFilterElement.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (SavingsPlanOfferingRateFilterElement)((SavingsPlanOfferingRateFilterElement.Builder)SavingsPlanOfferingRateFilterElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<SavingsPlanOfferingRateFilterElement.BuilderImpl> filters) {
            this.filters = SavingsPlanOfferingRateFiltersListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlansOfferingRatesRequest build() {
            return new DescribeSavingsPlansOfferingRatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SavingsplansRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSavingsPlansOfferingRatesRequest> {
        public Builder savingsPlanOfferingIds(Collection<String> var1);

        public Builder savingsPlanOfferingIds(String ... var1);

        public Builder savingsPlanPaymentOptionsWithStrings(Collection<String> var1);

        public Builder savingsPlanPaymentOptionsWithStrings(String ... var1);

        public Builder savingsPlanPaymentOptions(Collection<SavingsPlanPaymentOption> var1);

        public Builder savingsPlanPaymentOptions(SavingsPlanPaymentOption ... var1);

        public Builder savingsPlanTypesWithStrings(Collection<String> var1);

        public Builder savingsPlanTypesWithStrings(String ... var1);

        public Builder savingsPlanTypes(Collection<SavingsPlanType> var1);

        public Builder savingsPlanTypes(SavingsPlanType ... var1);

        public Builder productsWithStrings(Collection<String> var1);

        public Builder productsWithStrings(String ... var1);

        public Builder products(Collection<SavingsPlanProductType> var1);

        public Builder products(SavingsPlanProductType ... var1);

        public Builder serviceCodesWithStrings(Collection<String> var1);

        public Builder serviceCodesWithStrings(String ... var1);

        public Builder serviceCodes(Collection<SavingsPlanRateServiceCode> var1);

        public Builder serviceCodes(SavingsPlanRateServiceCode ... var1);

        public Builder usageTypes(Collection<String> var1);

        public Builder usageTypes(String ... var1);

        public Builder operations(Collection<String> var1);

        public Builder operations(String ... var1);

        public Builder filters(Collection<SavingsPlanOfferingRateFilterElement> var1);

        public Builder filters(SavingsPlanOfferingRateFilterElement ... var1);

        public Builder filters(Consumer<SavingsPlanOfferingRateFilterElement.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

