/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.savingsplans.SavingsplansClient;
import software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest;
import software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse;
import software.amazon.awssdk.services.savingsplans.model.InternalServerException;
import software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.ResourceNotFoundException;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansException;
import software.amazon.awssdk.services.savingsplans.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.savingsplans.model.TagResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.TagResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.UntagResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.ValidationException;
import software.amazon.awssdk.services.savingsplans.transform.CreateSavingsPlanRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DescribeSavingsPlanRatesRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DescribeSavingsPlansOfferingRatesRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DescribeSavingsPlansOfferingsRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DescribeSavingsPlansRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.UntagResourceRequestMarshaller;

@SdkInternalApi
final class DefaultSavingsplansClient
implements SavingsplansClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSavingsplansClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "savingsplans";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSavingsPlanResponse createSavingsPlan(CreateSavingsPlanRequest createSavingsPlanRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSavingsPlanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSavingsplansClient.resolveMetricPublishers(this.clientConfiguration, createSavingsPlanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSavingsPlan");
            CreateSavingsPlanResponse createSavingsPlanResponse = (CreateSavingsPlanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSavingsPlan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSavingsPlanRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSavingsPlanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSavingsPlanResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSavingsplansClient.lambda$createSavingsPlan$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSavingsPlanRatesResponse describeSavingsPlanRates(DescribeSavingsPlanRatesRequest describeSavingsPlanRatesRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSavingsPlanRatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSavingsplansClient.resolveMetricPublishers(this.clientConfiguration, describeSavingsPlanRatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSavingsPlanRates");
            DescribeSavingsPlanRatesResponse describeSavingsPlanRatesResponse = (DescribeSavingsPlanRatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSavingsPlanRates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSavingsPlanRatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSavingsPlanRatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSavingsPlanRatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSavingsplansClient.lambda$describeSavingsPlanRates$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSavingsPlansResponse describeSavingsPlans(DescribeSavingsPlansRequest describeSavingsPlansRequest) throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSavingsPlansResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSavingsplansClient.resolveMetricPublishers(this.clientConfiguration, describeSavingsPlansRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSavingsPlans");
            DescribeSavingsPlansResponse describeSavingsPlansResponse = (DescribeSavingsPlansResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSavingsPlans").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSavingsPlansRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSavingsPlansRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSavingsPlansResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSavingsplansClient.lambda$describeSavingsPlans$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSavingsPlansOfferingRatesResponse describeSavingsPlansOfferingRates(DescribeSavingsPlansOfferingRatesRequest describeSavingsPlansOfferingRatesRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSavingsPlansOfferingRatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSavingsplansClient.resolveMetricPublishers(this.clientConfiguration, describeSavingsPlansOfferingRatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSavingsPlansOfferingRates");
            DescribeSavingsPlansOfferingRatesResponse describeSavingsPlansOfferingRatesResponse = (DescribeSavingsPlansOfferingRatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSavingsPlansOfferingRates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSavingsPlansOfferingRatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSavingsPlansOfferingRatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSavingsPlansOfferingRatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSavingsplansClient.lambda$describeSavingsPlansOfferingRates$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSavingsPlansOfferingsResponse describeSavingsPlansOfferings(DescribeSavingsPlansOfferingsRequest describeSavingsPlansOfferingsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSavingsPlansOfferingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSavingsplansClient.resolveMetricPublishers(this.clientConfiguration, describeSavingsPlansOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSavingsPlansOfferings");
            DescribeSavingsPlansOfferingsResponse describeSavingsPlansOfferingsResponse = (DescribeSavingsPlansOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSavingsPlansOfferings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSavingsPlansOfferingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSavingsPlansOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSavingsPlansOfferingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSavingsplansClient.lambda$describeSavingsPlansOfferings$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSavingsplansClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSavingsplansClient.lambda$listTagsForResource$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSavingsplansClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSavingsplansClient.lambda$tagResource$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultSavingsplansClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSavingsplansClient.lambda$untagResource$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SavingsplansException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSavingsPlansOfferings$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSavingsPlansOfferingRates$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSavingsPlans$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSavingsPlanRates$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSavingsPlan$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

