/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlansOfferingRatesRequest extends SavingsplansRequest implements
        ToCopyableBuilder<DescribeSavingsPlansOfferingRatesRequest.Builder, DescribeSavingsPlansOfferingRatesRequest> {
    private static final SdkField<List<String>> SAVINGS_PLAN_OFFERING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("savingsPlanOfferingIds")
            .getter(getter(DescribeSavingsPlansOfferingRatesRequest::savingsPlanOfferingIds))
            .setter(setter(Builder::savingsPlanOfferingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanOfferingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAVINGS_PLAN_PAYMENT_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("savingsPlanPaymentOptions")
            .getter(getter(DescribeSavingsPlansOfferingRatesRequest::savingsPlanPaymentOptionsAsStrings))
            .setter(setter(Builder::savingsPlanPaymentOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanPaymentOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAVINGS_PLAN_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("savingsPlanTypes")
            .getter(getter(DescribeSavingsPlansOfferingRatesRequest::savingsPlanTypesAsStrings))
            .setter(setter(Builder::savingsPlanTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PRODUCTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("products")
            .getter(getter(DescribeSavingsPlansOfferingRatesRequest::productsAsStrings))
            .setter(setter(Builder::productsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("products").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVICE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("serviceCodes")
            .getter(getter(DescribeSavingsPlansOfferingRatesRequest::serviceCodesAsStrings))
            .setter(setter(Builder::serviceCodesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USAGE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("usageTypes")
            .getter(getter(DescribeSavingsPlansOfferingRatesRequest::usageTypes))
            .setter(setter(Builder::usageTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("operations")
            .getter(getter(DescribeSavingsPlansOfferingRatesRequest::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SavingsPlanOfferingRateFilterElement>> FILTERS_FIELD = SdkField
            .<List<SavingsPlanOfferingRateFilterElement>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(DescribeSavingsPlansOfferingRatesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanOfferingRateFilterElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanOfferingRateFilterElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeSavingsPlansOfferingRatesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeSavingsPlansOfferingRatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAVINGS_PLAN_OFFERING_IDS_FIELD, SAVINGS_PLAN_PAYMENT_OPTIONS_FIELD, SAVINGS_PLAN_TYPES_FIELD, PRODUCTS_FIELD,
            SERVICE_CODES_FIELD, USAGE_TYPES_FIELD, OPERATIONS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<String> savingsPlanOfferingIds;

    private final List<String> savingsPlanPaymentOptions;

    private final List<String> savingsPlanTypes;

    private final List<String> products;

    private final List<String> serviceCodes;

    private final List<String> usageTypes;

    private final List<String> operations;

    private final List<SavingsPlanOfferingRateFilterElement> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeSavingsPlansOfferingRatesRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlanOfferingIds = builder.savingsPlanOfferingIds;
        this.savingsPlanPaymentOptions = builder.savingsPlanPaymentOptions;
        this.savingsPlanTypes = builder.savingsPlanTypes;
        this.products = builder.products;
        this.serviceCodes = builder.serviceCodes;
        this.usageTypes = builder.usageTypes;
        this.operations = builder.operations;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the SavingsPlanOfferingIds property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSavingsPlanOfferingIds() {
        return savingsPlanOfferingIds != null && !(savingsPlanOfferingIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSavingsPlanOfferingIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IDs of the offerings.
     */
    public List<String> savingsPlanOfferingIds() {
        return savingsPlanOfferingIds;
    }

    /**
     * <p>
     * The payment options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSavingsPlanPaymentOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The payment options.
     */
    public List<SavingsPlanPaymentOption> savingsPlanPaymentOptions() {
        return SavingsPlanPaymentOptionListCopier.copyStringToEnum(savingsPlanPaymentOptions);
    }

    /**
     * Returns true if the SavingsPlanPaymentOptions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSavingsPlanPaymentOptions() {
        return savingsPlanPaymentOptions != null && !(savingsPlanPaymentOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The payment options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSavingsPlanPaymentOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The payment options.
     */
    public List<String> savingsPlanPaymentOptionsAsStrings() {
        return savingsPlanPaymentOptions;
    }

    /**
     * <p>
     * The plan types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSavingsPlanTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The plan types.
     */
    public List<SavingsPlanType> savingsPlanTypes() {
        return SavingsPlanTypeListCopier.copyStringToEnum(savingsPlanTypes);
    }

    /**
     * Returns true if the SavingsPlanTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasSavingsPlanTypes() {
        return savingsPlanTypes != null && !(savingsPlanTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The plan types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSavingsPlanTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The plan types.
     */
    public List<String> savingsPlanTypesAsStrings() {
        return savingsPlanTypes;
    }

    /**
     * <p>
     * The AWS products.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProducts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS products.
     */
    public List<SavingsPlanProductType> products() {
        return SavingsPlanProductTypeListCopier.copyStringToEnum(products);
    }

    /**
     * Returns true if the Products property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProducts() {
        return products != null && !(products instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS products.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProducts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The AWS products.
     */
    public List<String> productsAsStrings() {
        return products;
    }

    /**
     * <p>
     * The services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The services.
     */
    public List<SavingsPlanRateServiceCode> serviceCodes() {
        return SavingsPlanRateServiceCodeListCopier.copyStringToEnum(serviceCodes);
    }

    /**
     * Returns true if the ServiceCodes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServiceCodes() {
        return serviceCodes != null && !(serviceCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The services.
     */
    public List<String> serviceCodesAsStrings() {
        return serviceCodes;
    }

    /**
     * Returns true if the UsageTypes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUsageTypes() {
        return usageTypes != null && !(usageTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage details of the line item in the billing report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUsageTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The usage details of the line item in the billing report.
     */
    public List<String> usageTypes() {
        return usageTypes;
    }

    /**
     * Returns true if the Operations property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasOperations() {
        return operations != null && !(operations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specific AWS operation for the line item in the billing report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOperations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The specific AWS operation for the line item in the billing report.
     */
    public List<String> operations() {
        return operations;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters.
     */
    public List<SavingsPlanOfferingRateFilterElement> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve additional results, make another call
     * with the returned token value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve additional results, make another
     *         call with the returned token value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlanOfferingIds() ? savingsPlanOfferingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlanPaymentOptions() ? savingsPlanPaymentOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlanTypes() ? savingsPlanTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProducts() ? productsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceCodes() ? serviceCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageTypes() ? usageTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOperations() ? operations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansOfferingRatesRequest)) {
            return false;
        }
        DescribeSavingsPlansOfferingRatesRequest other = (DescribeSavingsPlansOfferingRatesRequest) obj;
        return hasSavingsPlanOfferingIds() == other.hasSavingsPlanOfferingIds()
                && Objects.equals(savingsPlanOfferingIds(), other.savingsPlanOfferingIds())
                && hasSavingsPlanPaymentOptions() == other.hasSavingsPlanPaymentOptions()
                && Objects.equals(savingsPlanPaymentOptionsAsStrings(), other.savingsPlanPaymentOptionsAsStrings())
                && hasSavingsPlanTypes() == other.hasSavingsPlanTypes()
                && Objects.equals(savingsPlanTypesAsStrings(), other.savingsPlanTypesAsStrings())
                && hasProducts() == other.hasProducts() && Objects.equals(productsAsStrings(), other.productsAsStrings())
                && hasServiceCodes() == other.hasServiceCodes()
                && Objects.equals(serviceCodesAsStrings(), other.serviceCodesAsStrings())
                && hasUsageTypes() == other.hasUsageTypes() && Objects.equals(usageTypes(), other.usageTypes())
                && hasOperations() == other.hasOperations() && Objects.equals(operations(), other.operations())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSavingsPlansOfferingRatesRequest")
                .add("SavingsPlanOfferingIds", hasSavingsPlanOfferingIds() ? savingsPlanOfferingIds() : null)
                .add("SavingsPlanPaymentOptions", hasSavingsPlanPaymentOptions() ? savingsPlanPaymentOptionsAsStrings() : null)
                .add("SavingsPlanTypes", hasSavingsPlanTypes() ? savingsPlanTypesAsStrings() : null)
                .add("Products", hasProducts() ? productsAsStrings() : null)
                .add("ServiceCodes", hasServiceCodes() ? serviceCodesAsStrings() : null)
                .add("UsageTypes", hasUsageTypes() ? usageTypes() : null)
                .add("Operations", hasOperations() ? operations() : null).add("Filters", hasFilters() ? filters() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanOfferingIds":
            return Optional.ofNullable(clazz.cast(savingsPlanOfferingIds()));
        case "savingsPlanPaymentOptions":
            return Optional.ofNullable(clazz.cast(savingsPlanPaymentOptionsAsStrings()));
        case "savingsPlanTypes":
            return Optional.ofNullable(clazz.cast(savingsPlanTypesAsStrings()));
        case "products":
            return Optional.ofNullable(clazz.cast(productsAsStrings()));
        case "serviceCodes":
            return Optional.ofNullable(clazz.cast(serviceCodesAsStrings()));
        case "usageTypes":
            return Optional.ofNullable(clazz.cast(usageTypes()));
        case "operations":
            return Optional.ofNullable(clazz.cast(operations()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansOfferingRatesRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlansOfferingRatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSavingsPlansOfferingRatesRequest> {
        /**
         * <p>
         * The IDs of the offerings.
         * </p>
         * 
         * @param savingsPlanOfferingIds
         *        The IDs of the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanOfferingIds(Collection<String> savingsPlanOfferingIds);

        /**
         * <p>
         * The IDs of the offerings.
         * </p>
         * 
         * @param savingsPlanOfferingIds
         *        The IDs of the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanOfferingIds(String... savingsPlanOfferingIds);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param savingsPlanPaymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanPaymentOptionsWithStrings(Collection<String> savingsPlanPaymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param savingsPlanPaymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanPaymentOptionsWithStrings(String... savingsPlanPaymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param savingsPlanPaymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanPaymentOptions(Collection<SavingsPlanPaymentOption> savingsPlanPaymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param savingsPlanPaymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanPaymentOptions(SavingsPlanPaymentOption... savingsPlanPaymentOptions);

        /**
         * <p>
         * The plan types.
         * </p>
         * 
         * @param savingsPlanTypes
         *        The plan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanTypesWithStrings(Collection<String> savingsPlanTypes);

        /**
         * <p>
         * The plan types.
         * </p>
         * 
         * @param savingsPlanTypes
         *        The plan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanTypesWithStrings(String... savingsPlanTypes);

        /**
         * <p>
         * The plan types.
         * </p>
         * 
         * @param savingsPlanTypes
         *        The plan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanTypes(Collection<SavingsPlanType> savingsPlanTypes);

        /**
         * <p>
         * The plan types.
         * </p>
         * 
         * @param savingsPlanTypes
         *        The plan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanTypes(SavingsPlanType... savingsPlanTypes);

        /**
         * <p>
         * The AWS products.
         * </p>
         * 
         * @param products
         *        The AWS products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productsWithStrings(Collection<String> products);

        /**
         * <p>
         * The AWS products.
         * </p>
         * 
         * @param products
         *        The AWS products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productsWithStrings(String... products);

        /**
         * <p>
         * The AWS products.
         * </p>
         * 
         * @param products
         *        The AWS products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder products(Collection<SavingsPlanProductType> products);

        /**
         * <p>
         * The AWS products.
         * </p>
         * 
         * @param products
         *        The AWS products.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder products(SavingsPlanProductType... products);

        /**
         * <p>
         * The services.
         * </p>
         * 
         * @param serviceCodes
         *        The services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodesWithStrings(Collection<String> serviceCodes);

        /**
         * <p>
         * The services.
         * </p>
         * 
         * @param serviceCodes
         *        The services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodesWithStrings(String... serviceCodes);

        /**
         * <p>
         * The services.
         * </p>
         * 
         * @param serviceCodes
         *        The services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodes(Collection<SavingsPlanRateServiceCode> serviceCodes);

        /**
         * <p>
         * The services.
         * </p>
         * 
         * @param serviceCodes
         *        The services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodes(SavingsPlanRateServiceCode... serviceCodes);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageTypes
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTypes(Collection<String> usageTypes);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageTypes
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTypes(String... usageTypes);

        /**
         * <p>
         * The specific AWS operation for the line item in the billing report.
         * </p>
         * 
         * @param operations
         *        The specific AWS operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<String> operations);

        /**
         * <p>
         * The specific AWS operation for the line item in the billing report.
         * </p>
         * 
         * @param operations
         *        The specific AWS operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(String... operations);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SavingsPlanOfferingRateFilterElement> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SavingsPlanOfferingRateFilterElement... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <SavingsPlanOfferingRateFilterElement>.Builder} avoiding the need to create one manually via {@link List
         * <SavingsPlanOfferingRateFilterElement>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanOfferingRateFilterElement>.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(List<SavingsPlanOfferingRateFilterElement>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<SavingsPlanOfferingRateFilterElement>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<SavingsPlanOfferingRateFilterElement>)
         */
        Builder filters(Consumer<SavingsPlanOfferingRateFilterElement.Builder>... filters);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve additional results, make another call
         * with the returned token value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve additional results, make
         *        another call with the returned token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SavingsplansRequest.BuilderImpl implements Builder {
        private List<String> savingsPlanOfferingIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> savingsPlanPaymentOptions = DefaultSdkAutoConstructList.getInstance();

        private List<String> savingsPlanTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> products = DefaultSdkAutoConstructList.getInstance();

        private List<String> serviceCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> usageTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> operations = DefaultSdkAutoConstructList.getInstance();

        private List<SavingsPlanOfferingRateFilterElement> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansOfferingRatesRequest model) {
            super(model);
            savingsPlanOfferingIds(model.savingsPlanOfferingIds);
            savingsPlanPaymentOptionsWithStrings(model.savingsPlanPaymentOptions);
            savingsPlanTypesWithStrings(model.savingsPlanTypes);
            productsWithStrings(model.products);
            serviceCodesWithStrings(model.serviceCodes);
            usageTypes(model.usageTypes);
            operations(model.operations);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getSavingsPlanOfferingIds() {
            if (savingsPlanOfferingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return savingsPlanOfferingIds;
        }

        @Override
        public final Builder savingsPlanOfferingIds(Collection<String> savingsPlanOfferingIds) {
            this.savingsPlanOfferingIds = UUIDsCopier.copy(savingsPlanOfferingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanOfferingIds(String... savingsPlanOfferingIds) {
            savingsPlanOfferingIds(Arrays.asList(savingsPlanOfferingIds));
            return this;
        }

        public final void setSavingsPlanOfferingIds(Collection<String> savingsPlanOfferingIds) {
            this.savingsPlanOfferingIds = UUIDsCopier.copy(savingsPlanOfferingIds);
        }

        public final Collection<String> getSavingsPlanPaymentOptions() {
            if (savingsPlanPaymentOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return savingsPlanPaymentOptions;
        }

        @Override
        public final Builder savingsPlanPaymentOptionsWithStrings(Collection<String> savingsPlanPaymentOptions) {
            this.savingsPlanPaymentOptions = SavingsPlanPaymentOptionListCopier.copy(savingsPlanPaymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanPaymentOptionsWithStrings(String... savingsPlanPaymentOptions) {
            savingsPlanPaymentOptionsWithStrings(Arrays.asList(savingsPlanPaymentOptions));
            return this;
        }

        @Override
        public final Builder savingsPlanPaymentOptions(Collection<SavingsPlanPaymentOption> savingsPlanPaymentOptions) {
            this.savingsPlanPaymentOptions = SavingsPlanPaymentOptionListCopier.copyEnumToString(savingsPlanPaymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanPaymentOptions(SavingsPlanPaymentOption... savingsPlanPaymentOptions) {
            savingsPlanPaymentOptions(Arrays.asList(savingsPlanPaymentOptions));
            return this;
        }

        public final void setSavingsPlanPaymentOptions(Collection<String> savingsPlanPaymentOptions) {
            this.savingsPlanPaymentOptions = SavingsPlanPaymentOptionListCopier.copy(savingsPlanPaymentOptions);
        }

        public final Collection<String> getSavingsPlanTypes() {
            if (savingsPlanTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return savingsPlanTypes;
        }

        @Override
        public final Builder savingsPlanTypesWithStrings(Collection<String> savingsPlanTypes) {
            this.savingsPlanTypes = SavingsPlanTypeListCopier.copy(savingsPlanTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanTypesWithStrings(String... savingsPlanTypes) {
            savingsPlanTypesWithStrings(Arrays.asList(savingsPlanTypes));
            return this;
        }

        @Override
        public final Builder savingsPlanTypes(Collection<SavingsPlanType> savingsPlanTypes) {
            this.savingsPlanTypes = SavingsPlanTypeListCopier.copyEnumToString(savingsPlanTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlanTypes(SavingsPlanType... savingsPlanTypes) {
            savingsPlanTypes(Arrays.asList(savingsPlanTypes));
            return this;
        }

        public final void setSavingsPlanTypes(Collection<String> savingsPlanTypes) {
            this.savingsPlanTypes = SavingsPlanTypeListCopier.copy(savingsPlanTypes);
        }

        public final Collection<String> getProducts() {
            if (products instanceof SdkAutoConstructList) {
                return null;
            }
            return products;
        }

        @Override
        public final Builder productsWithStrings(Collection<String> products) {
            this.products = SavingsPlanProductTypeListCopier.copy(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productsWithStrings(String... products) {
            productsWithStrings(Arrays.asList(products));
            return this;
        }

        @Override
        public final Builder products(Collection<SavingsPlanProductType> products) {
            this.products = SavingsPlanProductTypeListCopier.copyEnumToString(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder products(SavingsPlanProductType... products) {
            products(Arrays.asList(products));
            return this;
        }

        public final void setProducts(Collection<String> products) {
            this.products = SavingsPlanProductTypeListCopier.copy(products);
        }

        public final Collection<String> getServiceCodes() {
            if (serviceCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceCodes;
        }

        @Override
        public final Builder serviceCodesWithStrings(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanRateServiceCodeListCopier.copy(serviceCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodesWithStrings(String... serviceCodes) {
            serviceCodesWithStrings(Arrays.asList(serviceCodes));
            return this;
        }

        @Override
        public final Builder serviceCodes(Collection<SavingsPlanRateServiceCode> serviceCodes) {
            this.serviceCodes = SavingsPlanRateServiceCodeListCopier.copyEnumToString(serviceCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodes(SavingsPlanRateServiceCode... serviceCodes) {
            serviceCodes(Arrays.asList(serviceCodes));
            return this;
        }

        public final void setServiceCodes(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanRateServiceCodeListCopier.copy(serviceCodes);
        }

        public final Collection<String> getUsageTypes() {
            if (usageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return usageTypes;
        }

        @Override
        public final Builder usageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanRateUsageTypeListCopier.copy(usageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageTypes(String... usageTypes) {
            usageTypes(Arrays.asList(usageTypes));
            return this;
        }

        public final void setUsageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanRateUsageTypeListCopier.copy(usageTypes);
        }

        public final Collection<String> getOperations() {
            if (operations instanceof SdkAutoConstructList) {
                return null;
            }
            return operations;
        }

        @Override
        public final Builder operations(Collection<String> operations) {
            this.operations = SavingsPlanRateOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(String... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = SavingsPlanRateOperationListCopier.copy(operations);
        }

        public final Collection<SavingsPlanOfferingRateFilterElement.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(SavingsPlanOfferingRateFilterElement::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<SavingsPlanOfferingRateFilterElement> filters) {
            this.filters = SavingsPlanOfferingRateFiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SavingsPlanOfferingRateFilterElement... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanOfferingRateFilterElement.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SavingsPlanOfferingRateFilterElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<SavingsPlanOfferingRateFilterElement.BuilderImpl> filters) {
            this.filters = SavingsPlanOfferingRateFiltersListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlansOfferingRatesRequest build() {
            return new DescribeSavingsPlansOfferingRatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
