/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Savings Plan rate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlanRate implements SdkPojo, Serializable, ToCopyableBuilder<SavingsPlanRate.Builder, SavingsPlanRate> {
    private static final SdkField<String> RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("rate")
            .getter(getter(SavingsPlanRate::rate)).setter(setter(Builder::rate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rate").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(SavingsPlanRate::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(SavingsPlanRate::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productType").getter(getter(SavingsPlanRate::productTypeAsString)).setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productType").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(SavingsPlanRate::serviceCodeAsString)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(SavingsPlanRate::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(SavingsPlanRate::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<List<SavingsPlanRateProperty>> PROPERTIES_FIELD = SdkField
            .<List<SavingsPlanRateProperty>> builder(MarshallingType.LIST)
            .memberName("properties")
            .getter(getter(SavingsPlanRate::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanRateProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanRateProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RATE_FIELD, CURRENCY_FIELD,
            UNIT_FIELD, PRODUCT_TYPE_FIELD, SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rate;

    private final String currency;

    private final String unit;

    private final String productType;

    private final String serviceCode;

    private final String usageType;

    private final String operation;

    private final List<SavingsPlanRateProperty> properties;

    private SavingsPlanRate(BuilderImpl builder) {
        this.rate = builder.rate;
        this.currency = builder.currency;
        this.unit = builder.unit;
        this.productType = builder.productType;
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The rate.
     * </p>
     * 
     * @return The rate.
     */
    public String rate() {
        return rate;
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public CurrencyCode currency() {
        return CurrencyCode.fromValue(currency);
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link SavingsPlanRateUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit.
     * @see SavingsPlanRateUnit
     */
    public SavingsPlanRateUnit unit() {
        return SavingsPlanRateUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link SavingsPlanRateUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit.
     * @see SavingsPlanRateUnit
     */
    public String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link SavingsPlanProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type.
     * @see SavingsPlanProductType
     */
    public SavingsPlanProductType productType() {
        return SavingsPlanProductType.fromValue(productType);
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link SavingsPlanProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type.
     * @see SavingsPlanProductType
     */
    public String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceCode} will
     * return {@link SavingsPlanRateServiceCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceCodeAsString}.
     * </p>
     * 
     * @return The service.
     * @see SavingsPlanRateServiceCode
     */
    public SavingsPlanRateServiceCode serviceCode() {
        return SavingsPlanRateServiceCode.fromValue(serviceCode);
    }

    /**
     * <p>
     * The service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceCode} will
     * return {@link SavingsPlanRateServiceCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceCodeAsString}.
     * </p>
     * 
     * @return The service.
     * @see SavingsPlanRateServiceCode
     */
    public String serviceCodeAsString() {
        return serviceCode;
    }

    /**
     * <p>
     * The usage details of the line item in the billing report.
     * </p>
     * 
     * @return The usage details of the line item in the billing report.
     */
    public String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The specific AWS operation for the line item in the billing report.
     * </p>
     * 
     * @return The specific AWS operation for the line item in the billing report.
     */
    public String operation() {
        return operation;
    }

    /**
     * Returns true if the Properties property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The properties.
     */
    public List<SavingsPlanRateProperty> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rate());
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlanRate)) {
            return false;
        }
        SavingsPlanRate other = (SavingsPlanRate) obj;
        return Objects.equals(rate(), other.rate()) && Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(unitAsString(), other.unitAsString())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(serviceCodeAsString(), other.serviceCodeAsString())
                && Objects.equals(usageType(), other.usageType()) && Objects.equals(operation(), other.operation())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SavingsPlanRate").add("Rate", rate()).add("Currency", currencyAsString())
                .add("Unit", unitAsString()).add("ProductType", productTypeAsString()).add("ServiceCode", serviceCodeAsString())
                .add("UsageType", usageType()).add("Operation", operation())
                .add("Properties", hasProperties() ? properties() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rate":
            return Optional.ofNullable(clazz.cast(rate()));
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "productType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCodeAsString()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlanRate, T> g) {
        return obj -> g.apply((SavingsPlanRate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlanRate> {
        /**
         * <p>
         * The rate.
         * </p>
         * 
         * @param rate
         *        The rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rate(String rate);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(String currency);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(CurrencyCode currency);

        /**
         * <p>
         * The unit.
         * </p>
         * 
         * @param unit
         *        The unit.
         * @see SavingsPlanRateUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanRateUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit.
         * </p>
         * 
         * @param unit
         *        The unit.
         * @see SavingsPlanRateUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanRateUnit
         */
        Builder unit(SavingsPlanRateUnit unit);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productType
         *        The product type.
         * @see SavingsPlanProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productType
         *        The product type.
         * @see SavingsPlanProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanProductType
         */
        Builder productType(SavingsPlanProductType productType);

        /**
         * <p>
         * The service.
         * </p>
         * 
         * @param serviceCode
         *        The service.
         * @see SavingsPlanRateServiceCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanRateServiceCode
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The service.
         * </p>
         * 
         * @param serviceCode
         *        The service.
         * @see SavingsPlanRateServiceCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanRateServiceCode
         */
        Builder serviceCode(SavingsPlanRateServiceCode serviceCode);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageType
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The specific AWS operation for the line item in the billing report.
         * </p>
         * 
         * @param operation
         *        The specific AWS operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The properties.
         * </p>
         * 
         * @param properties
         *        The properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<SavingsPlanRateProperty> properties);

        /**
         * <p>
         * The properties.
         * </p>
         * 
         * @param properties
         *        The properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(SavingsPlanRateProperty... properties);

        /**
         * <p>
         * The properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlanRateProperty>.Builder} avoiding
         * the need to create one manually via {@link List<SavingsPlanRateProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanRateProperty>.Builder#build()} is called
         * immediately and its result is passed to {@link #properties(List<SavingsPlanRateProperty>)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link List<SavingsPlanRateProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(List<SavingsPlanRateProperty>)
         */
        Builder properties(Consumer<SavingsPlanRateProperty.Builder>... properties);
    }

    static final class BuilderImpl implements Builder {
        private String rate;

        private String currency;

        private String unit;

        private String productType;

        private String serviceCode;

        private String usageType;

        private String operation;

        private List<SavingsPlanRateProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlanRate model) {
            rate(model.rate);
            currency(model.currency);
            unit(model.unit);
            productType(model.productType);
            serviceCode(model.serviceCode);
            usageType(model.usageType);
            operation(model.operation);
            properties(model.properties);
        }

        public final String getRate() {
            return rate;
        }

        @Override
        public final Builder rate(String rate) {
            this.rate = rate;
            return this;
        }

        public final void setRate(String rate) {
            this.rate = rate;
        }

        public final String getCurrency() {
            return currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(SavingsPlanRateUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final String getProductType() {
            return productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(SavingsPlanProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        public final Builder serviceCode(SavingsPlanRateServiceCode serviceCode) {
            this.serviceCode(serviceCode == null ? null : serviceCode.toString());
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getUsageType() {
            return usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        public final String getOperation() {
            return operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final Collection<SavingsPlanRateProperty.Builder> getProperties() {
            if (properties instanceof SdkAutoConstructList) {
                return null;
            }
            return properties != null ? properties.stream().map(SavingsPlanRateProperty::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder properties(Collection<SavingsPlanRateProperty> properties) {
            this.properties = SavingsPlanRatePropertyListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(SavingsPlanRateProperty... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<SavingsPlanRateProperty.Builder>... properties) {
            properties(Stream.of(properties).map(c -> SavingsPlanRateProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProperties(Collection<SavingsPlanRateProperty.BuilderImpl> properties) {
            this.properties = SavingsPlanRatePropertyListCopier.copyFromBuilder(properties);
        }

        @Override
        public SavingsPlanRate build() {
            return new SavingsPlanRate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
