/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlanRatesResponse extends SavingsplansResponse implements
        ToCopyableBuilder<DescribeSavingsPlanRatesResponse.Builder, DescribeSavingsPlanRatesResponse> {
    private static final SdkField<String> SAVINGS_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanId").getter(getter(DescribeSavingsPlanRatesResponse::savingsPlanId))
            .setter(setter(Builder::savingsPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanId").build()).build();

    private static final SdkField<List<SavingsPlanRate>> SEARCH_RESULTS_FIELD = SdkField
            .<List<SavingsPlanRate>> builder(MarshallingType.LIST)
            .memberName("searchResults")
            .getter(getter(DescribeSavingsPlanRatesResponse::searchResults))
            .setter(setter(Builder::searchResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanRate> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanRate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeSavingsPlanRatesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ID_FIELD,
            SEARCH_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String savingsPlanId;

    private final List<SavingsPlanRate> searchResults;

    private final String nextToken;

    private DescribeSavingsPlanRatesResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlanId = builder.savingsPlanId;
        this.searchResults = builder.searchResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the Savings Plan.
     * </p>
     * 
     * @return The ID of the Savings Plan.
     */
    public String savingsPlanId() {
        return savingsPlanId;
    }

    /**
     * Returns true if the SearchResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSearchResults() {
        return searchResults != null && !(searchResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Savings Plans rates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSearchResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Savings Plans rates.
     */
    public List<SavingsPlanRate> searchResults() {
        return searchResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchResults() ? searchResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlanRatesResponse)) {
            return false;
        }
        DescribeSavingsPlanRatesResponse other = (DescribeSavingsPlanRatesResponse) obj;
        return Objects.equals(savingsPlanId(), other.savingsPlanId()) && hasSearchResults() == other.hasSearchResults()
                && Objects.equals(searchResults(), other.searchResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSavingsPlanRatesResponse").add("SavingsPlanId", savingsPlanId())
                .add("SearchResults", hasSearchResults() ? searchResults() : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanId":
            return Optional.ofNullable(clazz.cast(savingsPlanId()));
        case "searchResults":
            return Optional.ofNullable(clazz.cast(searchResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlanRatesResponse, T> g) {
        return obj -> g.apply((DescribeSavingsPlanRatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSavingsPlanRatesResponse> {
        /**
         * <p>
         * The ID of the Savings Plan.
         * </p>
         * 
         * @param savingsPlanId
         *        The ID of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanId(String savingsPlanId);

        /**
         * <p>
         * Information about the Savings Plans rates.
         * </p>
         * 
         * @param searchResults
         *        Information about the Savings Plans rates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchResults(Collection<SavingsPlanRate> searchResults);

        /**
         * <p>
         * Information about the Savings Plans rates.
         * </p>
         * 
         * @param searchResults
         *        Information about the Savings Plans rates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchResults(SavingsPlanRate... searchResults);

        /**
         * <p>
         * Information about the Savings Plans rates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlanRate>.Builder} avoiding the need
         * to create one manually via {@link List<SavingsPlanRate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanRate>.Builder#build()} is called immediately and
         * its result is passed to {@link #searchResults(List<SavingsPlanRate>)}.
         * 
         * @param searchResults
         *        a consumer that will call methods on {@link List<SavingsPlanRate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchResults(List<SavingsPlanRate>)
         */
        Builder searchResults(Consumer<SavingsPlanRate.Builder>... searchResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SavingsplansResponse.BuilderImpl implements Builder {
        private String savingsPlanId;

        private List<SavingsPlanRate> searchResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlanRatesResponse model) {
            super(model);
            savingsPlanId(model.savingsPlanId);
            searchResults(model.searchResults);
            nextToken(model.nextToken);
        }

        public final String getSavingsPlanId() {
            return savingsPlanId;
        }

        @Override
        public final Builder savingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
            return this;
        }

        public final void setSavingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
        }

        public final Collection<SavingsPlanRate.Builder> getSearchResults() {
            if (searchResults instanceof SdkAutoConstructList) {
                return null;
            }
            return searchResults != null ? searchResults.stream().map(SavingsPlanRate::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder searchResults(Collection<SavingsPlanRate> searchResults) {
            this.searchResults = SavingsPlanRateListCopier.copy(searchResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(SavingsPlanRate... searchResults) {
            searchResults(Arrays.asList(searchResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(Consumer<SavingsPlanRate.Builder>... searchResults) {
            searchResults(Stream.of(searchResults).map(c -> SavingsPlanRate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSearchResults(Collection<SavingsPlanRate.BuilderImpl> searchResults) {
            this.searchResults = SavingsPlanRateListCopier.copyFromBuilder(searchResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSavingsPlanRatesResponse build() {
            return new DescribeSavingsPlanRatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
