/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlan;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSavingsPlansResponse
extends SavingsplansResponse
implements ToCopyableBuilder<Builder, DescribeSavingsPlansResponse> {
    private static final SdkField<List<SavingsPlan>> SAVINGS_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("savingsPlans").getter(DescribeSavingsPlansResponse.getter(DescribeSavingsPlansResponse::savingsPlans)).setter(DescribeSavingsPlansResponse.setter(Builder::savingsPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeSavingsPlansResponse.getter(DescribeSavingsPlansResponse::nextToken)).setter(DescribeSavingsPlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SavingsPlan> savingsPlans;
    private final String nextToken;

    private DescribeSavingsPlansResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlans = builder.savingsPlans;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSavingsPlans() {
        return this.savingsPlans != null && !(this.savingsPlans instanceof SdkAutoConstructList);
    }

    public List<SavingsPlan> savingsPlans() {
        return this.savingsPlans;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSavingsPlans() ? this.savingsPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansResponse)) {
            return false;
        }
        DescribeSavingsPlansResponse other = (DescribeSavingsPlansResponse)((Object)obj);
        return this.hasSavingsPlans() == other.hasSavingsPlans() && Objects.equals(this.savingsPlans(), other.savingsPlans()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSavingsPlansResponse").add("SavingsPlans", this.hasSavingsPlans() ? this.savingsPlans() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "savingsPlans": {
                return Optional.ofNullable(clazz.cast(this.savingsPlans()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansResponse, T> g) {
        return obj -> g.apply((DescribeSavingsPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SavingsplansResponse.BuilderImpl
    implements Builder {
        private List<SavingsPlan> savingsPlans = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansResponse model) {
            super(model);
            this.savingsPlans(model.savingsPlans);
            this.nextToken(model.nextToken);
        }

        public final Collection<SavingsPlan.Builder> getSavingsPlans() {
            if (this.savingsPlans instanceof SdkAutoConstructList) {
                return null;
            }
            return this.savingsPlans != null ? (Collection)this.savingsPlans.stream().map(SavingsPlan::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder savingsPlans(Collection<SavingsPlan> savingsPlans) {
            this.savingsPlans = SavingsPlanListCopier.copy(savingsPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlans(SavingsPlan ... savingsPlans) {
            this.savingsPlans(Arrays.asList(savingsPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlans(Consumer<SavingsPlan.Builder> ... savingsPlans) {
            this.savingsPlans(Stream.of(savingsPlans).map(c -> (SavingsPlan)((SavingsPlan.Builder)SavingsPlan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSavingsPlans(Collection<SavingsPlan.BuilderImpl> savingsPlans) {
            this.savingsPlans = SavingsPlanListCopier.copyFromBuilder(savingsPlans);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSavingsPlansResponse build() {
            return new DescribeSavingsPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SavingsplansResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSavingsPlansResponse> {
        public Builder savingsPlans(Collection<SavingsPlan> var1);

        public Builder savingsPlans(SavingsPlan ... var1);

        public Builder savingsPlans(Consumer<SavingsPlan.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

