/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlansOfferingsResponse extends SavingsplansResponse implements
        ToCopyableBuilder<DescribeSavingsPlansOfferingsResponse.Builder, DescribeSavingsPlansOfferingsResponse> {
    private static final SdkField<List<SavingsPlanOffering>> SEARCH_RESULTS_FIELD = SdkField
            .<List<SavingsPlanOffering>> builder(MarshallingType.LIST)
            .memberName("searchResults")
            .getter(getter(DescribeSavingsPlansOfferingsResponse::searchResults))
            .setter(setter(Builder::searchResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeSavingsPlansOfferingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SavingsPlanOffering> searchResults;

    private final String nextToken;

    private DescribeSavingsPlansOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.searchResults = builder.searchResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SearchResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSearchResults() {
        return searchResults != null && !(searchResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Savings Plans offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSearchResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Savings Plans offerings.
     */
    public final List<SavingsPlanOffering> searchResults() {
        return searchResults;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchResults() ? searchResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansOfferingsResponse)) {
            return false;
        }
        DescribeSavingsPlansOfferingsResponse other = (DescribeSavingsPlansOfferingsResponse) obj;
        return hasSearchResults() == other.hasSearchResults() && Objects.equals(searchResults(), other.searchResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSavingsPlansOfferingsResponse")
                .add("SearchResults", hasSearchResults() ? searchResults() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "searchResults":
            return Optional.ofNullable(clazz.cast(searchResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeSavingsPlansOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSavingsPlansOfferingsResponse> {
        /**
         * <p>
         * Information about the Savings Plans offerings.
         * </p>
         * 
         * @param searchResults
         *        Information about the Savings Plans offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchResults(Collection<SavingsPlanOffering> searchResults);

        /**
         * <p>
         * Information about the Savings Plans offerings.
         * </p>
         * 
         * @param searchResults
         *        Information about the Savings Plans offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchResults(SavingsPlanOffering... searchResults);

        /**
         * <p>
         * Information about the Savings Plans offerings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlanOffering>.Builder} avoiding the
         * need to create one manually via {@link List<SavingsPlanOffering>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanOffering>.Builder#build()} is called immediately
         * and its result is passed to {@link #searchResults(List<SavingsPlanOffering>)}.
         * 
         * @param searchResults
         *        a consumer that will call methods on {@link List<SavingsPlanOffering>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchResults(List<SavingsPlanOffering>)
         */
        Builder searchResults(Consumer<SavingsPlanOffering.Builder>... searchResults);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SavingsplansResponse.BuilderImpl implements Builder {
        private List<SavingsPlanOffering> searchResults = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansOfferingsResponse model) {
            super(model);
            searchResults(model.searchResults);
            nextToken(model.nextToken);
        }

        public final Collection<SavingsPlanOffering.Builder> getSearchResults() {
            if (searchResults instanceof SdkAutoConstructList) {
                return null;
            }
            return searchResults != null ? searchResults.stream().map(SavingsPlanOffering::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder searchResults(Collection<SavingsPlanOffering> searchResults) {
            this.searchResults = SavingsPlanOfferingsListCopier.copy(searchResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(SavingsPlanOffering... searchResults) {
            searchResults(Arrays.asList(searchResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(Consumer<SavingsPlanOffering.Builder>... searchResults) {
            searchResults(Stream.of(searchResults).map(c -> SavingsPlanOffering.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSearchResults(Collection<SavingsPlanOffering.BuilderImpl> searchResults) {
            this.searchResults = SavingsPlanOfferingsListCopier.copyFromBuilder(searchResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSavingsPlansOfferingsResponse build() {
            return new DescribeSavingsPlansOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
