/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Savings Plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlan implements SdkPojo, Serializable, ToCopyableBuilder<SavingsPlan.Builder, SavingsPlan> {
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringId").getter(getter(SavingsPlan::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final SdkField<String> SAVINGS_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanId").getter(getter(SavingsPlan::savingsPlanId)).setter(setter(Builder::savingsPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanId").build()).build();

    private static final SdkField<String> SAVINGS_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanArn").getter(getter(SavingsPlan::savingsPlanArn)).setter(setter(Builder::savingsPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SavingsPlan::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("start")
            .getter(getter(SavingsPlan::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("end")
            .getter(getter(SavingsPlan::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(SavingsPlan::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(SavingsPlan::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> EC2_INSTANCE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceFamily").getter(getter(SavingsPlan::ec2InstanceFamily))
            .setter(setter(Builder::ec2InstanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceFamily").build()).build();

    private static final SdkField<String> SAVINGS_PLAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanType").getter(getter(SavingsPlan::savingsPlanTypeAsString))
            .setter(setter(Builder::savingsPlanType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanType").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(SavingsPlan::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<List<String>> PRODUCT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("productTypes")
            .getter(getter(SavingsPlan::productTypesAsStrings))
            .setter(setter(Builder::productTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(SavingsPlan::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<String> COMMITMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitment").getter(getter(SavingsPlan::commitment)).setter(setter(Builder::commitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitment").build()).build();

    private static final SdkField<String> UPFRONT_PAYMENT_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upfrontPaymentAmount").getter(getter(SavingsPlan::upfrontPaymentAmount))
            .setter(setter(Builder::upfrontPaymentAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontPaymentAmount").build())
            .build();

    private static final SdkField<String> RECURRING_PAYMENT_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recurringPaymentAmount").getter(getter(SavingsPlan::recurringPaymentAmount))
            .setter(setter(Builder::recurringPaymentAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recurringPaymentAmount").build())
            .build();

    private static final SdkField<Long> TERM_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("termDurationInSeconds").getter(getter(SavingsPlan::termDurationInSeconds))
            .setter(setter(Builder::termDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termDurationInSeconds").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SavingsPlan::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ID_FIELD,
            SAVINGS_PLAN_ID_FIELD, SAVINGS_PLAN_ARN_FIELD, DESCRIPTION_FIELD, START_FIELD, END_FIELD, STATE_FIELD, REGION_FIELD,
            EC2_INSTANCE_FAMILY_FIELD, SAVINGS_PLAN_TYPE_FIELD, PAYMENT_OPTION_FIELD, PRODUCT_TYPES_FIELD, CURRENCY_FIELD,
            COMMITMENT_FIELD, UPFRONT_PAYMENT_AMOUNT_FIELD, RECURRING_PAYMENT_AMOUNT_FIELD, TERM_DURATION_IN_SECONDS_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String offeringId;

    private final String savingsPlanId;

    private final String savingsPlanArn;

    private final String description;

    private final String start;

    private final String end;

    private final String state;

    private final String region;

    private final String ec2InstanceFamily;

    private final String savingsPlanType;

    private final String paymentOption;

    private final List<String> productTypes;

    private final String currency;

    private final String commitment;

    private final String upfrontPaymentAmount;

    private final String recurringPaymentAmount;

    private final Long termDurationInSeconds;

    private final Map<String, String> tags;

    private SavingsPlan(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.savingsPlanId = builder.savingsPlanId;
        this.savingsPlanArn = builder.savingsPlanArn;
        this.description = builder.description;
        this.start = builder.start;
        this.end = builder.end;
        this.state = builder.state;
        this.region = builder.region;
        this.ec2InstanceFamily = builder.ec2InstanceFamily;
        this.savingsPlanType = builder.savingsPlanType;
        this.paymentOption = builder.paymentOption;
        this.productTypes = builder.productTypes;
        this.currency = builder.currency;
        this.commitment = builder.commitment;
        this.upfrontPaymentAmount = builder.upfrontPaymentAmount;
        this.recurringPaymentAmount = builder.recurringPaymentAmount;
        this.termDurationInSeconds = builder.termDurationInSeconds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The ID of the Savings Plan.
     * </p>
     * 
     * @return The ID of the Savings Plan.
     */
    public final String savingsPlanId() {
        return savingsPlanId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Savings Plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Savings Plan.
     */
    public final String savingsPlanArn() {
        return savingsPlanArn;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The start time.
     * </p>
     * 
     * @return The start time.
     */
    public final String start() {
        return start;
    }

    /**
     * <p>
     * The end time.
     * </p>
     * 
     * @return The end time.
     */
    public final String end() {
        return end;
    }

    /**
     * <p>
     * The state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SavingsPlanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state.
     * @see SavingsPlanState
     */
    public final SavingsPlanState state() {
        return SavingsPlanState.fromValue(state);
    }

    /**
     * <p>
     * The state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SavingsPlanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state.
     * @see SavingsPlanState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The AWS Region.
     * </p>
     * 
     * @return The AWS Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The EC2 instance family.
     * </p>
     * 
     * @return The EC2 instance family.
     */
    public final String ec2InstanceFamily() {
        return ec2InstanceFamily;
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlanType}
     * will return {@link SavingsPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #savingsPlanTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see SavingsPlanType
     */
    public final SavingsPlanType savingsPlanType() {
        return SavingsPlanType.fromValue(savingsPlanType);
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlanType}
     * will return {@link SavingsPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #savingsPlanTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see SavingsPlanType
     */
    public final String savingsPlanTypeAsString() {
        return savingsPlanType;
    }

    /**
     * <p>
     * The payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link SavingsPlanPaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option.
     * @see SavingsPlanPaymentOption
     */
    public final SavingsPlanPaymentOption paymentOption() {
        return SavingsPlanPaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link SavingsPlanPaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option.
     * @see SavingsPlanPaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The product types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The product types.
     */
    public final List<SavingsPlanProductType> productTypes() {
        return SavingsPlanProductTypeListCopier.copyStringToEnum(productTypes);
    }

    /**
     * Returns true if the ProductTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProductTypes() {
        return productTypes != null && !(productTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The product types.
     */
    public final List<String> productTypesAsStrings() {
        return productTypes;
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(currency);
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The hourly commitment, in USD.
     * </p>
     * 
     * @return The hourly commitment, in USD.
     */
    public final String commitment() {
        return commitment;
    }

    /**
     * <p>
     * The up-front payment amount.
     * </p>
     * 
     * @return The up-front payment amount.
     */
    public final String upfrontPaymentAmount() {
        return upfrontPaymentAmount;
    }

    /**
     * <p>
     * The recurring payment amount.
     * </p>
     * 
     * @return The recurring payment amount.
     */
    public final String recurringPaymentAmount() {
        return recurringPaymentAmount;
    }

    /**
     * <p>
     * The duration of the term, in seconds.
     * </p>
     * 
     * @return The duration of the term, in seconds.
     */
    public final Long termDurationInSeconds() {
        return termDurationInSeconds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductTypes() ? productTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(commitment());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPaymentAmount());
        hashCode = 31 * hashCode + Objects.hashCode(recurringPaymentAmount());
        hashCode = 31 * hashCode + Objects.hashCode(termDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlan)) {
            return false;
        }
        SavingsPlan other = (SavingsPlan) obj;
        return Objects.equals(offeringId(), other.offeringId()) && Objects.equals(savingsPlanId(), other.savingsPlanId())
                && Objects.equals(savingsPlanArn(), other.savingsPlanArn()) && Objects.equals(description(), other.description())
                && Objects.equals(start(), other.start()) && Objects.equals(end(), other.end())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(region(), other.region())
                && Objects.equals(ec2InstanceFamily(), other.ec2InstanceFamily())
                && Objects.equals(savingsPlanTypeAsString(), other.savingsPlanTypeAsString())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && hasProductTypes() == other.hasProductTypes()
                && Objects.equals(productTypesAsStrings(), other.productTypesAsStrings())
                && Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(commitment(), other.commitment())
                && Objects.equals(upfrontPaymentAmount(), other.upfrontPaymentAmount())
                && Objects.equals(recurringPaymentAmount(), other.recurringPaymentAmount())
                && Objects.equals(termDurationInSeconds(), other.termDurationInSeconds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlan").add("OfferingId", offeringId()).add("SavingsPlanId", savingsPlanId())
                .add("SavingsPlanArn", savingsPlanArn()).add("Description", description()).add("Start", start())
                .add("End", end()).add("State", stateAsString()).add("Region", region())
                .add("Ec2InstanceFamily", ec2InstanceFamily()).add("SavingsPlanType", savingsPlanTypeAsString())
                .add("PaymentOption", paymentOptionAsString())
                .add("ProductTypes", hasProductTypes() ? productTypesAsStrings() : null).add("Currency", currencyAsString())
                .add("Commitment", commitment()).add("UpfrontPaymentAmount", upfrontPaymentAmount())
                .add("RecurringPaymentAmount", recurringPaymentAmount()).add("TermDurationInSeconds", termDurationInSeconds())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "savingsPlanId":
            return Optional.ofNullable(clazz.cast(savingsPlanId()));
        case "savingsPlanArn":
            return Optional.ofNullable(clazz.cast(savingsPlanArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ec2InstanceFamily":
            return Optional.ofNullable(clazz.cast(ec2InstanceFamily()));
        case "savingsPlanType":
            return Optional.ofNullable(clazz.cast(savingsPlanTypeAsString()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "productTypes":
            return Optional.ofNullable(clazz.cast(productTypesAsStrings()));
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "commitment":
            return Optional.ofNullable(clazz.cast(commitment()));
        case "upfrontPaymentAmount":
            return Optional.ofNullable(clazz.cast(upfrontPaymentAmount()));
        case "recurringPaymentAmount":
            return Optional.ofNullable(clazz.cast(recurringPaymentAmount()));
        case "termDurationInSeconds":
            return Optional.ofNullable(clazz.cast(termDurationInSeconds()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlan, T> g) {
        return obj -> g.apply((SavingsPlan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlan> {
        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The ID of the Savings Plan.
         * </p>
         * 
         * @param savingsPlanId
         *        The ID of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanId(String savingsPlanId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Savings Plan.
         * </p>
         * 
         * @param savingsPlanArn
         *        The Amazon Resource Name (ARN) of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArn(String savingsPlanArn);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The start time.
         * </p>
         * 
         * @param start
         *        The start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * <p>
         * The end time.
         * </p>
         * 
         * @param end
         *        The end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);

        /**
         * <p>
         * The state.
         * </p>
         * 
         * @param state
         *        The state.
         * @see SavingsPlanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanState
         */
        Builder state(String state);

        /**
         * <p>
         * The state.
         * </p>
         * 
         * @param state
         *        The state.
         * @see SavingsPlanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanState
         */
        Builder state(SavingsPlanState state);

        /**
         * <p>
         * The AWS Region.
         * </p>
         * 
         * @param region
         *        The AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The EC2 instance family.
         * </p>
         * 
         * @param ec2InstanceFamily
         *        The EC2 instance family.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceFamily(String ec2InstanceFamily);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param savingsPlanType
         *        The plan type.
         * @see SavingsPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanType
         */
        Builder savingsPlanType(String savingsPlanType);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param savingsPlanType
         *        The plan type.
         * @see SavingsPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanType
         */
        Builder savingsPlanType(SavingsPlanType savingsPlanType);

        /**
         * <p>
         * The payment option.
         * </p>
         * 
         * @param paymentOption
         *        The payment option.
         * @see SavingsPlanPaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanPaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option.
         * </p>
         * 
         * @param paymentOption
         *        The payment option.
         * @see SavingsPlanPaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanPaymentOption
         */
        Builder paymentOption(SavingsPlanPaymentOption paymentOption);

        /**
         * <p>
         * The product types.
         * </p>
         * 
         * @param productTypes
         *        The product types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypesWithStrings(Collection<String> productTypes);

        /**
         * <p>
         * The product types.
         * </p>
         * 
         * @param productTypes
         *        The product types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypesWithStrings(String... productTypes);

        /**
         * <p>
         * The product types.
         * </p>
         * 
         * @param productTypes
         *        The product types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypes(Collection<SavingsPlanProductType> productTypes);

        /**
         * <p>
         * The product types.
         * </p>
         * 
         * @param productTypes
         *        The product types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypes(SavingsPlanProductType... productTypes);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(String currency);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(CurrencyCode currency);

        /**
         * <p>
         * The hourly commitment, in USD.
         * </p>
         * 
         * @param commitment
         *        The hourly commitment, in USD.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitment(String commitment);

        /**
         * <p>
         * The up-front payment amount.
         * </p>
         * 
         * @param upfrontPaymentAmount
         *        The up-front payment amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPaymentAmount(String upfrontPaymentAmount);

        /**
         * <p>
         * The recurring payment amount.
         * </p>
         * 
         * @param recurringPaymentAmount
         *        The recurring payment amount.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringPaymentAmount(String recurringPaymentAmount);

        /**
         * <p>
         * The duration of the term, in seconds.
         * </p>
         * 
         * @param termDurationInSeconds
         *        The duration of the term, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termDurationInSeconds(Long termDurationInSeconds);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String offeringId;

        private String savingsPlanId;

        private String savingsPlanArn;

        private String description;

        private String start;

        private String end;

        private String state;

        private String region;

        private String ec2InstanceFamily;

        private String savingsPlanType;

        private String paymentOption;

        private List<String> productTypes = DefaultSdkAutoConstructList.getInstance();

        private String currency;

        private String commitment;

        private String upfrontPaymentAmount;

        private String recurringPaymentAmount;

        private Long termDurationInSeconds;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlan model) {
            offeringId(model.offeringId);
            savingsPlanId(model.savingsPlanId);
            savingsPlanArn(model.savingsPlanArn);
            description(model.description);
            start(model.start);
            end(model.end);
            state(model.state);
            region(model.region);
            ec2InstanceFamily(model.ec2InstanceFamily);
            savingsPlanType(model.savingsPlanType);
            paymentOption(model.paymentOption);
            productTypesWithStrings(model.productTypes);
            currency(model.currency);
            commitment(model.commitment);
            upfrontPaymentAmount(model.upfrontPaymentAmount);
            recurringPaymentAmount(model.recurringPaymentAmount);
            termDurationInSeconds(model.termDurationInSeconds);
            tags(model.tags);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public final String getSavingsPlanId() {
            return savingsPlanId;
        }

        @Override
        public final Builder savingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
            return this;
        }

        public final void setSavingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
        }

        public final String getSavingsPlanArn() {
            return savingsPlanArn;
        }

        @Override
        public final Builder savingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
            return this;
        }

        public final void setSavingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStart() {
            return start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getEnd() {
            return end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SavingsPlanState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getEc2InstanceFamily() {
            return ec2InstanceFamily;
        }

        @Override
        public final Builder ec2InstanceFamily(String ec2InstanceFamily) {
            this.ec2InstanceFamily = ec2InstanceFamily;
            return this;
        }

        public final void setEc2InstanceFamily(String ec2InstanceFamily) {
            this.ec2InstanceFamily = ec2InstanceFamily;
        }

        public final String getSavingsPlanType() {
            return savingsPlanType;
        }

        @Override
        public final Builder savingsPlanType(String savingsPlanType) {
            this.savingsPlanType = savingsPlanType;
            return this;
        }

        @Override
        public final Builder savingsPlanType(SavingsPlanType savingsPlanType) {
            this.savingsPlanType(savingsPlanType == null ? null : savingsPlanType.toString());
            return this;
        }

        public final void setSavingsPlanType(String savingsPlanType) {
            this.savingsPlanType = savingsPlanType;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(SavingsPlanPaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final Collection<String> getProductTypes() {
            if (productTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return productTypes;
        }

        @Override
        public final Builder productTypesWithStrings(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productTypesWithStrings(String... productTypes) {
            productTypesWithStrings(Arrays.asList(productTypes));
            return this;
        }

        @Override
        public final Builder productTypes(Collection<SavingsPlanProductType> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copyEnumToString(productTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productTypes(SavingsPlanProductType... productTypes) {
            productTypes(Arrays.asList(productTypes));
            return this;
        }

        public final void setProductTypes(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
        }

        public final String getCurrency() {
            return currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        public final String getCommitment() {
            return commitment;
        }

        @Override
        public final Builder commitment(String commitment) {
            this.commitment = commitment;
            return this;
        }

        public final void setCommitment(String commitment) {
            this.commitment = commitment;
        }

        public final String getUpfrontPaymentAmount() {
            return upfrontPaymentAmount;
        }

        @Override
        public final Builder upfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
            return this;
        }

        public final void setUpfrontPaymentAmount(String upfrontPaymentAmount) {
            this.upfrontPaymentAmount = upfrontPaymentAmount;
        }

        public final String getRecurringPaymentAmount() {
            return recurringPaymentAmount;
        }

        @Override
        public final Builder recurringPaymentAmount(String recurringPaymentAmount) {
            this.recurringPaymentAmount = recurringPaymentAmount;
            return this;
        }

        public final void setRecurringPaymentAmount(String recurringPaymentAmount) {
            this.recurringPaymentAmount = recurringPaymentAmount;
        }

        public final Long getTermDurationInSeconds() {
            return termDurationInSeconds;
        }

        @Override
        public final Builder termDurationInSeconds(Long termDurationInSeconds) {
            this.termDurationInSeconds = termDurationInSeconds;
            return this;
        }

        public final void setTermDurationInSeconds(Long termDurationInSeconds) {
            this.termDurationInSeconds = termDurationInSeconds;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public SavingsPlan build() {
            return new SavingsPlan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
