/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Savings Plan offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlanOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlanOffering.Builder, SavingsPlanOffering> {
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringId").getter(getter(SavingsPlanOffering::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final SdkField<List<String>> PRODUCT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("productTypes")
            .getter(getter(SavingsPlanOffering::productTypesAsStrings))
            .setter(setter(Builder::productTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planType").getter(getter(SavingsPlanOffering::planTypeAsString)).setter(setter(Builder::planType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SavingsPlanOffering::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(SavingsPlanOffering::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<Long> DURATION_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("durationSeconds").getter(getter(SavingsPlanOffering::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(SavingsPlanOffering::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(SavingsPlanOffering::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(SavingsPlanOffering::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(SavingsPlanOffering::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<List<SavingsPlanOfferingProperty>> PROPERTIES_FIELD = SdkField
            .<List<SavingsPlanOfferingProperty>> builder(MarshallingType.LIST)
            .memberName("properties")
            .getter(getter(SavingsPlanOffering::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanOfferingProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanOfferingProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ID_FIELD,
            PRODUCT_TYPES_FIELD, PLAN_TYPE_FIELD, DESCRIPTION_FIELD, PAYMENT_OPTION_FIELD, DURATION_SECONDS_FIELD,
            CURRENCY_FIELD, SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String offeringId;

    private final List<String> productTypes;

    private final String planType;

    private final String description;

    private final String paymentOption;

    private final Long durationSeconds;

    private final String currency;

    private final String serviceCode;

    private final String usageType;

    private final String operation;

    private final List<SavingsPlanOfferingProperty> properties;

    private SavingsPlanOffering(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.productTypes = builder.productTypes;
        this.planType = builder.planType;
        this.description = builder.description;
        this.paymentOption = builder.paymentOption;
        this.durationSeconds = builder.durationSeconds;
        this.currency = builder.currency;
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductTypes} method.
     * </p>
     * 
     * @return The product type.
     */
    public final List<SavingsPlanProductType> productTypes() {
        return SavingsPlanProductTypeListCopier.copyStringToEnum(productTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ProductTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProductTypes() {
        return productTypes != null && !(productTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProductTypes} method.
     * </p>
     * 
     * @return The product type.
     */
    public final List<String> productTypesAsStrings() {
        return productTypes;
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planType} will
     * return {@link SavingsPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #planTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see SavingsPlanType
     */
    public final SavingsPlanType planType() {
        return SavingsPlanType.fromValue(planType);
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planType} will
     * return {@link SavingsPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #planTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see SavingsPlanType
     */
    public final String planTypeAsString() {
        return planType;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link SavingsPlanPaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option.
     * @see SavingsPlanPaymentOption
     */
    public final SavingsPlanPaymentOption paymentOption() {
        return SavingsPlanPaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link SavingsPlanPaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option.
     * @see SavingsPlanPaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The duration, in seconds.
     * </p>
     * 
     * @return The duration, in seconds.
     */
    public final Long durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(currency);
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The service.
     * </p>
     * 
     * @return The service.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The usage details of the line item in the billing report.
     * </p>
     * 
     * @return The usage details of the line item in the billing report.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The specific AWS operation for the line item in the billing report.
     * </p>
     * 
     * @return The specific AWS operation for the line item in the billing report.
     */
    public final String operation() {
        return operation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The properties.
     */
    public final List<SavingsPlanOfferingProperty> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(hasProductTypes() ? productTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlanOffering)) {
            return false;
        }
        SavingsPlanOffering other = (SavingsPlanOffering) obj;
        return Objects.equals(offeringId(), other.offeringId()) && hasProductTypes() == other.hasProductTypes()
                && Objects.equals(productTypesAsStrings(), other.productTypesAsStrings())
                && Objects.equals(planTypeAsString(), other.planTypeAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(usageType(), other.usageType())
                && Objects.equals(operation(), other.operation()) && hasProperties() == other.hasProperties()
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlanOffering").add("OfferingId", offeringId())
                .add("ProductTypes", hasProductTypes() ? productTypesAsStrings() : null).add("PlanType", planTypeAsString())
                .add("Description", description()).add("PaymentOption", paymentOptionAsString())
                .add("DurationSeconds", durationSeconds()).add("Currency", currencyAsString()).add("ServiceCode", serviceCode())
                .add("UsageType", usageType()).add("Operation", operation())
                .add("Properties", hasProperties() ? properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "productTypes":
            return Optional.ofNullable(clazz.cast(productTypesAsStrings()));
        case "planType":
            return Optional.ofNullable(clazz.cast(planTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "durationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlanOffering, T> g) {
        return obj -> g.apply((SavingsPlanOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlanOffering> {
        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productTypes
         *        The product type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypesWithStrings(Collection<String> productTypes);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productTypes
         *        The product type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypesWithStrings(String... productTypes);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productTypes
         *        The product type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypes(Collection<SavingsPlanProductType> productTypes);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productTypes
         *        The product type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTypes(SavingsPlanProductType... productTypes);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planType
         *        The plan type.
         * @see SavingsPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanType
         */
        Builder planType(String planType);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planType
         *        The plan type.
         * @see SavingsPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanType
         */
        Builder planType(SavingsPlanType planType);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The payment option.
         * </p>
         * 
         * @param paymentOption
         *        The payment option.
         * @see SavingsPlanPaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanPaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option.
         * </p>
         * 
         * @param paymentOption
         *        The payment option.
         * @see SavingsPlanPaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanPaymentOption
         */
        Builder paymentOption(SavingsPlanPaymentOption paymentOption);

        /**
         * <p>
         * The duration, in seconds.
         * </p>
         * 
         * @param durationSeconds
         *        The duration, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Long durationSeconds);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(String currency);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(CurrencyCode currency);

        /**
         * <p>
         * The service.
         * </p>
         * 
         * @param serviceCode
         *        The service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageType
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The specific AWS operation for the line item in the billing report.
         * </p>
         * 
         * @param operation
         *        The specific AWS operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The properties.
         * </p>
         * 
         * @param properties
         *        The properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<SavingsPlanOfferingProperty> properties);

        /**
         * <p>
         * The properties.
         * </p>
         * 
         * @param properties
         *        The properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(SavingsPlanOfferingProperty... properties);

        /**
         * <p>
         * The properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <SavingsPlanOfferingProperty>.Builder} avoiding the need to create one manually via {@link List
         * <SavingsPlanOfferingProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanOfferingProperty>.Builder#build()} is called
         * immediately and its result is passed to {@link #properties(List<SavingsPlanOfferingProperty>)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link List<SavingsPlanOfferingProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(List<SavingsPlanOfferingProperty>)
         */
        Builder properties(Consumer<SavingsPlanOfferingProperty.Builder>... properties);
    }

    static final class BuilderImpl implements Builder {
        private String offeringId;

        private List<String> productTypes = DefaultSdkAutoConstructList.getInstance();

        private String planType;

        private String description;

        private String paymentOption;

        private Long durationSeconds;

        private String currency;

        private String serviceCode;

        private String usageType;

        private String operation;

        private List<SavingsPlanOfferingProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlanOffering model) {
            offeringId(model.offeringId);
            productTypesWithStrings(model.productTypes);
            planType(model.planType);
            description(model.description);
            paymentOption(model.paymentOption);
            durationSeconds(model.durationSeconds);
            currency(model.currency);
            serviceCode(model.serviceCode);
            usageType(model.usageType);
            operation(model.operation);
            properties(model.properties);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final Collection<String> getProductTypes() {
            if (productTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return productTypes;
        }

        public final void setProductTypes(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
        }

        @Override
        public final Builder productTypesWithStrings(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productTypesWithStrings(String... productTypes) {
            productTypesWithStrings(Arrays.asList(productTypes));
            return this;
        }

        @Override
        public final Builder productTypes(Collection<SavingsPlanProductType> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copyEnumToString(productTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productTypes(SavingsPlanProductType... productTypes) {
            productTypes(Arrays.asList(productTypes));
            return this;
        }

        public final String getPlanType() {
            return planType;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        @Override
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        public final Builder planType(SavingsPlanType planType) {
            this.planType(planType == null ? null : planType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(SavingsPlanPaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final Long getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Long durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Long durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final List<SavingsPlanOfferingProperty.Builder> getProperties() {
            List<SavingsPlanOfferingProperty.Builder> result = SavingsPlanOfferingPropertyListCopier
                    .copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<SavingsPlanOfferingProperty.BuilderImpl> properties) {
            this.properties = SavingsPlanOfferingPropertyListCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<SavingsPlanOfferingProperty> properties) {
            this.properties = SavingsPlanOfferingPropertyListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(SavingsPlanOfferingProperty... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<SavingsPlanOfferingProperty.Builder>... properties) {
            properties(Stream.of(properties).map(c -> SavingsPlanOfferingProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SavingsPlanOffering build() {
            return new SavingsPlanOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
