/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.savingsplans.model.CurrencyCode;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingProperty;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingPropertyListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductTypeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlanOffering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlanOffering> {
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offeringId").getter(SavingsPlanOffering.getter(SavingsPlanOffering::offeringId)).setter(SavingsPlanOffering.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()}).build();
    private static final SdkField<List<String>> PRODUCT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("productTypes").getter(SavingsPlanOffering.getter(SavingsPlanOffering::productTypesAsStrings)).setter(SavingsPlanOffering.setter(Builder::productTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planType").getter(SavingsPlanOffering.getter(SavingsPlanOffering::planTypeAsString)).setter(SavingsPlanOffering.setter(Builder::planType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SavingsPlanOffering.getter(SavingsPlanOffering::description)).setter(SavingsPlanOffering.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("paymentOption").getter(SavingsPlanOffering.getter(SavingsPlanOffering::paymentOptionAsString)).setter(SavingsPlanOffering.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()}).build();
    private static final SdkField<Long> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("durationSeconds").getter(SavingsPlanOffering.getter(SavingsPlanOffering::durationSeconds)).setter(SavingsPlanOffering.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currency").getter(SavingsPlanOffering.getter(SavingsPlanOffering::currencyAsString)).setter(SavingsPlanOffering.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()}).build();
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(SavingsPlanOffering.getter(SavingsPlanOffering::serviceCode)).setter(SavingsPlanOffering.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(SavingsPlanOffering.getter(SavingsPlanOffering::usageType)).setter(SavingsPlanOffering.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(SavingsPlanOffering.getter(SavingsPlanOffering::operation)).setter(SavingsPlanOffering.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<List<SavingsPlanOfferingProperty>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("properties").getter(SavingsPlanOffering.getter(SavingsPlanOffering::properties)).setter(SavingsPlanOffering.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlanOfferingProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ID_FIELD, PRODUCT_TYPES_FIELD, PLAN_TYPE_FIELD, DESCRIPTION_FIELD, PAYMENT_OPTION_FIELD, DURATION_SECONDS_FIELD, CURRENCY_FIELD, SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String offeringId;
    private final List<String> productTypes;
    private final String planType;
    private final String description;
    private final String paymentOption;
    private final Long durationSeconds;
    private final String currency;
    private final String serviceCode;
    private final String usageType;
    private final String operation;
    private final List<SavingsPlanOfferingProperty> properties;

    private SavingsPlanOffering(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.productTypes = builder.productTypes;
        this.planType = builder.planType;
        this.description = builder.description;
        this.paymentOption = builder.paymentOption;
        this.durationSeconds = builder.durationSeconds;
        this.currency = builder.currency;
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.properties = builder.properties;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public final List<SavingsPlanProductType> productTypes() {
        return SavingsPlanProductTypeListCopier.copyStringToEnum(this.productTypes);
    }

    public final boolean hasProductTypes() {
        return this.productTypes != null && !(this.productTypes instanceof SdkAutoConstructList);
    }

    public final List<String> productTypesAsStrings() {
        return this.productTypes;
    }

    public final SavingsPlanType planType() {
        return SavingsPlanType.fromValue(this.planType);
    }

    public final String planTypeAsString() {
        return this.planType;
    }

    public final String description() {
        return this.description;
    }

    public final SavingsPlanPaymentOption paymentOption() {
        return SavingsPlanPaymentOption.fromValue(this.paymentOption);
    }

    public final String paymentOptionAsString() {
        return this.paymentOption;
    }

    public final Long durationSeconds() {
        return this.durationSeconds;
    }

    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(this.currency);
    }

    public final String currencyAsString() {
        return this.currency;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<SavingsPlanOfferingProperty> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductTypes() ? this.productTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlanOffering)) {
            return false;
        }
        SavingsPlanOffering other = (SavingsPlanOffering)obj;
        return Objects.equals(this.offeringId(), other.offeringId()) && this.hasProductTypes() == other.hasProductTypes() && Objects.equals(this.productTypesAsStrings(), other.productTypesAsStrings()) && Objects.equals(this.planTypeAsString(), other.planTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.currencyAsString(), other.currencyAsString()) && Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.usageType(), other.usageType()) && Objects.equals(this.operation(), other.operation()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlanOffering").add("OfferingId", (Object)this.offeringId()).add("ProductTypes", this.hasProductTypes() ? this.productTypesAsStrings() : null).add("PlanType", (Object)this.planTypeAsString()).add("Description", (Object)this.description()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("DurationSeconds", (Object)this.durationSeconds()).add("Currency", (Object)this.currencyAsString()).add("ServiceCode", (Object)this.serviceCode()).add("UsageType", (Object)this.usageType()).add("Operation", (Object)this.operation()).add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "productTypes": {
                return Optional.ofNullable(clazz.cast(this.productTypesAsStrings()));
            }
            case "planType": {
                return Optional.ofNullable(clazz.cast(this.planTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "paymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "durationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "currency": {
                return Optional.ofNullable(clazz.cast(this.currencyAsString()));
            }
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlanOffering, T> g) {
        return obj -> g.apply((SavingsPlanOffering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String offeringId;
        private List<String> productTypes = DefaultSdkAutoConstructList.getInstance();
        private String planType;
        private String description;
        private String paymentOption;
        private Long durationSeconds;
        private String currency;
        private String serviceCode;
        private String usageType;
        private String operation;
        private List<SavingsPlanOfferingProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlanOffering model) {
            this.offeringId(model.offeringId);
            this.productTypesWithStrings(model.productTypes);
            this.planType(model.planType);
            this.description(model.description);
            this.paymentOption(model.paymentOption);
            this.durationSeconds(model.durationSeconds);
            this.currency(model.currency);
            this.serviceCode(model.serviceCode);
            this.usageType(model.usageType);
            this.operation(model.operation);
            this.properties(model.properties);
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        @Transient
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final Collection<String> getProductTypes() {
            if (this.productTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.productTypes;
        }

        public final void setProductTypes(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
        }

        @Override
        @Transient
        public final Builder productTypesWithStrings(Collection<String> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copy(productTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productTypesWithStrings(String ... productTypes) {
            this.productTypesWithStrings(Arrays.asList(productTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder productTypes(Collection<SavingsPlanProductType> productTypes) {
            this.productTypes = SavingsPlanProductTypeListCopier.copyEnumToString(productTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productTypes(SavingsPlanProductType ... productTypes) {
            this.productTypes(Arrays.asList(productTypes));
            return this;
        }

        public final String getPlanType() {
            return this.planType;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        @Override
        @Transient
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        @Transient
        public final Builder planType(SavingsPlanType planType) {
            this.planType(planType == null ? null : planType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        @Transient
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        @Transient
        public final Builder paymentOption(SavingsPlanPaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final Long getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Long durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        @Transient
        public final Builder durationSeconds(Long durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        @Transient
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        @Transient
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        @Transient
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        @Transient
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        @Transient
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final List<SavingsPlanOfferingProperty.Builder> getProperties() {
            List<SavingsPlanOfferingProperty.Builder> result = SavingsPlanOfferingPropertyListCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<SavingsPlanOfferingProperty.BuilderImpl> properties) {
            this.properties = SavingsPlanOfferingPropertyListCopier.copyFromBuilder(properties);
        }

        @Override
        @Transient
        public final Builder properties(Collection<SavingsPlanOfferingProperty> properties) {
            this.properties = SavingsPlanOfferingPropertyListCopier.copy(properties);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder properties(SavingsPlanOfferingProperty ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder properties(Consumer<SavingsPlanOfferingProperty.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (SavingsPlanOfferingProperty)((SavingsPlanOfferingProperty.Builder)SavingsPlanOfferingProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SavingsPlanOffering build() {
            return new SavingsPlanOffering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlanOffering> {
        public Builder offeringId(String var1);

        public Builder productTypesWithStrings(Collection<String> var1);

        public Builder productTypesWithStrings(String ... var1);

        public Builder productTypes(Collection<SavingsPlanProductType> var1);

        public Builder productTypes(SavingsPlanProductType ... var1);

        public Builder planType(String var1);

        public Builder planType(SavingsPlanType var1);

        public Builder description(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(SavingsPlanPaymentOption var1);

        public Builder durationSeconds(Long var1);

        public Builder currency(String var1);

        public Builder currency(CurrencyCode var1);

        public Builder serviceCode(String var1);

        public Builder usageType(String var1);

        public Builder operation(String var1);

        public Builder properties(Collection<SavingsPlanOfferingProperty> var1);

        public Builder properties(SavingsPlanOfferingProperty ... var1);

        public Builder properties(Consumer<SavingsPlanOfferingProperty.Builder> ... var1);
    }
}

