/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlansRequest extends SavingsplansRequest implements
        ToCopyableBuilder<DescribeSavingsPlansRequest.Builder, DescribeSavingsPlansRequest> {
    private static final SdkField<List<String>> SAVINGS_PLAN_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("savingsPlanArns")
            .getter(getter(DescribeSavingsPlansRequest::savingsPlanArns))
            .setter(setter(Builder::savingsPlanArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SAVINGS_PLAN_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("savingsPlanIds")
            .getter(getter(DescribeSavingsPlansRequest::savingsPlanIds))
            .setter(setter(Builder::savingsPlanIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeSavingsPlansRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeSavingsPlansRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("states")
            .getter(getter(DescribeSavingsPlansRequest::statesAsStrings))
            .setter(setter(Builder::statesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SavingsPlanFilter>> FILTERS_FIELD = SdkField
            .<List<SavingsPlanFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(DescribeSavingsPlansRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ARNS_FIELD,
            SAVINGS_PLAN_IDS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATES_FIELD, FILTERS_FIELD));

    private final List<String> savingsPlanArns;

    private final List<String> savingsPlanIds;

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> states;

    private final List<SavingsPlanFilter> filters;

    private DescribeSavingsPlansRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlanArns = builder.savingsPlanArns;
        this.savingsPlanIds = builder.savingsPlanIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.states = builder.states;
        this.filters = builder.filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the SavingsPlanArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSavingsPlanArns() {
        return savingsPlanArns != null && !(savingsPlanArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARN) of the Savings Plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSavingsPlanArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARN) of the Savings Plans.
     */
    public final List<String> savingsPlanArns() {
        return savingsPlanArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the SavingsPlanIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSavingsPlanIds() {
        return savingsPlanIds != null && !(savingsPlanIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the Savings Plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSavingsPlanIds} method.
     * </p>
     * 
     * @return The IDs of the Savings Plans.
     */
    public final List<String> savingsPlanIds() {
        return savingsPlanIds;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve additional results, make another call
     * with the returned token value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve additional results, make another
     *         call with the returned token value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return The states.
     */
    public final List<SavingsPlanState> states() {
        return SavingsPlanStateListCopier.copyStringToEnum(states);
    }

    /**
     * For responses, this returns true if the service returned a value for the States property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStates() {
        return states != null && !(states instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStates} method.
     * </p>
     * 
     * @return The states.
     */
    public final List<String> statesAsStrings() {
        return states;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.
     */
    public final List<SavingsPlanFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlanArns() ? savingsPlanArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSavingsPlanIds() ? savingsPlanIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasStates() ? statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansRequest)) {
            return false;
        }
        DescribeSavingsPlansRequest other = (DescribeSavingsPlansRequest) obj;
        return hasSavingsPlanArns() == other.hasSavingsPlanArns() && Objects.equals(savingsPlanArns(), other.savingsPlanArns())
                && hasSavingsPlanIds() == other.hasSavingsPlanIds() && Objects.equals(savingsPlanIds(), other.savingsPlanIds())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasStates() == other.hasStates() && Objects.equals(statesAsStrings(), other.statesAsStrings())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSavingsPlansRequest")
                .add("SavingsPlanArns", hasSavingsPlanArns() ? savingsPlanArns() : null)
                .add("SavingsPlanIds", hasSavingsPlanIds() ? savingsPlanIds() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("States", hasStates() ? statesAsStrings() : null)
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanArns":
            return Optional.ofNullable(clazz.cast(savingsPlanArns()));
        case "savingsPlanIds":
            return Optional.ofNullable(clazz.cast(savingsPlanIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "states":
            return Optional.ofNullable(clazz.cast(statesAsStrings()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlansRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSavingsPlansRequest> {
        /**
         * <p>
         * The Amazon Resource Names (ARN) of the Savings Plans.
         * </p>
         * 
         * @param savingsPlanArns
         *        The Amazon Resource Names (ARN) of the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArns(Collection<String> savingsPlanArns);

        /**
         * <p>
         * The Amazon Resource Names (ARN) of the Savings Plans.
         * </p>
         * 
         * @param savingsPlanArns
         *        The Amazon Resource Names (ARN) of the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanArns(String... savingsPlanArns);

        /**
         * <p>
         * The IDs of the Savings Plans.
         * </p>
         * 
         * @param savingsPlanIds
         *        The IDs of the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanIds(Collection<String> savingsPlanIds);

        /**
         * <p>
         * The IDs of the Savings Plans.
         * </p>
         * 
         * @param savingsPlanIds
         *        The IDs of the Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanIds(String... savingsPlanIds);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve additional results, make another call
         * with the returned token value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve additional results, make
         *        another call with the returned token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The states.
         * </p>
         * 
         * @param states
         *        The states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(Collection<String> states);

        /**
         * <p>
         * The states.
         * </p>
         * 
         * @param states
         *        The states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statesWithStrings(String... states);

        /**
         * <p>
         * The states.
         * </p>
         * 
         * @param states
         *        The states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(Collection<SavingsPlanState> states);

        /**
         * <p>
         * The states.
         * </p>
         * 
         * @param states
         *        The states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder states(SavingsPlanState... states);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SavingsPlanFilter> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SavingsPlanFilter... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlanFilter>.Builder} avoiding the
         * need to create one manually via {@link List<SavingsPlanFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlanFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<SavingsPlanFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<SavingsPlanFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<SavingsPlanFilter>)
         */
        Builder filters(Consumer<SavingsPlanFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SavingsplansRequest.BuilderImpl implements Builder {
        private List<String> savingsPlanArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> savingsPlanIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private List<String> states = DefaultSdkAutoConstructList.getInstance();

        private List<SavingsPlanFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansRequest model) {
            super(model);
            savingsPlanArns(model.savingsPlanArns);
            savingsPlanIds(model.savingsPlanIds);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            statesWithStrings(model.states);
            filters(model.filters);
        }

        public final Collection<String> getSavingsPlanArns() {
            if (savingsPlanArns instanceof SdkAutoConstructList) {
                return null;
            }
            return savingsPlanArns;
        }

        public final void setSavingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnListCopier.copy(savingsPlanArns);
        }

        @Override
        @Transient
        public final Builder savingsPlanArns(Collection<String> savingsPlanArns) {
            this.savingsPlanArns = SavingsPlanArnListCopier.copy(savingsPlanArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder savingsPlanArns(String... savingsPlanArns) {
            savingsPlanArns(Arrays.asList(savingsPlanArns));
            return this;
        }

        public final Collection<String> getSavingsPlanIds() {
            if (savingsPlanIds instanceof SdkAutoConstructList) {
                return null;
            }
            return savingsPlanIds;
        }

        public final void setSavingsPlanIds(Collection<String> savingsPlanIds) {
            this.savingsPlanIds = SavingsPlanIdListCopier.copy(savingsPlanIds);
        }

        @Override
        @Transient
        public final Builder savingsPlanIds(Collection<String> savingsPlanIds) {
            this.savingsPlanIds = SavingsPlanIdListCopier.copy(savingsPlanIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder savingsPlanIds(String... savingsPlanIds) {
            savingsPlanIds(Arrays.asList(savingsPlanIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getStates() {
            if (states instanceof SdkAutoConstructList) {
                return null;
            }
            return states;
        }

        public final void setStates(Collection<String> states) {
            this.states = SavingsPlanStateListCopier.copy(states);
        }

        @Override
        @Transient
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = SavingsPlanStateListCopier.copy(states);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder statesWithStrings(String... states) {
            statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        @Transient
        public final Builder states(Collection<SavingsPlanState> states) {
            this.states = SavingsPlanStateListCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder states(SavingsPlanState... states) {
            states(Arrays.asList(states));
            return this;
        }

        public final List<SavingsPlanFilter.Builder> getFilters() {
            List<SavingsPlanFilter.Builder> result = SavingsPlanFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SavingsPlanFilter.BuilderImpl> filters) {
            this.filters = SavingsPlanFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<SavingsPlanFilter> filters) {
            this.filters = SavingsPlanFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(SavingsPlanFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SavingsPlanFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlansRequest build() {
            return new DescribeSavingsPlansRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
