/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.savingsplans.internal.SavingsplansServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanRequest;
import software.amazon.awssdk.services.savingsplans.model.CreateSavingsPlanResponse;
import software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanRequest;
import software.amazon.awssdk.services.savingsplans.model.DeleteQueuedSavingsPlanResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingRatesResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansOfferingsResponse;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansRequest;
import software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlansResponse;
import software.amazon.awssdk.services.savingsplans.model.InternalServerException;
import software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.ResourceNotFoundException;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansException;
import software.amazon.awssdk.services.savingsplans.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.savingsplans.model.TagResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.TagResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest;
import software.amazon.awssdk.services.savingsplans.model.UntagResourceResponse;
import software.amazon.awssdk.services.savingsplans.model.ValidationException;
import software.amazon.awssdk.services.savingsplans.transform.CreateSavingsPlanRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DeleteQueuedSavingsPlanRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DescribeSavingsPlanRatesRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DescribeSavingsPlansOfferingRatesRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DescribeSavingsPlansOfferingsRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.DescribeSavingsPlansRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.savingsplans.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link SavingsplansClient}.
 *
 * @see SavingsplansClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSavingsplansClient implements SavingsplansClient {
    private static final Logger log = Logger.loggerFor(DefaultSavingsplansClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final SavingsplansServiceClientConfiguration serviceClientConfiguration;

    protected DefaultSavingsplansClient(SavingsplansServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates a Savings Plan.
     * </p>
     *
     * @param createSavingsPlanRequest
     * @return Result of the CreateSavingsPlan operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws ServiceQuotaExceededException
     *         A service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.CreateSavingsPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/CreateSavingsPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSavingsPlanResponse createSavingsPlan(CreateSavingsPlanRequest createSavingsPlanRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSavingsPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSavingsPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSavingsPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSavingsPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSavingsPlan");

            return clientHandler.execute(new ClientExecutionParams<CreateSavingsPlanRequest, CreateSavingsPlanResponse>()
                    .withOperationName("CreateSavingsPlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createSavingsPlanRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSavingsPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the queued purchase for the specified Savings Plan.
     * </p>
     *
     * @param deleteQueuedSavingsPlanRequest
     * @return Result of the DeleteQueuedSavingsPlan operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws ServiceQuotaExceededException
     *         A service quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DeleteQueuedSavingsPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DeleteQueuedSavingsPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteQueuedSavingsPlanResponse deleteQueuedSavingsPlan(DeleteQueuedSavingsPlanRequest deleteQueuedSavingsPlanRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteQueuedSavingsPlanResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteQueuedSavingsPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueuedSavingsPlanRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueuedSavingsPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueuedSavingsPlan");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteQueuedSavingsPlanRequest, DeleteQueuedSavingsPlanResponse>()
                            .withOperationName("DeleteQueuedSavingsPlan").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteQueuedSavingsPlanRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteQueuedSavingsPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified Savings Plans rates.
     * </p>
     *
     * @param describeSavingsPlanRatesRequest
     * @return Result of the DescribeSavingsPlanRates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlanRates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlanRates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSavingsPlanRatesResponse describeSavingsPlanRates(
            DescribeSavingsPlanRatesRequest describeSavingsPlanRatesRequest) throws ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSavingsPlanRatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSavingsPlanRatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSavingsPlanRatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSavingsPlanRatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSavingsPlanRates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSavingsPlanRatesRequest, DescribeSavingsPlanRatesResponse>()
                            .withOperationName("DescribeSavingsPlanRates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeSavingsPlanRatesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSavingsPlanRatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified Savings Plans.
     * </p>
     *
     * @param describeSavingsPlansRequest
     * @return Result of the DescribeSavingsPlans operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlans"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSavingsPlansResponse describeSavingsPlans(DescribeSavingsPlansRequest describeSavingsPlansRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSavingsPlansResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSavingsPlansResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSavingsPlansRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSavingsPlansRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSavingsPlans");

            return clientHandler.execute(new ClientExecutionParams<DescribeSavingsPlansRequest, DescribeSavingsPlansResponse>()
                    .withOperationName("DescribeSavingsPlans").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(describeSavingsPlansRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSavingsPlansRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified Savings Plans offering rates.
     * </p>
     *
     * @param describeSavingsPlansOfferingRatesRequest
     * @return Result of the DescribeSavingsPlansOfferingRates operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlansOfferingRates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferingRates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSavingsPlansOfferingRatesResponse describeSavingsPlansOfferingRates(
            DescribeSavingsPlansOfferingRatesRequest describeSavingsPlansOfferingRatesRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSavingsPlansOfferingRatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSavingsPlansOfferingRatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSavingsPlansOfferingRatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeSavingsPlansOfferingRatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSavingsPlansOfferingRates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSavingsPlansOfferingRatesRequest, DescribeSavingsPlansOfferingRatesResponse>()
                            .withOperationName("DescribeSavingsPlansOfferingRates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeSavingsPlansOfferingRatesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSavingsPlansOfferingRatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified Savings Plans offerings.
     * </p>
     *
     * @param describeSavingsPlansOfferingsRequest
     * @return Result of the DescribeSavingsPlansOfferings operation returned by the service.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.DescribeSavingsPlansOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/DescribeSavingsPlansOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSavingsPlansOfferingsResponse describeSavingsPlansOfferings(
            DescribeSavingsPlansOfferingsRequest describeSavingsPlansOfferingsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSavingsPlansOfferingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSavingsPlansOfferingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSavingsPlansOfferingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeSavingsPlansOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSavingsPlansOfferings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSavingsPlansOfferingsRequest, DescribeSavingsPlansOfferingsResponse>()
                            .withOperationName("DescribeSavingsPlansOfferings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(describeSavingsPlansOfferingsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSavingsPlansOfferingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ServiceQuotaExceededException
     *         A service quota has been exceeded.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ValidationException
     *         One of the input parameters is not valid.
     * @throws InternalServerException
     *         An unexpected error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SavingsplansException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SavingsplansClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/savingsplans-2019-06-28/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException, SavingsplansException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "savingsplans");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SavingsplansServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = SavingsplansServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(SavingsplansException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.0")
                .contentType("application/json")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build());
    }

    @Override
    public final SavingsplansServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
