/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Savings Plan offering rate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlanOfferingRate implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlanOfferingRate.Builder, SavingsPlanOfferingRate> {
    private static final SdkField<ParentSavingsPlanOffering> SAVINGS_PLAN_OFFERING_FIELD = SdkField
            .<ParentSavingsPlanOffering> builder(MarshallingType.SDK_POJO).memberName("savingsPlanOffering")
            .getter(getter(SavingsPlanOfferingRate::savingsPlanOffering)).setter(setter(Builder::savingsPlanOffering))
            .constructor(ParentSavingsPlanOffering::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanOffering").build())
            .build();

    private static final SdkField<String> RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("rate")
            .getter(getter(SavingsPlanOfferingRate::rate)).setter(setter(Builder::rate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rate").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(SavingsPlanOfferingRate::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productType").getter(getter(SavingsPlanOfferingRate::productTypeAsString))
            .setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productType").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceCode").getter(getter(SavingsPlanOfferingRate::serviceCodeAsString))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(SavingsPlanOfferingRate::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(SavingsPlanOfferingRate::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<List<SavingsPlanOfferingRateProperty>> PROPERTIES_FIELD = SdkField
            .<List<SavingsPlanOfferingRateProperty>> builder(MarshallingType.LIST)
            .memberName("properties")
            .getter(getter(SavingsPlanOfferingRate::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanOfferingRateProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanOfferingRateProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_OFFERING_FIELD,
            RATE_FIELD, UNIT_FIELD, PRODUCT_TYPE_FIELD, SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final ParentSavingsPlanOffering savingsPlanOffering;

    private final String rate;

    private final String unit;

    private final String productType;

    private final String serviceCode;

    private final String usageType;

    private final String operation;

    private final List<SavingsPlanOfferingRateProperty> properties;

    private SavingsPlanOfferingRate(BuilderImpl builder) {
        this.savingsPlanOffering = builder.savingsPlanOffering;
        this.rate = builder.rate;
        this.unit = builder.unit;
        this.productType = builder.productType;
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The Savings Plan offering.
     * </p>
     * 
     * @return The Savings Plan offering.
     */
    public final ParentSavingsPlanOffering savingsPlanOffering() {
        return savingsPlanOffering;
    }

    /**
     * <p>
     * The Savings Plan rate.
     * </p>
     * 
     * @return The Savings Plan rate.
     */
    public final String rate() {
        return rate;
    }

    /**
     * <p>
     * The unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link SavingsPlanRateUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit.
     * @see SavingsPlanRateUnit
     */
    public final SavingsPlanRateUnit unit() {
        return SavingsPlanRateUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link SavingsPlanRateUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit.
     * @see SavingsPlanRateUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link SavingsPlanProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type.
     * @see SavingsPlanProductType
     */
    public final SavingsPlanProductType productType() {
        return SavingsPlanProductType.fromValue(productType);
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link SavingsPlanProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type.
     * @see SavingsPlanProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceCode} will
     * return {@link SavingsPlanRateServiceCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceCodeAsString}.
     * </p>
     * 
     * @return The service.
     * @see SavingsPlanRateServiceCode
     */
    public final SavingsPlanRateServiceCode serviceCode() {
        return SavingsPlanRateServiceCode.fromValue(serviceCode);
    }

    /**
     * <p>
     * The service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #serviceCode} will
     * return {@link SavingsPlanRateServiceCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceCodeAsString}.
     * </p>
     * 
     * @return The service.
     * @see SavingsPlanRateServiceCode
     */
    public final String serviceCodeAsString() {
        return serviceCode;
    }

    /**
     * <p>
     * The usage details of the line item in the billing report.
     * </p>
     * 
     * @return The usage details of the line item in the billing report.
     */
    public final String usageType() {
        return usageType;
    }

    /**
     * <p>
     * The specific Amazon Web Services operation for the line item in the billing report.
     * </p>
     * 
     * @return The specific Amazon Web Services operation for the line item in the billing report.
     */
    public final String operation() {
        return operation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return The properties.
     */
    public final List<SavingsPlanOfferingRateProperty> properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanOffering());
        hashCode = 31 * hashCode + Objects.hashCode(rate());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlanOfferingRate)) {
            return false;
        }
        SavingsPlanOfferingRate other = (SavingsPlanOfferingRate) obj;
        return Objects.equals(savingsPlanOffering(), other.savingsPlanOffering()) && Objects.equals(rate(), other.rate())
                && Objects.equals(unitAsString(), other.unitAsString())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(serviceCodeAsString(), other.serviceCodeAsString())
                && Objects.equals(usageType(), other.usageType()) && Objects.equals(operation(), other.operation())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlanOfferingRate").add("SavingsPlanOffering", savingsPlanOffering()).add("Rate", rate())
                .add("Unit", unitAsString()).add("ProductType", productTypeAsString()).add("ServiceCode", serviceCodeAsString())
                .add("UsageType", usageType()).add("Operation", operation())
                .add("Properties", hasProperties() ? properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanOffering":
            return Optional.ofNullable(clazz.cast(savingsPlanOffering()));
        case "rate":
            return Optional.ofNullable(clazz.cast(rate()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "productType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "serviceCode":
            return Optional.ofNullable(clazz.cast(serviceCodeAsString()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlanOfferingRate, T> g) {
        return obj -> g.apply((SavingsPlanOfferingRate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlanOfferingRate> {
        /**
         * <p>
         * The Savings Plan offering.
         * </p>
         * 
         * @param savingsPlanOffering
         *        The Savings Plan offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanOffering(ParentSavingsPlanOffering savingsPlanOffering);

        /**
         * <p>
         * The Savings Plan offering.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParentSavingsPlanOffering.Builder}
         * avoiding the need to create one manually via {@link ParentSavingsPlanOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParentSavingsPlanOffering.Builder#build()} is called immediately
         * and its result is passed to {@link #savingsPlanOffering(ParentSavingsPlanOffering)}.
         * 
         * @param savingsPlanOffering
         *        a consumer that will call methods on {@link ParentSavingsPlanOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlanOffering(ParentSavingsPlanOffering)
         */
        default Builder savingsPlanOffering(Consumer<ParentSavingsPlanOffering.Builder> savingsPlanOffering) {
            return savingsPlanOffering(ParentSavingsPlanOffering.builder().applyMutation(savingsPlanOffering).build());
        }

        /**
         * <p>
         * The Savings Plan rate.
         * </p>
         * 
         * @param rate
         *        The Savings Plan rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rate(String rate);

        /**
         * <p>
         * The unit.
         * </p>
         * 
         * @param unit
         *        The unit.
         * @see SavingsPlanRateUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanRateUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit.
         * </p>
         * 
         * @param unit
         *        The unit.
         * @see SavingsPlanRateUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanRateUnit
         */
        Builder unit(SavingsPlanRateUnit unit);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productType
         *        The product type.
         * @see SavingsPlanProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productType
         *        The product type.
         * @see SavingsPlanProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanProductType
         */
        Builder productType(SavingsPlanProductType productType);

        /**
         * <p>
         * The service.
         * </p>
         * 
         * @param serviceCode
         *        The service.
         * @see SavingsPlanRateServiceCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanRateServiceCode
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The service.
         * </p>
         * 
         * @param serviceCode
         *        The service.
         * @see SavingsPlanRateServiceCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanRateServiceCode
         */
        Builder serviceCode(SavingsPlanRateServiceCode serviceCode);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageType
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The specific Amazon Web Services operation for the line item in the billing report.
         * </p>
         * 
         * @param operation
         *        The specific Amazon Web Services operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * The properties.
         * </p>
         * 
         * @param properties
         *        The properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Collection<SavingsPlanOfferingRateProperty> properties);

        /**
         * <p>
         * The properties.
         * </p>
         * 
         * @param properties
         *        The properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(SavingsPlanOfferingRateProperty... properties);

        /**
         * <p>
         * The properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty.Builder#build()} is
         * called immediately and its result is passed to {@link #properties(List<SavingsPlanOfferingRateProperty>)}.
         * 
         * @param properties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(java.util.Collection<SavingsPlanOfferingRateProperty>)
         */
        Builder properties(Consumer<SavingsPlanOfferingRateProperty.Builder>... properties);
    }

    static final class BuilderImpl implements Builder {
        private ParentSavingsPlanOffering savingsPlanOffering;

        private String rate;

        private String unit;

        private String productType;

        private String serviceCode;

        private String usageType;

        private String operation;

        private List<SavingsPlanOfferingRateProperty> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlanOfferingRate model) {
            savingsPlanOffering(model.savingsPlanOffering);
            rate(model.rate);
            unit(model.unit);
            productType(model.productType);
            serviceCode(model.serviceCode);
            usageType(model.usageType);
            operation(model.operation);
            properties(model.properties);
        }

        public final ParentSavingsPlanOffering.Builder getSavingsPlanOffering() {
            return savingsPlanOffering != null ? savingsPlanOffering.toBuilder() : null;
        }

        public final void setSavingsPlanOffering(ParentSavingsPlanOffering.BuilderImpl savingsPlanOffering) {
            this.savingsPlanOffering = savingsPlanOffering != null ? savingsPlanOffering.build() : null;
        }

        @Override
        public final Builder savingsPlanOffering(ParentSavingsPlanOffering savingsPlanOffering) {
            this.savingsPlanOffering = savingsPlanOffering;
            return this;
        }

        public final String getRate() {
            return rate;
        }

        public final void setRate(String rate) {
            this.rate = rate;
        }

        @Override
        public final Builder rate(String rate) {
            this.rate = rate;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(SavingsPlanRateUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(SavingsPlanProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        @Override
        public final Builder serviceCode(SavingsPlanRateServiceCode serviceCode) {
            this.serviceCode(serviceCode == null ? null : serviceCode.toString());
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final List<SavingsPlanOfferingRateProperty.Builder> getProperties() {
            List<SavingsPlanOfferingRateProperty.Builder> result = SavingsPlanOfferingRatePropertyListCopier
                    .copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<SavingsPlanOfferingRateProperty.BuilderImpl> properties) {
            this.properties = SavingsPlanOfferingRatePropertyListCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<SavingsPlanOfferingRateProperty> properties) {
            this.properties = SavingsPlanOfferingRatePropertyListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(SavingsPlanOfferingRateProperty... properties) {
            properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<SavingsPlanOfferingRateProperty.Builder>... properties) {
            properties(Stream.of(properties).map(c -> SavingsPlanOfferingRateProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SavingsPlanOfferingRate build() {
            return new SavingsPlanOfferingRate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
