/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.savingsplans.model.CurrencyCode;
import software.amazon.awssdk.services.savingsplans.model.CurrencyListCopier;
import software.amazon.awssdk.services.savingsplans.model.DurationsListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanDescriptionsListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFiltersListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanOperationListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOption;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanPaymentOptionListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanProductType;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanServiceCodeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanType;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanTypeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsPlanUsageTypeListCopier;
import software.amazon.awssdk.services.savingsplans.model.SavingsplansRequest;
import software.amazon.awssdk.services.savingsplans.model.UUIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSavingsPlansOfferingsRequest
extends SavingsplansRequest
implements ToCopyableBuilder<Builder, DescribeSavingsPlansOfferingsRequest> {
    private static final SdkField<List<String>> OFFERING_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("offeringIds").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::offeringIds)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::offeringIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PAYMENT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("paymentOptions").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::paymentOptionsAsStrings)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::paymentOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("productType").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::productTypeAsString)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::productType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productType").build()}).build();
    private static final SdkField<List<String>> PLAN_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("planTypes").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::planTypesAsStrings)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::planTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Long>> DURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("durations").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::durations)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::durations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CURRENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("currencies").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::currenciesAsStrings)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::currenciesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("descriptions").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::descriptions)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::descriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceCodes").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::serviceCodes)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::serviceCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("usageTypes").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::usageTypes)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::usageTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("operations").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::operations)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::operations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SavingsPlanOfferingFilterElement>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::filters)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlanOfferingFilterElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::nextToken)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeSavingsPlansOfferingsRequest.getter(DescribeSavingsPlansOfferingsRequest::maxResults)).setter(DescribeSavingsPlansOfferingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_IDS_FIELD, PAYMENT_OPTIONS_FIELD, PRODUCT_TYPE_FIELD, PLAN_TYPES_FIELD, DURATIONS_FIELD, CURRENCIES_FIELD, DESCRIPTIONS_FIELD, SERVICE_CODES_FIELD, USAGE_TYPES_FIELD, OPERATIONS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("offeringIds", OFFERING_IDS_FIELD);
            this.put("paymentOptions", PAYMENT_OPTIONS_FIELD);
            this.put("productType", PRODUCT_TYPE_FIELD);
            this.put("planTypes", PLAN_TYPES_FIELD);
            this.put("durations", DURATIONS_FIELD);
            this.put("currencies", CURRENCIES_FIELD);
            this.put("descriptions", DESCRIPTIONS_FIELD);
            this.put("serviceCodes", SERVICE_CODES_FIELD);
            this.put("usageTypes", USAGE_TYPES_FIELD);
            this.put("operations", OPERATIONS_FIELD);
            this.put("filters", FILTERS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final List<String> offeringIds;
    private final List<String> paymentOptions;
    private final String productType;
    private final List<String> planTypes;
    private final List<Long> durations;
    private final List<String> currencies;
    private final List<String> descriptions;
    private final List<String> serviceCodes;
    private final List<String> usageTypes;
    private final List<String> operations;
    private final List<SavingsPlanOfferingFilterElement> filters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeSavingsPlansOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.offeringIds = builder.offeringIds;
        this.paymentOptions = builder.paymentOptions;
        this.productType = builder.productType;
        this.planTypes = builder.planTypes;
        this.durations = builder.durations;
        this.currencies = builder.currencies;
        this.descriptions = builder.descriptions;
        this.serviceCodes = builder.serviceCodes;
        this.usageTypes = builder.usageTypes;
        this.operations = builder.operations;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasOfferingIds() {
        return this.offeringIds != null && !(this.offeringIds instanceof SdkAutoConstructList);
    }

    public final List<String> offeringIds() {
        return this.offeringIds;
    }

    public final List<SavingsPlanPaymentOption> paymentOptions() {
        return SavingsPlanPaymentOptionListCopier.copyStringToEnum(this.paymentOptions);
    }

    public final boolean hasPaymentOptions() {
        return this.paymentOptions != null && !(this.paymentOptions instanceof SdkAutoConstructList);
    }

    public final List<String> paymentOptionsAsStrings() {
        return this.paymentOptions;
    }

    public final SavingsPlanProductType productType() {
        return SavingsPlanProductType.fromValue(this.productType);
    }

    public final String productTypeAsString() {
        return this.productType;
    }

    public final List<SavingsPlanType> planTypes() {
        return SavingsPlanTypeListCopier.copyStringToEnum(this.planTypes);
    }

    public final boolean hasPlanTypes() {
        return this.planTypes != null && !(this.planTypes instanceof SdkAutoConstructList);
    }

    public final List<String> planTypesAsStrings() {
        return this.planTypes;
    }

    public final boolean hasDurations() {
        return this.durations != null && !(this.durations instanceof SdkAutoConstructList);
    }

    public final List<Long> durations() {
        return this.durations;
    }

    public final List<CurrencyCode> currencies() {
        return CurrencyListCopier.copyStringToEnum(this.currencies);
    }

    public final boolean hasCurrencies() {
        return this.currencies != null && !(this.currencies instanceof SdkAutoConstructList);
    }

    public final List<String> currenciesAsStrings() {
        return this.currencies;
    }

    public final boolean hasDescriptions() {
        return this.descriptions != null && !(this.descriptions instanceof SdkAutoConstructList);
    }

    public final List<String> descriptions() {
        return this.descriptions;
    }

    public final boolean hasServiceCodes() {
        return this.serviceCodes != null && !(this.serviceCodes instanceof SdkAutoConstructList);
    }

    public final List<String> serviceCodes() {
        return this.serviceCodes;
    }

    public final boolean hasUsageTypes() {
        return this.usageTypes != null && !(this.usageTypes instanceof SdkAutoConstructList);
    }

    public final List<String> usageTypes() {
        return this.usageTypes;
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<String> operations() {
        return this.operations;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<SavingsPlanOfferingFilterElement> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOfferingIds() ? this.offeringIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaymentOptions() ? this.paymentOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlanTypes() ? this.planTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDurations() ? this.durations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCurrencies() ? this.currenciesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDescriptions() ? this.descriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceCodes() ? this.serviceCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsageTypes() ? this.usageTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansOfferingsRequest)) {
            return false;
        }
        DescribeSavingsPlansOfferingsRequest other = (DescribeSavingsPlansOfferingsRequest)((Object)obj);
        return this.hasOfferingIds() == other.hasOfferingIds() && Objects.equals(this.offeringIds(), other.offeringIds()) && this.hasPaymentOptions() == other.hasPaymentOptions() && Objects.equals(this.paymentOptionsAsStrings(), other.paymentOptionsAsStrings()) && Objects.equals(this.productTypeAsString(), other.productTypeAsString()) && this.hasPlanTypes() == other.hasPlanTypes() && Objects.equals(this.planTypesAsStrings(), other.planTypesAsStrings()) && this.hasDurations() == other.hasDurations() && Objects.equals(this.durations(), other.durations()) && this.hasCurrencies() == other.hasCurrencies() && Objects.equals(this.currenciesAsStrings(), other.currenciesAsStrings()) && this.hasDescriptions() == other.hasDescriptions() && Objects.equals(this.descriptions(), other.descriptions()) && this.hasServiceCodes() == other.hasServiceCodes() && Objects.equals(this.serviceCodes(), other.serviceCodes()) && this.hasUsageTypes() == other.hasUsageTypes() && Objects.equals(this.usageTypes(), other.usageTypes()) && this.hasOperations() == other.hasOperations() && Objects.equals(this.operations(), other.operations()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSavingsPlansOfferingsRequest").add("OfferingIds", this.hasOfferingIds() ? this.offeringIds() : null).add("PaymentOptions", this.hasPaymentOptions() ? this.paymentOptionsAsStrings() : null).add("ProductType", (Object)this.productTypeAsString()).add("PlanTypes", this.hasPlanTypes() ? this.planTypesAsStrings() : null).add("Durations", this.hasDurations() ? this.durations() : null).add("Currencies", this.hasCurrencies() ? this.currenciesAsStrings() : null).add("Descriptions", this.hasDescriptions() ? this.descriptions() : null).add("ServiceCodes", this.hasServiceCodes() ? this.serviceCodes() : null).add("UsageTypes", this.hasUsageTypes() ? this.usageTypes() : null).add("Operations", this.hasOperations() ? this.operations() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offeringIds": {
                return Optional.ofNullable(clazz.cast(this.offeringIds()));
            }
            case "paymentOptions": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionsAsStrings()));
            }
            case "productType": {
                return Optional.ofNullable(clazz.cast(this.productTypeAsString()));
            }
            case "planTypes": {
                return Optional.ofNullable(clazz.cast(this.planTypesAsStrings()));
            }
            case "durations": {
                return Optional.ofNullable(clazz.cast(this.durations()));
            }
            case "currencies": {
                return Optional.ofNullable(clazz.cast(this.currenciesAsStrings()));
            }
            case "descriptions": {
                return Optional.ofNullable(clazz.cast(this.descriptions()));
            }
            case "serviceCodes": {
                return Optional.ofNullable(clazz.cast(this.serviceCodes()));
            }
            case "usageTypes": {
                return Optional.ofNullable(clazz.cast(this.usageTypes()));
            }
            case "operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlansOfferingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SavingsplansRequest.BuilderImpl
    implements Builder {
        private List<String> offeringIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> paymentOptions = DefaultSdkAutoConstructList.getInstance();
        private String productType;
        private List<String> planTypes = DefaultSdkAutoConstructList.getInstance();
        private List<Long> durations = DefaultSdkAutoConstructList.getInstance();
        private List<String> currencies = DefaultSdkAutoConstructList.getInstance();
        private List<String> descriptions = DefaultSdkAutoConstructList.getInstance();
        private List<String> serviceCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> usageTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();
        private List<SavingsPlanOfferingFilterElement> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansOfferingsRequest model) {
            super(model);
            this.offeringIds(model.offeringIds);
            this.paymentOptionsWithStrings(model.paymentOptions);
            this.productType(model.productType);
            this.planTypesWithStrings(model.planTypes);
            this.durations(model.durations);
            this.currenciesWithStrings(model.currencies);
            this.descriptions(model.descriptions);
            this.serviceCodes(model.serviceCodes);
            this.usageTypes(model.usageTypes);
            this.operations(model.operations);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getOfferingIds() {
            if (this.offeringIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.offeringIds;
        }

        public final void setOfferingIds(Collection<String> offeringIds) {
            this.offeringIds = UUIDsCopier.copy(offeringIds);
        }

        @Override
        public final Builder offeringIds(Collection<String> offeringIds) {
            this.offeringIds = UUIDsCopier.copy(offeringIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringIds(String ... offeringIds) {
            this.offeringIds(Arrays.asList(offeringIds));
            return this;
        }

        public final Collection<String> getPaymentOptions() {
            if (this.paymentOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.paymentOptions;
        }

        public final void setPaymentOptions(Collection<String> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copy(paymentOptions);
        }

        @Override
        public final Builder paymentOptionsWithStrings(Collection<String> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copy(paymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentOptionsWithStrings(String ... paymentOptions) {
            this.paymentOptionsWithStrings(Arrays.asList(paymentOptions));
            return this;
        }

        @Override
        public final Builder paymentOptions(Collection<SavingsPlanPaymentOption> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copyEnumToString(paymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentOptions(SavingsPlanPaymentOption ... paymentOptions) {
            this.paymentOptions(Arrays.asList(paymentOptions));
            return this;
        }

        public final String getProductType() {
            return this.productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(SavingsPlanProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final Collection<String> getPlanTypes() {
            if (this.planTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.planTypes;
        }

        public final void setPlanTypes(Collection<String> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copy(planTypes);
        }

        @Override
        public final Builder planTypesWithStrings(Collection<String> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copy(planTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder planTypesWithStrings(String ... planTypes) {
            this.planTypesWithStrings(Arrays.asList(planTypes));
            return this;
        }

        @Override
        public final Builder planTypes(Collection<SavingsPlanType> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copyEnumToString(planTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder planTypes(SavingsPlanType ... planTypes) {
            this.planTypes(Arrays.asList(planTypes));
            return this;
        }

        public final Collection<Long> getDurations() {
            if (this.durations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.durations;
        }

        public final void setDurations(Collection<Long> durations) {
            this.durations = DurationsListCopier.copy(durations);
        }

        @Override
        public final Builder durations(Collection<Long> durations) {
            this.durations = DurationsListCopier.copy(durations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durations(Long ... durations) {
            this.durations(Arrays.asList(durations));
            return this;
        }

        public final Collection<String> getCurrencies() {
            if (this.currencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.currencies;
        }

        public final void setCurrencies(Collection<String> currencies) {
            this.currencies = CurrencyListCopier.copy(currencies);
        }

        @Override
        public final Builder currenciesWithStrings(Collection<String> currencies) {
            this.currencies = CurrencyListCopier.copy(currencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currenciesWithStrings(String ... currencies) {
            this.currenciesWithStrings(Arrays.asList(currencies));
            return this;
        }

        @Override
        public final Builder currencies(Collection<CurrencyCode> currencies) {
            this.currencies = CurrencyListCopier.copyEnumToString(currencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currencies(CurrencyCode ... currencies) {
            this.currencies(Arrays.asList(currencies));
            return this;
        }

        public final Collection<String> getDescriptions() {
            if (this.descriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.descriptions;
        }

        public final void setDescriptions(Collection<String> descriptions) {
            this.descriptions = SavingsPlanDescriptionsListCopier.copy(descriptions);
        }

        @Override
        public final Builder descriptions(Collection<String> descriptions) {
            this.descriptions = SavingsPlanDescriptionsListCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(String ... descriptions) {
            this.descriptions(Arrays.asList(descriptions));
            return this;
        }

        public final Collection<String> getServiceCodes() {
            if (this.serviceCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceCodes;
        }

        public final void setServiceCodes(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanServiceCodeListCopier.copy(serviceCodes);
        }

        @Override
        public final Builder serviceCodes(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanServiceCodeListCopier.copy(serviceCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodes(String ... serviceCodes) {
            this.serviceCodes(Arrays.asList(serviceCodes));
            return this;
        }

        public final Collection<String> getUsageTypes() {
            if (this.usageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.usageTypes;
        }

        public final void setUsageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanUsageTypeListCopier.copy(usageTypes);
        }

        @Override
        public final Builder usageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanUsageTypeListCopier.copy(usageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageTypes(String ... usageTypes) {
            this.usageTypes(Arrays.asList(usageTypes));
            return this;
        }

        public final Collection<String> getOperations() {
            if (this.operations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operations;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = SavingsPlanOperationListCopier.copy(operations);
        }

        @Override
        public final Builder operations(Collection<String> operations) {
            this.operations = SavingsPlanOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(String ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final List<SavingsPlanOfferingFilterElement.Builder> getFilters() {
            List<SavingsPlanOfferingFilterElement.Builder> result = SavingsPlanOfferingFiltersListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SavingsPlanOfferingFilterElement.BuilderImpl> filters) {
            this.filters = SavingsPlanOfferingFiltersListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SavingsPlanOfferingFilterElement> filters) {
            this.filters = SavingsPlanOfferingFiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SavingsPlanOfferingFilterElement ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanOfferingFilterElement.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (SavingsPlanOfferingFilterElement)((SavingsPlanOfferingFilterElement.Builder)SavingsPlanOfferingFilterElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlansOfferingsRequest build() {
            return new DescribeSavingsPlansOfferingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SavingsplansRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSavingsPlansOfferingsRequest> {
        public Builder offeringIds(Collection<String> var1);

        public Builder offeringIds(String ... var1);

        public Builder paymentOptionsWithStrings(Collection<String> var1);

        public Builder paymentOptionsWithStrings(String ... var1);

        public Builder paymentOptions(Collection<SavingsPlanPaymentOption> var1);

        public Builder paymentOptions(SavingsPlanPaymentOption ... var1);

        public Builder productType(String var1);

        public Builder productType(SavingsPlanProductType var1);

        public Builder planTypesWithStrings(Collection<String> var1);

        public Builder planTypesWithStrings(String ... var1);

        public Builder planTypes(Collection<SavingsPlanType> var1);

        public Builder planTypes(SavingsPlanType ... var1);

        public Builder durations(Collection<Long> var1);

        public Builder durations(Long ... var1);

        public Builder currenciesWithStrings(Collection<String> var1);

        public Builder currenciesWithStrings(String ... var1);

        public Builder currencies(Collection<CurrencyCode> var1);

        public Builder currencies(CurrencyCode ... var1);

        public Builder descriptions(Collection<String> var1);

        public Builder descriptions(String ... var1);

        public Builder serviceCodes(Collection<String> var1);

        public Builder serviceCodes(String ... var1);

        public Builder usageTypes(Collection<String> var1);

        public Builder usageTypes(String ... var1);

        public Builder operations(Collection<String> var1);

        public Builder operations(String ... var1);

        public Builder filters(Collection<SavingsPlanOfferingFilterElement> var1);

        public Builder filters(SavingsPlanOfferingFilterElement ... var1);

        public Builder filters(Consumer<SavingsPlanOfferingFilterElement.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

