/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSavingsPlanResponse extends SavingsplansResponse implements
        ToCopyableBuilder<CreateSavingsPlanResponse.Builder, CreateSavingsPlanResponse> {
    private static final SdkField<String> SAVINGS_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("savingsPlanId").getter(getter(CreateSavingsPlanResponse::savingsPlanId))
            .setter(setter(Builder::savingsPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPlanId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("savingsPlanId", SAVINGS_PLAN_ID_FIELD);
                }
            });

    private final String savingsPlanId;

    private CreateSavingsPlanResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlanId = builder.savingsPlanId;
    }

    /**
     * <p>
     * The ID of the Savings Plan.
     * </p>
     * 
     * @return The ID of the Savings Plan.
     */
    public final String savingsPlanId() {
        return savingsPlanId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlanId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSavingsPlanResponse)) {
            return false;
        }
        CreateSavingsPlanResponse other = (CreateSavingsPlanResponse) obj;
        return Objects.equals(savingsPlanId(), other.savingsPlanId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSavingsPlanResponse").add("SavingsPlanId", savingsPlanId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "savingsPlanId":
            return Optional.ofNullable(clazz.cast(savingsPlanId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateSavingsPlanResponse, T> g) {
        return obj -> g.apply((CreateSavingsPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSavingsPlanResponse> {
        /**
         * <p>
         * The ID of the Savings Plan.
         * </p>
         * 
         * @param savingsPlanId
         *        The ID of the Savings Plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlanId(String savingsPlanId);
    }

    static final class BuilderImpl extends SavingsplansResponse.BuilderImpl implements Builder {
        private String savingsPlanId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSavingsPlanResponse model) {
            super(model);
            savingsPlanId(model.savingsPlanId);
        }

        public final String getSavingsPlanId() {
            return savingsPlanId;
        }

        public final void setSavingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
        }

        @Override
        public final Builder savingsPlanId(String savingsPlanId) {
            this.savingsPlanId = savingsPlanId;
            return this;
        }

        @Override
        public CreateSavingsPlanResponse build() {
            return new CreateSavingsPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
