/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSavingsPlansOfferingsRequest extends SavingsplansRequest implements
        ToCopyableBuilder<DescribeSavingsPlansOfferingsRequest.Builder, DescribeSavingsPlansOfferingsRequest> {
    private static final SdkField<List<String>> OFFERING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("offeringIds")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::offeringIds))
            .setter(setter(Builder::offeringIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PAYMENT_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("paymentOptions")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::paymentOptionsAsStrings))
            .setter(setter(Builder::paymentOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("productType").getter(getter(DescribeSavingsPlansOfferingsRequest::productTypeAsString))
            .setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productType").build()).build();

    private static final SdkField<List<String>> PLAN_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("planTypes")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::planTypesAsStrings))
            .setter(setter(Builder::planTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Long>> DURATIONS_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .memberName("durations")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::durations))
            .setter(setter(Builder::durations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CURRENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("currencies")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::currenciesAsStrings))
            .setter(setter(Builder::currenciesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DESCRIPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("descriptions")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::descriptions))
            .setter(setter(Builder::descriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVICE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("serviceCodes")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::serviceCodes))
            .setter(setter(Builder::serviceCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USAGE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("usageTypes")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::usageTypes))
            .setter(setter(Builder::usageTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("operations")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::operations))
            .setter(setter(Builder::operations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SavingsPlanOfferingFilterElement>> FILTERS_FIELD = SdkField
            .<List<SavingsPlanOfferingFilterElement>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(DescribeSavingsPlansOfferingsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlanOfferingFilterElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlanOfferingFilterElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeSavingsPlansOfferingsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeSavingsPlansOfferingsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_IDS_FIELD,
            PAYMENT_OPTIONS_FIELD, PRODUCT_TYPE_FIELD, PLAN_TYPES_FIELD, DURATIONS_FIELD, CURRENCIES_FIELD, DESCRIPTIONS_FIELD,
            SERVICE_CODES_FIELD, USAGE_TYPES_FIELD, OPERATIONS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("offeringIds", OFFERING_IDS_FIELD);
                    put("paymentOptions", PAYMENT_OPTIONS_FIELD);
                    put("productType", PRODUCT_TYPE_FIELD);
                    put("planTypes", PLAN_TYPES_FIELD);
                    put("durations", DURATIONS_FIELD);
                    put("currencies", CURRENCIES_FIELD);
                    put("descriptions", DESCRIPTIONS_FIELD);
                    put("serviceCodes", SERVICE_CODES_FIELD);
                    put("usageTypes", USAGE_TYPES_FIELD);
                    put("operations", OPERATIONS_FIELD);
                    put("filters", FILTERS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                    put("maxResults", MAX_RESULTS_FIELD);
                }
            });

    private final List<String> offeringIds;

    private final List<String> paymentOptions;

    private final String productType;

    private final List<String> planTypes;

    private final List<Long> durations;

    private final List<String> currencies;

    private final List<String> descriptions;

    private final List<String> serviceCodes;

    private final List<String> usageTypes;

    private final List<String> operations;

    private final List<SavingsPlanOfferingFilterElement> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeSavingsPlansOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.offeringIds = builder.offeringIds;
        this.paymentOptions = builder.paymentOptions;
        this.productType = builder.productType;
        this.planTypes = builder.planTypes;
        this.durations = builder.durations;
        this.currencies = builder.currencies;
        this.descriptions = builder.descriptions;
        this.serviceCodes = builder.serviceCodes;
        this.usageTypes = builder.usageTypes;
        this.operations = builder.operations;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the OfferingIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOfferingIds() {
        return offeringIds != null && !(offeringIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOfferingIds} method.
     * </p>
     * 
     * @return The IDs of the offerings.
     */
    public final List<String> offeringIds() {
        return offeringIds;
    }

    /**
     * <p>
     * The payment options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPaymentOptions} method.
     * </p>
     * 
     * @return The payment options.
     */
    public final List<SavingsPlanPaymentOption> paymentOptions() {
        return SavingsPlanPaymentOptionListCopier.copyStringToEnum(paymentOptions);
    }

    /**
     * For responses, this returns true if the service returned a value for the PaymentOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPaymentOptions() {
        return paymentOptions != null && !(paymentOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The payment options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPaymentOptions} method.
     * </p>
     * 
     * @return The payment options.
     */
    public final List<String> paymentOptionsAsStrings() {
        return paymentOptions;
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link SavingsPlanProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type.
     * @see SavingsPlanProductType
     */
    public final SavingsPlanProductType productType() {
        return SavingsPlanProductType.fromValue(productType);
    }

    /**
     * <p>
     * The product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link SavingsPlanProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The product type.
     * @see SavingsPlanProductType
     */
    public final String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The plan types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlanTypes} method.
     * </p>
     * 
     * @return The plan types.
     */
    public final List<SavingsPlanType> planTypes() {
        return SavingsPlanTypeListCopier.copyStringToEnum(planTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the PlanTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPlanTypes() {
        return planTypes != null && !(planTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The plan types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlanTypes} method.
     * </p>
     * 
     * @return The plan types.
     */
    public final List<String> planTypesAsStrings() {
        return planTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Durations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDurations() {
        return durations != null && !(durations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The duration, in seconds.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDurations} method.
     * </p>
     * 
     * @return The duration, in seconds.
     */
    public final List<Long> durations() {
        return durations;
    }

    /**
     * <p>
     * The currencies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCurrencies} method.
     * </p>
     * 
     * @return The currencies.
     */
    public final List<CurrencyCode> currencies() {
        return CurrencyListCopier.copyStringToEnum(currencies);
    }

    /**
     * For responses, this returns true if the service returned a value for the Currencies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCurrencies() {
        return currencies != null && !(currencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The currencies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCurrencies} method.
     * </p>
     * 
     * @return The currencies.
     */
    public final List<String> currenciesAsStrings() {
        return currencies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Descriptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDescriptions() {
        return descriptions != null && !(descriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDescriptions} method.
     * </p>
     * 
     * @return The descriptions.
     */
    public final List<String> descriptions() {
        return descriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceCodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceCodes() {
        return serviceCodes != null && !(serviceCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceCodes} method.
     * </p>
     * 
     * @return The services.
     */
    public final List<String> serviceCodes() {
        return serviceCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUsageTypes() {
        return usageTypes != null && !(usageTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage details of the line item in the billing report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageTypes} method.
     * </p>
     * 
     * @return The usage details of the line item in the billing report.
     */
    public final List<String> usageTypes() {
        return usageTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Operations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOperations() {
        return operations != null && !(operations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specific Amazon Web Services operation for the line item in the billing report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperations} method.
     * </p>
     * 
     * @return The specific Amazon Web Services operation for the line item in the billing report.
     */
    public final List<String> operations() {
        return operations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return The filters.
     */
    public final List<SavingsPlanOfferingFilterElement> filters() {
        return filters;
    }

    /**
     * <p>
     * The token for the next page of results.
     * </p>
     * 
     * @return The token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return with a single call. To retrieve additional results, make another call
     * with the returned token value.
     * </p>
     * 
     * @return The maximum number of results to return with a single call. To retrieve additional results, make another
     *         call with the returned token value.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasOfferingIds() ? offeringIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPaymentOptions() ? paymentOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlanTypes() ? planTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDurations() ? durations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCurrencies() ? currenciesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDescriptions() ? descriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceCodes() ? serviceCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageTypes() ? usageTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOperations() ? operations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSavingsPlansOfferingsRequest)) {
            return false;
        }
        DescribeSavingsPlansOfferingsRequest other = (DescribeSavingsPlansOfferingsRequest) obj;
        return hasOfferingIds() == other.hasOfferingIds() && Objects.equals(offeringIds(), other.offeringIds())
                && hasPaymentOptions() == other.hasPaymentOptions()
                && Objects.equals(paymentOptionsAsStrings(), other.paymentOptionsAsStrings())
                && Objects.equals(productTypeAsString(), other.productTypeAsString()) && hasPlanTypes() == other.hasPlanTypes()
                && Objects.equals(planTypesAsStrings(), other.planTypesAsStrings()) && hasDurations() == other.hasDurations()
                && Objects.equals(durations(), other.durations()) && hasCurrencies() == other.hasCurrencies()
                && Objects.equals(currenciesAsStrings(), other.currenciesAsStrings())
                && hasDescriptions() == other.hasDescriptions() && Objects.equals(descriptions(), other.descriptions())
                && hasServiceCodes() == other.hasServiceCodes() && Objects.equals(serviceCodes(), other.serviceCodes())
                && hasUsageTypes() == other.hasUsageTypes() && Objects.equals(usageTypes(), other.usageTypes())
                && hasOperations() == other.hasOperations() && Objects.equals(operations(), other.operations())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSavingsPlansOfferingsRequest")
                .add("OfferingIds", hasOfferingIds() ? offeringIds() : null)
                .add("PaymentOptions", hasPaymentOptions() ? paymentOptionsAsStrings() : null)
                .add("ProductType", productTypeAsString()).add("PlanTypes", hasPlanTypes() ? planTypesAsStrings() : null)
                .add("Durations", hasDurations() ? durations() : null)
                .add("Currencies", hasCurrencies() ? currenciesAsStrings() : null)
                .add("Descriptions", hasDescriptions() ? descriptions() : null)
                .add("ServiceCodes", hasServiceCodes() ? serviceCodes() : null)
                .add("UsageTypes", hasUsageTypes() ? usageTypes() : null)
                .add("Operations", hasOperations() ? operations() : null).add("Filters", hasFilters() ? filters() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringIds":
            return Optional.ofNullable(clazz.cast(offeringIds()));
        case "paymentOptions":
            return Optional.ofNullable(clazz.cast(paymentOptionsAsStrings()));
        case "productType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "planTypes":
            return Optional.ofNullable(clazz.cast(planTypesAsStrings()));
        case "durations":
            return Optional.ofNullable(clazz.cast(durations()));
        case "currencies":
            return Optional.ofNullable(clazz.cast(currenciesAsStrings()));
        case "descriptions":
            return Optional.ofNullable(clazz.cast(descriptions()));
        case "serviceCodes":
            return Optional.ofNullable(clazz.cast(serviceCodes()));
        case "usageTypes":
            return Optional.ofNullable(clazz.cast(usageTypes()));
        case "operations":
            return Optional.ofNullable(clazz.cast(operations()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSavingsPlansOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeSavingsPlansOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SavingsplansRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSavingsPlansOfferingsRequest> {
        /**
         * <p>
         * The IDs of the offerings.
         * </p>
         * 
         * @param offeringIds
         *        The IDs of the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringIds(Collection<String> offeringIds);

        /**
         * <p>
         * The IDs of the offerings.
         * </p>
         * 
         * @param offeringIds
         *        The IDs of the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringIds(String... offeringIds);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param paymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOptionsWithStrings(Collection<String> paymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param paymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOptionsWithStrings(String... paymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param paymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOptions(Collection<SavingsPlanPaymentOption> paymentOptions);

        /**
         * <p>
         * The payment options.
         * </p>
         * 
         * @param paymentOptions
         *        The payment options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOptions(SavingsPlanPaymentOption... paymentOptions);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productType
         *        The product type.
         * @see SavingsPlanProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The product type.
         * </p>
         * 
         * @param productType
         *        The product type.
         * @see SavingsPlanProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanProductType
         */
        Builder productType(SavingsPlanProductType productType);

        /**
         * <p>
         * The plan types.
         * </p>
         * 
         * @param planTypes
         *        The plan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planTypesWithStrings(Collection<String> planTypes);

        /**
         * <p>
         * The plan types.
         * </p>
         * 
         * @param planTypes
         *        The plan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planTypesWithStrings(String... planTypes);

        /**
         * <p>
         * The plan types.
         * </p>
         * 
         * @param planTypes
         *        The plan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planTypes(Collection<SavingsPlanType> planTypes);

        /**
         * <p>
         * The plan types.
         * </p>
         * 
         * @param planTypes
         *        The plan types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planTypes(SavingsPlanType... planTypes);

        /**
         * <p>
         * The duration, in seconds.
         * </p>
         * 
         * @param durations
         *        The duration, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durations(Collection<Long> durations);

        /**
         * <p>
         * The duration, in seconds.
         * </p>
         * 
         * @param durations
         *        The duration, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durations(Long... durations);

        /**
         * <p>
         * The currencies.
         * </p>
         * 
         * @param currencies
         *        The currencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currenciesWithStrings(Collection<String> currencies);

        /**
         * <p>
         * The currencies.
         * </p>
         * 
         * @param currencies
         *        The currencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currenciesWithStrings(String... currencies);

        /**
         * <p>
         * The currencies.
         * </p>
         * 
         * @param currencies
         *        The currencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencies(Collection<CurrencyCode> currencies);

        /**
         * <p>
         * The currencies.
         * </p>
         * 
         * @param currencies
         *        The currencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencies(CurrencyCode... currencies);

        /**
         * <p>
         * The descriptions.
         * </p>
         * 
         * @param descriptions
         *        The descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(Collection<String> descriptions);

        /**
         * <p>
         * The descriptions.
         * </p>
         * 
         * @param descriptions
         *        The descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(String... descriptions);

        /**
         * <p>
         * The services.
         * </p>
         * 
         * @param serviceCodes
         *        The services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodes(Collection<String> serviceCodes);

        /**
         * <p>
         * The services.
         * </p>
         * 
         * @param serviceCodes
         *        The services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCodes(String... serviceCodes);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageTypes
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTypes(Collection<String> usageTypes);

        /**
         * <p>
         * The usage details of the line item in the billing report.
         * </p>
         * 
         * @param usageTypes
         *        The usage details of the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageTypes(String... usageTypes);

        /**
         * <p>
         * The specific Amazon Web Services operation for the line item in the billing report.
         * </p>
         * 
         * @param operations
         *        The specific Amazon Web Services operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(Collection<String> operations);

        /**
         * <p>
         * The specific Amazon Web Services operation for the line item in the billing report.
         * </p>
         * 
         * @param operations
         *        The specific Amazon Web Services operation for the line item in the billing report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operations(String... operations);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<SavingsPlanOfferingFilterElement> filters);

        /**
         * <p>
         * The filters.
         * </p>
         * 
         * @param filters
         *        The filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SavingsPlanOfferingFilterElement... filters);

        /**
         * <p>
         * The filters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<SavingsPlanOfferingFilterElement>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingFilterElement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<SavingsPlanOfferingFilterElement>)
         */
        Builder filters(Consumer<SavingsPlanOfferingFilterElement.Builder>... filters);

        /**
         * <p>
         * The token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return with a single call. To retrieve additional results, make another call
         * with the returned token value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return with a single call. To retrieve additional results, make
         *        another call with the returned token value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SavingsplansRequest.BuilderImpl implements Builder {
        private List<String> offeringIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> paymentOptions = DefaultSdkAutoConstructList.getInstance();

        private String productType;

        private List<String> planTypes = DefaultSdkAutoConstructList.getInstance();

        private List<Long> durations = DefaultSdkAutoConstructList.getInstance();

        private List<String> currencies = DefaultSdkAutoConstructList.getInstance();

        private List<String> descriptions = DefaultSdkAutoConstructList.getInstance();

        private List<String> serviceCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> usageTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> operations = DefaultSdkAutoConstructList.getInstance();

        private List<SavingsPlanOfferingFilterElement> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSavingsPlansOfferingsRequest model) {
            super(model);
            offeringIds(model.offeringIds);
            paymentOptionsWithStrings(model.paymentOptions);
            productType(model.productType);
            planTypesWithStrings(model.planTypes);
            durations(model.durations);
            currenciesWithStrings(model.currencies);
            descriptions(model.descriptions);
            serviceCodes(model.serviceCodes);
            usageTypes(model.usageTypes);
            operations(model.operations);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getOfferingIds() {
            if (offeringIds instanceof SdkAutoConstructList) {
                return null;
            }
            return offeringIds;
        }

        public final void setOfferingIds(Collection<String> offeringIds) {
            this.offeringIds = UUIDsCopier.copy(offeringIds);
        }

        @Override
        public final Builder offeringIds(Collection<String> offeringIds) {
            this.offeringIds = UUIDsCopier.copy(offeringIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringIds(String... offeringIds) {
            offeringIds(Arrays.asList(offeringIds));
            return this;
        }

        public final Collection<String> getPaymentOptions() {
            if (paymentOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return paymentOptions;
        }

        public final void setPaymentOptions(Collection<String> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copy(paymentOptions);
        }

        @Override
        public final Builder paymentOptionsWithStrings(Collection<String> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copy(paymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentOptionsWithStrings(String... paymentOptions) {
            paymentOptionsWithStrings(Arrays.asList(paymentOptions));
            return this;
        }

        @Override
        public final Builder paymentOptions(Collection<SavingsPlanPaymentOption> paymentOptions) {
            this.paymentOptions = SavingsPlanPaymentOptionListCopier.copyEnumToString(paymentOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentOptions(SavingsPlanPaymentOption... paymentOptions) {
            paymentOptions(Arrays.asList(paymentOptions));
            return this;
        }

        public final String getProductType() {
            return productType;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(SavingsPlanProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final Collection<String> getPlanTypes() {
            if (planTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return planTypes;
        }

        public final void setPlanTypes(Collection<String> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copy(planTypes);
        }

        @Override
        public final Builder planTypesWithStrings(Collection<String> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copy(planTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder planTypesWithStrings(String... planTypes) {
            planTypesWithStrings(Arrays.asList(planTypes));
            return this;
        }

        @Override
        public final Builder planTypes(Collection<SavingsPlanType> planTypes) {
            this.planTypes = SavingsPlanTypeListCopier.copyEnumToString(planTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder planTypes(SavingsPlanType... planTypes) {
            planTypes(Arrays.asList(planTypes));
            return this;
        }

        public final Collection<Long> getDurations() {
            if (durations instanceof SdkAutoConstructList) {
                return null;
            }
            return durations;
        }

        public final void setDurations(Collection<Long> durations) {
            this.durations = DurationsListCopier.copy(durations);
        }

        @Override
        public final Builder durations(Collection<Long> durations) {
            this.durations = DurationsListCopier.copy(durations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder durations(Long... durations) {
            durations(Arrays.asList(durations));
            return this;
        }

        public final Collection<String> getCurrencies() {
            if (currencies instanceof SdkAutoConstructList) {
                return null;
            }
            return currencies;
        }

        public final void setCurrencies(Collection<String> currencies) {
            this.currencies = CurrencyListCopier.copy(currencies);
        }

        @Override
        public final Builder currenciesWithStrings(Collection<String> currencies) {
            this.currencies = CurrencyListCopier.copy(currencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currenciesWithStrings(String... currencies) {
            currenciesWithStrings(Arrays.asList(currencies));
            return this;
        }

        @Override
        public final Builder currencies(Collection<CurrencyCode> currencies) {
            this.currencies = CurrencyListCopier.copyEnumToString(currencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currencies(CurrencyCode... currencies) {
            currencies(Arrays.asList(currencies));
            return this;
        }

        public final Collection<String> getDescriptions() {
            if (descriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return descriptions;
        }

        public final void setDescriptions(Collection<String> descriptions) {
            this.descriptions = SavingsPlanDescriptionsListCopier.copy(descriptions);
        }

        @Override
        public final Builder descriptions(Collection<String> descriptions) {
            this.descriptions = SavingsPlanDescriptionsListCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(String... descriptions) {
            descriptions(Arrays.asList(descriptions));
            return this;
        }

        public final Collection<String> getServiceCodes() {
            if (serviceCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceCodes;
        }

        public final void setServiceCodes(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanServiceCodeListCopier.copy(serviceCodes);
        }

        @Override
        public final Builder serviceCodes(Collection<String> serviceCodes) {
            this.serviceCodes = SavingsPlanServiceCodeListCopier.copy(serviceCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceCodes(String... serviceCodes) {
            serviceCodes(Arrays.asList(serviceCodes));
            return this;
        }

        public final Collection<String> getUsageTypes() {
            if (usageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return usageTypes;
        }

        public final void setUsageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanUsageTypeListCopier.copy(usageTypes);
        }

        @Override
        public final Builder usageTypes(Collection<String> usageTypes) {
            this.usageTypes = SavingsPlanUsageTypeListCopier.copy(usageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageTypes(String... usageTypes) {
            usageTypes(Arrays.asList(usageTypes));
            return this;
        }

        public final Collection<String> getOperations() {
            if (operations instanceof SdkAutoConstructList) {
                return null;
            }
            return operations;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = SavingsPlanOperationListCopier.copy(operations);
        }

        @Override
        public final Builder operations(Collection<String> operations) {
            this.operations = SavingsPlanOperationListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(String... operations) {
            operations(Arrays.asList(operations));
            return this;
        }

        public final List<SavingsPlanOfferingFilterElement.Builder> getFilters() {
            List<SavingsPlanOfferingFilterElement.Builder> result = SavingsPlanOfferingFiltersListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SavingsPlanOfferingFilterElement.BuilderImpl> filters) {
            this.filters = SavingsPlanOfferingFiltersListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SavingsPlanOfferingFilterElement> filters) {
            this.filters = SavingsPlanOfferingFiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SavingsPlanOfferingFilterElement... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SavingsPlanOfferingFilterElement.Builder>... filters) {
            filters(Stream.of(filters).map(c -> SavingsPlanOfferingFilterElement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSavingsPlansOfferingsRequest build() {
            return new DescribeSavingsPlansOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
