/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.savingsplans.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Savings Plan offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParentSavingsPlanOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<ParentSavingsPlanOffering.Builder, ParentSavingsPlanOffering> {
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringId").getter(getter(ParentSavingsPlanOffering::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(ParentSavingsPlanOffering::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<String> PLAN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planType").getter(getter(ParentSavingsPlanOffering::planTypeAsString)).setter(setter(Builder::planType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planType").build()).build();

    private static final SdkField<Long> DURATION_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("durationSeconds").getter(getter(ParentSavingsPlanOffering::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()).build();

    private static final SdkField<String> CURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currency").getter(getter(ParentSavingsPlanOffering::currencyAsString)).setter(setter(Builder::currency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currency").build()).build();

    private static final SdkField<String> PLAN_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planDescription").getter(getter(ParentSavingsPlanOffering::planDescription))
            .setter(setter(Builder::planDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_ID_FIELD,
            PAYMENT_OPTION_FIELD, PLAN_TYPE_FIELD, DURATION_SECONDS_FIELD, CURRENCY_FIELD, PLAN_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String offeringId;

    private final String paymentOption;

    private final String planType;

    private final Long durationSeconds;

    private final String currency;

    private final String planDescription;

    private ParentSavingsPlanOffering(BuilderImpl builder) {
        this.offeringId = builder.offeringId;
        this.paymentOption = builder.paymentOption;
        this.planType = builder.planType;
        this.durationSeconds = builder.durationSeconds;
        this.currency = builder.currency;
        this.planDescription = builder.planDescription;
    }

    /**
     * <p>
     * The ID of the offering.
     * </p>
     * 
     * @return The ID of the offering.
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link SavingsPlanPaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option.
     * @see SavingsPlanPaymentOption
     */
    public final SavingsPlanPaymentOption paymentOption() {
        return SavingsPlanPaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link SavingsPlanPaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option.
     * @see SavingsPlanPaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planType} will
     * return {@link SavingsPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #planTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see SavingsPlanType
     */
    public final SavingsPlanType planType() {
        return SavingsPlanType.fromValue(planType);
    }

    /**
     * <p>
     * The plan type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planType} will
     * return {@link SavingsPlanType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #planTypeAsString}.
     * </p>
     * 
     * @return The plan type.
     * @see SavingsPlanType
     */
    public final String planTypeAsString() {
        return planType;
    }

    /**
     * <p>
     * The duration, in seconds.
     * </p>
     * 
     * @return The duration, in seconds.
     */
    public final Long durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public final CurrencyCode currency() {
        return CurrencyCode.fromValue(currency);
    }

    /**
     * <p>
     * The currency.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currency} will
     * return {@link CurrencyCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyAsString}.
     * </p>
     * 
     * @return The currency.
     * @see CurrencyCode
     */
    public final String currencyAsString() {
        return currency;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public final String planDescription() {
        return planDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(planTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(currencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(planDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentSavingsPlanOffering)) {
            return false;
        }
        ParentSavingsPlanOffering other = (ParentSavingsPlanOffering) obj;
        return Objects.equals(offeringId(), other.offeringId())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(planTypeAsString(), other.planTypeAsString())
                && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(currencyAsString(), other.currencyAsString())
                && Objects.equals(planDescription(), other.planDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParentSavingsPlanOffering").add("OfferingId", offeringId())
                .add("PaymentOption", paymentOptionAsString()).add("PlanType", planTypeAsString())
                .add("DurationSeconds", durationSeconds()).add("Currency", currencyAsString())
                .add("PlanDescription", planDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "offeringId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "planType":
            return Optional.ofNullable(clazz.cast(planTypeAsString()));
        case "durationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "currency":
            return Optional.ofNullable(clazz.cast(currencyAsString()));
        case "planDescription":
            return Optional.ofNullable(clazz.cast(planDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("offeringId", OFFERING_ID_FIELD);
        map.put("paymentOption", PAYMENT_OPTION_FIELD);
        map.put("planType", PLAN_TYPE_FIELD);
        map.put("durationSeconds", DURATION_SECONDS_FIELD);
        map.put("currency", CURRENCY_FIELD);
        map.put("planDescription", PLAN_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParentSavingsPlanOffering, T> g) {
        return obj -> g.apply((ParentSavingsPlanOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParentSavingsPlanOffering> {
        /**
         * <p>
         * The ID of the offering.
         * </p>
         * 
         * @param offeringId
         *        The ID of the offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The payment option.
         * </p>
         * 
         * @param paymentOption
         *        The payment option.
         * @see SavingsPlanPaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanPaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option.
         * </p>
         * 
         * @param paymentOption
         *        The payment option.
         * @see SavingsPlanPaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanPaymentOption
         */
        Builder paymentOption(SavingsPlanPaymentOption paymentOption);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planType
         *        The plan type.
         * @see SavingsPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanType
         */
        Builder planType(String planType);

        /**
         * <p>
         * The plan type.
         * </p>
         * 
         * @param planType
         *        The plan type.
         * @see SavingsPlanType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SavingsPlanType
         */
        Builder planType(SavingsPlanType planType);

        /**
         * <p>
         * The duration, in seconds.
         * </p>
         * 
         * @param durationSeconds
         *        The duration, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Long durationSeconds);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(String currency);

        /**
         * <p>
         * The currency.
         * </p>
         * 
         * @param currency
         *        The currency.
         * @see CurrencyCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCode
         */
        Builder currency(CurrencyCode currency);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param planDescription
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planDescription(String planDescription);
    }

    static final class BuilderImpl implements Builder {
        private String offeringId;

        private String paymentOption;

        private String planType;

        private Long durationSeconds;

        private String currency;

        private String planDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ParentSavingsPlanOffering model) {
            offeringId(model.offeringId);
            paymentOption(model.paymentOption);
            planType(model.planType);
            durationSeconds(model.durationSeconds);
            currency(model.currency);
            planDescription(model.planDescription);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(SavingsPlanPaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getPlanType() {
            return planType;
        }

        public final void setPlanType(String planType) {
            this.planType = planType;
        }

        @Override
        public final Builder planType(String planType) {
            this.planType = planType;
            return this;
        }

        @Override
        public final Builder planType(SavingsPlanType planType) {
            this.planType(planType == null ? null : planType.toString());
            return this;
        }

        public final Long getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Long durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Long durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final String getCurrency() {
            return currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @Override
        public final Builder currency(CurrencyCode currency) {
            this.currency(currency == null ? null : currency.toString());
            return this;
        }

        public final String getPlanDescription() {
            return planDescription;
        }

        public final void setPlanDescription(String planDescription) {
            this.planDescription = planDescription;
        }

        @Override
        public final Builder planDescription(String planDescription) {
            this.planDescription = planDescription;
            return this;
        }

        @Override
        public ParentSavingsPlanOffering build() {
            return new ParentSavingsPlanOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
