/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduleGroupResponse extends SchedulerResponse implements
        ToCopyableBuilder<CreateScheduleGroupResponse.Builder, CreateScheduleGroupResponse> {
    private static final SdkField<String> SCHEDULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleGroupArn").getter(getter(CreateScheduleGroupResponse::scheduleGroupArn))
            .setter(setter(Builder::scheduleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_GROUP_ARN_FIELD));

    private final String scheduleGroupArn;

    private CreateScheduleGroupResponse(BuilderImpl builder) {
        super(builder);
        this.scheduleGroupArn = builder.scheduleGroupArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the schedule group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the schedule group.
     */
    public final String scheduleGroupArn() {
        return scheduleGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduleGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduleGroupResponse)) {
            return false;
        }
        CreateScheduleGroupResponse other = (CreateScheduleGroupResponse) obj;
        return Objects.equals(scheduleGroupArn(), other.scheduleGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScheduleGroupResponse").add("ScheduleGroupArn", scheduleGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleGroupArn":
            return Optional.ofNullable(clazz.cast(scheduleGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduleGroupResponse, T> g) {
        return obj -> g.apply((CreateScheduleGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchedulerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateScheduleGroupResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the schedule group.
         * </p>
         * 
         * @param scheduleGroupArn
         *        The Amazon Resource Name (ARN) of the schedule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleGroupArn(String scheduleGroupArn);
    }

    static final class BuilderImpl extends SchedulerResponse.BuilderImpl implements Builder {
        private String scheduleGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduleGroupResponse model) {
            super(model);
            scheduleGroupArn(model.scheduleGroupArn);
        }

        public final String getScheduleGroupArn() {
            return scheduleGroupArn;
        }

        public final void setScheduleGroupArn(String scheduleGroupArn) {
            this.scheduleGroupArn = scheduleGroupArn;
        }

        @Override
        public final Builder scheduleGroupArn(String scheduleGroupArn) {
            this.scheduleGroupArn = scheduleGroupArn;
            return this;
        }

        @Override
        public CreateScheduleGroupResponse build() {
            return new CreateScheduleGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
