/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduleRequest extends SchedulerRequest implements
        ToCopyableBuilder<CreateScheduleRequest.Builder, CreateScheduleRequest> {
    private static final SdkField<String> ACTION_AFTER_COMPLETION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionAfterCompletion").getter(getter(CreateScheduleRequest::actionAfterCompletionAsString))
            .setter(setter(Builder::actionAfterCompletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionAfterCompletion").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateScheduleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateScheduleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndDate").getter(getter(CreateScheduleRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<FlexibleTimeWindow> FLEXIBLE_TIME_WINDOW_FIELD = SdkField
            .<FlexibleTimeWindow> builder(MarshallingType.SDK_POJO).memberName("FlexibleTimeWindow")
            .getter(getter(CreateScheduleRequest::flexibleTimeWindow)).setter(setter(Builder::flexibleTimeWindow))
            .constructor(FlexibleTimeWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlexibleTimeWindow").build())
            .build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(CreateScheduleRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(CreateScheduleRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateScheduleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(CreateScheduleRequest::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_TIMEZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpressionTimezone")
            .getter(getter(CreateScheduleRequest::scheduleExpressionTimezone))
            .setter(setter(Builder::scheduleExpressionTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpressionTimezone").build())
            .build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(CreateScheduleRequest::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CreateScheduleRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Target> TARGET_FIELD = SdkField.<Target> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(CreateScheduleRequest::target)).setter(setter(Builder::target)).constructor(Target::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_AFTER_COMPLETION_FIELD,
            CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, END_DATE_FIELD, FLEXIBLE_TIME_WINDOW_FIELD, GROUP_NAME_FIELD,
            KMS_KEY_ARN_FIELD, NAME_FIELD, SCHEDULE_EXPRESSION_FIELD, SCHEDULE_EXPRESSION_TIMEZONE_FIELD, START_DATE_FIELD,
            STATE_FIELD, TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String actionAfterCompletion;

    private final String clientToken;

    private final String description;

    private final Instant endDate;

    private final FlexibleTimeWindow flexibleTimeWindow;

    private final String groupName;

    private final String kmsKeyArn;

    private final String name;

    private final String scheduleExpression;

    private final String scheduleExpressionTimezone;

    private final Instant startDate;

    private final String state;

    private final Target target;

    private CreateScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.actionAfterCompletion = builder.actionAfterCompletion;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.endDate = builder.endDate;
        this.flexibleTimeWindow = builder.flexibleTimeWindow;
        this.groupName = builder.groupName;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.name = builder.name;
        this.scheduleExpression = builder.scheduleExpression;
        this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
        this.startDate = builder.startDate;
        this.state = builder.state;
        this.target = builder.target;
    }

    /**
     * <p>
     * Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the
     * target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionAfterCompletion} will return {@link ActionAfterCompletion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionAfterCompletionAsString}.
     * </p>
     * 
     * @return Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes
     *         invoking the target.
     * @see ActionAfterCompletion
     */
    public final ActionAfterCompletion actionAfterCompletion() {
        return ActionAfterCompletion.fromValue(actionAfterCompletion);
    }

    /**
     * <p>
     * Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the
     * target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #actionAfterCompletion} will return {@link ActionAfterCompletion#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #actionAfterCompletionAsString}.
     * </p>
     * 
     * @return Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes
     *         invoking the target.
     * @see ActionAfterCompletion
     */
    public final String actionAfterCompletionAsString() {
        return actionAfterCompletion;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify a
     * client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not
     *         specify a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure
     *         idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description you specify for the schedule.
     * </p>
     * 
     * @return The description you specify for the schedule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence
     * expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge Scheduler
     * ignores <code>EndDate</code> for one-time schedules.
     * </p>
     * 
     * @return The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence
     *         expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge
     *         Scheduler ignores <code>EndDate</code> for one-time schedules.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
     * </p>
     * 
     * @return Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
     */
    public final FlexibleTimeWindow flexibleTimeWindow() {
        return flexibleTimeWindow;
    }

    /**
     * <p>
     * The name of the schedule group to associate with this schedule. If you omit this, the default schedule group is
     * used.
     * </p>
     * 
     * @return The name of the schedule group to associate with this schedule. If you omit this, the default schedule
     *         group is used.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to encrypt
     * and decrypt your data.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to
     *         encrypt and decrypt your data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The name of the schedule that you are creating.
     * </p>
     * 
     * @return The name of the schedule that you are creating.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The expression that defines when the schedule runs. The following formats are supported.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rate</code> expression - <code>rate(value unit)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cron</code> expression - <code>cron(fields)</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time and
     * in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to create
     * recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular intervals, such
     * as every 15 minutes or every five days. Cron-based schedules are useful when you want to invoke a target
     * periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
     * </p>
     * <p>
     * A <code>cron</code> expression consists of six fields separated by white spaces:
     * <code>(minutes hours day_of_month month day_of_week year)</code>.
     * </p>
     * <p>
     * A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with the
     * following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> |
     * <code>day</code> | <code>days</code>
     * </p>
     * <p>
     * For more information and examples, see <a
     * href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on EventBridge
     * Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>.
     * </p>
     * 
     * @return The expression that defines when the schedule runs. The following formats are supported. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rate</code> expression - <code>rate(value unit)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cron</code> expression - <code>cron(fields)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the
     *         time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code>
     *         expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a
     *         target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are useful
     *         when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st
     *         day of the month.
     *         </p>
     *         <p>
     *         A <code>cron</code> expression consists of six fields separated by white spaces:
     *         <code>(minutes hours day_of_month month day_of_week year)</code>.
     *         </p>
     *         <p>
     *         A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with
     *         the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> |
     *         <code>hours</code> | <code>day</code> | <code>days</code>
     *         </p>
     *         <p>
     *         For more information and examples, see <a
     *         href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on
     *         EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * The timezone in which the scheduling expression is evaluated.
     * </p>
     * 
     * @return The timezone in which the scheduling expression is evaluated.
     */
    public final String scheduleExpressionTimezone() {
        return scheduleExpressionTimezone;
    }

    /**
     * <p>
     * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence
     * expression, invocations might occur on, or after, the <code>StartDate</code> you specify. EventBridge Scheduler
     * ignores <code>StartDate</code> for one-time schedules.
     * </p>
     * 
     * @return The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's
     *         recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify.
     *         EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * Specifies whether the schedule is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether the schedule is enabled or disabled.
     * @see ScheduleState
     */
    public final ScheduleState state() {
        return ScheduleState.fromValue(state);
    }

    /**
     * <p>
     * Specifies whether the schedule is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether the schedule is enabled or disabled.
     * @see ScheduleState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The schedule's target.
     * </p>
     * 
     * @return The schedule's target.
     */
    public final Target target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAfterCompletionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(flexibleTimeWindow());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpressionTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduleRequest)) {
            return false;
        }
        CreateScheduleRequest other = (CreateScheduleRequest) obj;
        return Objects.equals(actionAfterCompletionAsString(), other.actionAfterCompletionAsString())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(endDate(), other.endDate()) && Objects.equals(flexibleTimeWindow(), other.flexibleTimeWindow())
                && Objects.equals(groupName(), other.groupName()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(name(), other.name()) && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(scheduleExpressionTimezone(), other.scheduleExpressionTimezone())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScheduleRequest").add("ActionAfterCompletion", actionAfterCompletionAsString())
                .add("ClientToken", clientToken()).add("Description", description()).add("EndDate", endDate())
                .add("FlexibleTimeWindow", flexibleTimeWindow()).add("GroupName", groupName()).add("KmsKeyArn", kmsKeyArn())
                .add("Name", name()).add("ScheduleExpression", scheduleExpression())
                .add("ScheduleExpressionTimezone", scheduleExpressionTimezone()).add("StartDate", startDate())
                .add("State", stateAsString()).add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionAfterCompletion":
            return Optional.ofNullable(clazz.cast(actionAfterCompletionAsString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "FlexibleTimeWindow":
            return Optional.ofNullable(clazz.cast(flexibleTimeWindow()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "ScheduleExpressionTimezone":
            return Optional.ofNullable(clazz.cast(scheduleExpressionTimezone()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionAfterCompletion", ACTION_AFTER_COMPLETION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("FlexibleTimeWindow", FLEXIBLE_TIME_WINDOW_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ScheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("ScheduleExpressionTimezone", SCHEDULE_EXPRESSION_TIMEZONE_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Target", TARGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduleRequest, T> g) {
        return obj -> g.apply((CreateScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchedulerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateScheduleRequest> {
        /**
         * <p>
         * Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking
         * the target.
         * </p>
         * 
         * @param actionAfterCompletion
         *        Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes
         *        invoking the target.
         * @see ActionAfterCompletion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionAfterCompletion
         */
        Builder actionAfterCompletion(String actionAfterCompletion);

        /**
         * <p>
         * Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking
         * the target.
         * </p>
         * 
         * @param actionAfterCompletion
         *        Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes
         *        invoking the target.
         * @see ActionAfterCompletion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionAfterCompletion
         */
        Builder actionAfterCompletion(ActionAfterCompletion actionAfterCompletion);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not specify
         * a client token, EventBridge Scheduler uses a randomly generated token for the request to ensure idempotency.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request. If you do not
         *        specify a client token, EventBridge Scheduler uses a randomly generated token for the request to
         *        ensure idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description you specify for the schedule.
         * </p>
         * 
         * @param description
         *        The description you specify for the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence
         * expression, invocations might stop on, or before, the <code>EndDate</code> you specify. EventBridge Scheduler
         * ignores <code>EndDate</code> for one-time schedules.
         * </p>
         * 
         * @param endDate
         *        The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's
         *        recurrence expression, invocations might stop on, or before, the <code>EndDate</code> you specify.
         *        EventBridge Scheduler ignores <code>EndDate</code> for one-time schedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
         * </p>
         * 
         * @param flexibleTimeWindow
         *        Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flexibleTimeWindow(FlexibleTimeWindow flexibleTimeWindow);

        /**
         * <p>
         * Allows you to configure a time window during which EventBridge Scheduler invokes the schedule.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlexibleTimeWindow.Builder} avoiding the
         * need to create one manually via {@link FlexibleTimeWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlexibleTimeWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #flexibleTimeWindow(FlexibleTimeWindow)}.
         * 
         * @param flexibleTimeWindow
         *        a consumer that will call methods on {@link FlexibleTimeWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #flexibleTimeWindow(FlexibleTimeWindow)
         */
        default Builder flexibleTimeWindow(Consumer<FlexibleTimeWindow.Builder> flexibleTimeWindow) {
            return flexibleTimeWindow(FlexibleTimeWindow.builder().applyMutation(flexibleTimeWindow).build());
        }

        /**
         * <p>
         * The name of the schedule group to associate with this schedule. If you omit this, the default schedule group
         * is used.
         * </p>
         * 
         * @param groupName
         *        The name of the schedule group to associate with this schedule. If you omit this, the default schedule
         *        group is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to
         * encrypt and decrypt your data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) for the customer managed KMS key that EventBridge Scheduler will use to
         *        encrypt and decrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The name of the schedule that you are creating.
         * </p>
         * 
         * @param name
         *        The name of the schedule that you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The expression that defines when the schedule runs. The following formats are supported.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rate</code> expression - <code>rate(value unit)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cron</code> expression - <code>cron(fields)</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the time
         * and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code> expressions to
         * create recurring schedules. Rate-based schedules are useful when you want to invoke a target at regular
         * intervals, such as every 15 minutes or every five days. Cron-based schedules are useful when you want to
         * invoke a target periodically at a specific time, such as at 8:00 am (UTC+0) every 1st day of the month.
         * </p>
         * <p>
         * A <code>cron</code> expression consists of six fields separated by white spaces:
         * <code>(minutes hours day_of_month month day_of_week year)</code>.
         * </p>
         * <p>
         * A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i> with the
         * following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> | <code>hours</code> |
         * <code>day</code> | <code>days</code>
         * </p>
         * <p>
         * For more information and examples, see <a
         * href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on
         * EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>.
         * </p>
         * 
         * @param scheduleExpression
         *        The expression that defines when the schedule runs. The following formats are supported. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>at</code> expression - <code>at(yyyy-mm-ddThh:mm:ss)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rate</code> expression - <code>rate(value unit)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cron</code> expression - <code>cron(fields)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can use <code>at</code> expressions to create one-time schedules that invoke a target once, at the
         *        time and in the time zone, that you specify. You can use <code>rate</code> and <code>cron</code>
         *        expressions to create recurring schedules. Rate-based schedules are useful when you want to invoke a
         *        target at regular intervals, such as every 15 minutes or every five days. Cron-based schedules are
         *        useful when you want to invoke a target periodically at a specific time, such as at 8:00 am (UTC+0)
         *        every 1st day of the month.
         *        </p>
         *        <p>
         *        A <code>cron</code> expression consists of six fields separated by white spaces:
         *        <code>(minutes hours day_of_month month day_of_week year)</code>.
         *        </p>
         *        <p>
         *        A <code>rate</code> expression consists of a <i>value</i> as a positive integer, and a <i>unit</i>
         *        with the following options: <code>minute</code> | <code>minutes</code> | <code>hour</code> |
         *        <code>hours</code> | <code>day</code> | <code>days</code>
         *        </p>
         *        <p>
         *        For more information and examples, see <a
         *        href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">Schedule types on
         *        EventBridge Scheduler</a> in the <i>EventBridge Scheduler User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * The timezone in which the scheduling expression is evaluated.
         * </p>
         * 
         * @param scheduleExpressionTimezone
         *        The timezone in which the scheduling expression is evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpressionTimezone(String scheduleExpressionTimezone);

        /**
         * <p>
         * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's
         * recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify.
         * EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.
         * </p>
         * 
         * @param startDate
         *        The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's
         *        recurrence expression, invocations might occur on, or after, the <code>StartDate</code> you specify.
         *        EventBridge Scheduler ignores <code>StartDate</code> for one-time schedules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * Specifies whether the schedule is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Specifies whether the schedule is enabled or disabled.
         * @see ScheduleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleState
         */
        Builder state(String state);

        /**
         * <p>
         * Specifies whether the schedule is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Specifies whether the schedule is enabled or disabled.
         * @see ScheduleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleState
         */
        Builder state(ScheduleState state);

        /**
         * <p>
         * The schedule's target.
         * </p>
         * 
         * @param target
         *        The schedule's target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(Target target);

        /**
         * <p>
         * The schedule's target.
         * </p>
         * This is a convenience method that creates an instance of the {@link Target.Builder} avoiding the need to
         * create one manually via {@link Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Target.Builder#build()} is called immediately and its result is
         * passed to {@link #target(Target)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(Target)
         */
        default Builder target(Consumer<Target.Builder> target) {
            return target(Target.builder().applyMutation(target).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SchedulerRequest.BuilderImpl implements Builder {
        private String actionAfterCompletion;

        private String clientToken;

        private String description;

        private Instant endDate;

        private FlexibleTimeWindow flexibleTimeWindow;

        private String groupName;

        private String kmsKeyArn;

        private String name;

        private String scheduleExpression;

        private String scheduleExpressionTimezone;

        private Instant startDate;

        private String state;

        private Target target;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduleRequest model) {
            super(model);
            actionAfterCompletion(model.actionAfterCompletion);
            clientToken(model.clientToken);
            description(model.description);
            endDate(model.endDate);
            flexibleTimeWindow(model.flexibleTimeWindow);
            groupName(model.groupName);
            kmsKeyArn(model.kmsKeyArn);
            name(model.name);
            scheduleExpression(model.scheduleExpression);
            scheduleExpressionTimezone(model.scheduleExpressionTimezone);
            startDate(model.startDate);
            state(model.state);
            target(model.target);
        }

        public final String getActionAfterCompletion() {
            return actionAfterCompletion;
        }

        public final void setActionAfterCompletion(String actionAfterCompletion) {
            this.actionAfterCompletion = actionAfterCompletion;
        }

        @Override
        public final Builder actionAfterCompletion(String actionAfterCompletion) {
            this.actionAfterCompletion = actionAfterCompletion;
            return this;
        }

        @Override
        public final Builder actionAfterCompletion(ActionAfterCompletion actionAfterCompletion) {
            this.actionAfterCompletion(actionAfterCompletion == null ? null : actionAfterCompletion.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final FlexibleTimeWindow.Builder getFlexibleTimeWindow() {
            return flexibleTimeWindow != null ? flexibleTimeWindow.toBuilder() : null;
        }

        public final void setFlexibleTimeWindow(FlexibleTimeWindow.BuilderImpl flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow != null ? flexibleTimeWindow.build() : null;
        }

        @Override
        public final Builder flexibleTimeWindow(FlexibleTimeWindow flexibleTimeWindow) {
            this.flexibleTimeWindow = flexibleTimeWindow;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getScheduleExpressionTimezone() {
            return scheduleExpressionTimezone;
        }

        public final void setScheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
        }

        @Override
        public final Builder scheduleExpressionTimezone(String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Target.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(Target.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(Target target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduleRequest build() {
            return new CreateScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
