/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.schemas.model.DiscovererSummary;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.___listOfDiscovererSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LockServiceLinkedRoleResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, LockServiceLinkedRoleResponse> {
    private static final SdkField<Boolean> CAN_BE_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LockServiceLinkedRoleResponse.getter(LockServiceLinkedRoleResponse::canBeDeleted)).setter(LockServiceLinkedRoleResponse.setter(Builder::canBeDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanBeDeleted").build()}).build();
    private static final SdkField<String> REASON_OF_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LockServiceLinkedRoleResponse.getter(LockServiceLinkedRoleResponse::reasonOfFailure)).setter(LockServiceLinkedRoleResponse.setter(Builder::reasonOfFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReasonOfFailure").build()}).build();
    private static final SdkField<List<DiscovererSummary>> RELATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LockServiceLinkedRoleResponse.getter(LockServiceLinkedRoleResponse::relatedResources)).setter(LockServiceLinkedRoleResponse.setter(Builder::relatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiscovererSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_BE_DELETED_FIELD, REASON_OF_FAILURE_FIELD, RELATED_RESOURCES_FIELD));
    private final Boolean canBeDeleted;
    private final String reasonOfFailure;
    private final List<DiscovererSummary> relatedResources;

    private LockServiceLinkedRoleResponse(BuilderImpl builder) {
        super(builder);
        this.canBeDeleted = builder.canBeDeleted;
        this.reasonOfFailure = builder.reasonOfFailure;
        this.relatedResources = builder.relatedResources;
    }

    public Boolean canBeDeleted() {
        return this.canBeDeleted;
    }

    public String reasonOfFailure() {
        return this.reasonOfFailure;
    }

    public boolean hasRelatedResources() {
        return this.relatedResources != null && !(this.relatedResources instanceof SdkAutoConstructList);
    }

    public List<DiscovererSummary> relatedResources() {
        return this.relatedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.canBeDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonOfFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedResources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LockServiceLinkedRoleResponse)) {
            return false;
        }
        LockServiceLinkedRoleResponse other = (LockServiceLinkedRoleResponse)((Object)obj);
        return Objects.equals(this.canBeDeleted(), other.canBeDeleted()) && Objects.equals(this.reasonOfFailure(), other.reasonOfFailure()) && Objects.equals(this.relatedResources(), other.relatedResources());
    }

    public String toString() {
        return ToString.builder((String)"LockServiceLinkedRoleResponse").add("CanBeDeleted", (Object)this.canBeDeleted()).add("ReasonOfFailure", (Object)this.reasonOfFailure()).add("RelatedResources", this.relatedResources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CanBeDeleted": {
                return Optional.ofNullable(clazz.cast(this.canBeDeleted()));
            }
            case "ReasonOfFailure": {
                return Optional.ofNullable(clazz.cast(this.reasonOfFailure()));
            }
            case "RelatedResources": {
                return Optional.ofNullable(clazz.cast(this.relatedResources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LockServiceLinkedRoleResponse, T> g) {
        return obj -> g.apply((LockServiceLinkedRoleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private Boolean canBeDeleted;
        private String reasonOfFailure;
        private List<DiscovererSummary> relatedResources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LockServiceLinkedRoleResponse model) {
            super(model);
            this.canBeDeleted(model.canBeDeleted);
            this.reasonOfFailure(model.reasonOfFailure);
            this.relatedResources(model.relatedResources);
        }

        public final Boolean getCanBeDeleted() {
            return this.canBeDeleted;
        }

        @Override
        public final Builder canBeDeleted(Boolean canBeDeleted) {
            this.canBeDeleted = canBeDeleted;
            return this;
        }

        public final void setCanBeDeleted(Boolean canBeDeleted) {
            this.canBeDeleted = canBeDeleted;
        }

        public final String getReasonOfFailure() {
            return this.reasonOfFailure;
        }

        @Override
        public final Builder reasonOfFailure(String reasonOfFailure) {
            this.reasonOfFailure = reasonOfFailure;
            return this;
        }

        public final void setReasonOfFailure(String reasonOfFailure) {
            this.reasonOfFailure = reasonOfFailure;
        }

        public final Collection<DiscovererSummary.Builder> getRelatedResources() {
            return this.relatedResources != null ? (Collection)this.relatedResources.stream().map(DiscovererSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedResources(Collection<DiscovererSummary> relatedResources) {
            this.relatedResources = ___listOfDiscovererSummaryCopier.copy(relatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(DiscovererSummary ... relatedResources) {
            this.relatedResources(Arrays.asList(relatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedResources(Consumer<DiscovererSummary.Builder> ... relatedResources) {
            this.relatedResources(Stream.of(relatedResources).map(c -> (DiscovererSummary)((DiscovererSummary.Builder)DiscovererSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedResources(Collection<DiscovererSummary.BuilderImpl> relatedResources) {
            this.relatedResources = ___listOfDiscovererSummaryCopier.copyFromBuilder(relatedResources);
        }

        @Override
        public LockServiceLinkedRoleResponse build() {
            return new LockServiceLinkedRoleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LockServiceLinkedRoleResponse> {
        public Builder canBeDeleted(Boolean var1);

        public Builder reasonOfFailure(String var1);

        public Builder relatedResources(Collection<DiscovererSummary> var1);

        public Builder relatedResources(DiscovererSummary ... var1);

        public Builder relatedResources(Consumer<DiscovererSummary.Builder> ... var1);
    }
}

