/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSchemaResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, DescribeSchemaResponse> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::content)).setter(DescribeSchemaResponse.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::description)).setter(DescribeSchemaResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::lastModified)).setter(DescribeSchemaResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::schemaArn)).setter(DescribeSchemaResponse.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::schemaName)).setter(DescribeSchemaResponse.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::schemaVersion)).setter(DescribeSchemaResponse.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::tags)).setter(DescribeSchemaResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::type)).setter(DescribeSchemaResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> VERSION_CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeSchemaResponse.getter(DescribeSchemaResponse::versionCreatedDate)).setter(DescribeSchemaResponse.setter(Builder::versionCreatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionCreatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_FIELD, SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, SCHEMA_VERSION_FIELD, TAGS_FIELD, TYPE_FIELD, VERSION_CREATED_DATE_FIELD));
    private final String content;
    private final String description;
    private final Instant lastModified;
    private final String schemaArn;
    private final String schemaName;
    private final String schemaVersion;
    private final Map<String, String> tags;
    private final String type;
    private final Instant versionCreatedDate;

    private DescribeSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.description = builder.description;
        this.lastModified = builder.lastModified;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.schemaVersion = builder.schemaVersion;
        this.tags = builder.tags;
        this.type = builder.type;
        this.versionCreatedDate = builder.versionCreatedDate;
    }

    public String content() {
        return this.content;
    }

    public String description() {
        return this.description;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String schemaVersion() {
        return this.schemaVersion;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String type() {
        return this.type;
    }

    public Instant versionCreatedDate() {
        return this.versionCreatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionCreatedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSchemaResponse)) {
            return false;
        }
        DescribeSchemaResponse other = (DescribeSchemaResponse)((Object)obj);
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.versionCreatedDate(), other.versionCreatedDate());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSchemaResponse").add("Content", (Object)this.content()).add("Description", (Object)this.description()).add("LastModified", (Object)this.lastModified()).add("SchemaArn", (Object)this.schemaArn()).add("SchemaName", (Object)this.schemaName()).add("SchemaVersion", (Object)this.schemaVersion()).add("Tags", this.tags()).add("Type", (Object)this.type()).add("VersionCreatedDate", (Object)this.versionCreatedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "SchemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "VersionCreatedDate": {
                return Optional.ofNullable(clazz.cast(this.versionCreatedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSchemaResponse, T> g) {
        return obj -> g.apply((DescribeSchemaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String content;
        private String description;
        private Instant lastModified;
        private String schemaArn;
        private String schemaName;
        private String schemaVersion;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;
        private Instant versionCreatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSchemaResponse model) {
            super(model);
            this.content(model.content);
            this.description(model.description);
            this.lastModified(model.lastModified);
            this.schemaArn(model.schemaArn);
            this.schemaName(model.schemaName);
            this.schemaVersion(model.schemaVersion);
            this.tags(model.tags);
            this.type(model.type);
            this.versionCreatedDate(model.versionCreatedDate);
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getVersionCreatedDate() {
            return this.versionCreatedDate;
        }

        @Override
        public final Builder versionCreatedDate(Instant versionCreatedDate) {
            this.versionCreatedDate = versionCreatedDate;
            return this;
        }

        public final void setVersionCreatedDate(Instant versionCreatedDate) {
            this.versionCreatedDate = versionCreatedDate;
        }

        @Override
        public DescribeSchemaResponse build() {
            return new DescribeSchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSchemaResponse> {
        public Builder content(String var1);

        public Builder description(String var1);

        public Builder lastModified(Instant var1);

        public Builder schemaArn(String var1);

        public Builder schemaName(String var1);

        public Builder schemaVersion(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder versionCreatedDate(Instant var1);
    }
}

