/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.schemas.model.SchemaVersionSummary;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.___listOfSchemaVersionSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchemaVersionsResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, ListSchemaVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSchemaVersionsResponse.getter(ListSchemaVersionsResponse::nextToken)).setter(ListSchemaVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SchemaVersionSummary>> SCHEMA_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListSchemaVersionsResponse.getter(ListSchemaVersionsResponse::schemaVersions)).setter(ListSchemaVersionsResponse.setter(Builder::schemaVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEMA_VERSIONS_FIELD));
    private final String nextToken;
    private final List<SchemaVersionSummary> schemaVersions;

    private ListSchemaVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schemaVersions = builder.schemaVersions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasSchemaVersions() {
        return this.schemaVersions != null && !(this.schemaVersions instanceof SdkAutoConstructList);
    }

    public List<SchemaVersionSummary> schemaVersions() {
        return this.schemaVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaVersionsResponse)) {
            return false;
        }
        ListSchemaVersionsResponse other = (ListSchemaVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.schemaVersions(), other.schemaVersions());
    }

    public String toString() {
        return ToString.builder((String)"ListSchemaVersionsResponse").add("NextToken", (Object)this.nextToken()).add("SchemaVersions", this.schemaVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SchemaVersions": {
                return Optional.ofNullable(clazz.cast(this.schemaVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaVersionsResponse, T> g) {
        return obj -> g.apply((ListSchemaVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SchemaVersionSummary> schemaVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.schemaVersions(model.schemaVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SchemaVersionSummary.Builder> getSchemaVersions() {
            return this.schemaVersions != null ? (Collection)this.schemaVersions.stream().map(SchemaVersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaVersions(Collection<SchemaVersionSummary> schemaVersions) {
            this.schemaVersions = ___listOfSchemaVersionSummaryCopier.copy(schemaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(SchemaVersionSummary ... schemaVersions) {
            this.schemaVersions(Arrays.asList(schemaVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(Consumer<SchemaVersionSummary.Builder> ... schemaVersions) {
            this.schemaVersions(Stream.of(schemaVersions).map(c -> (SchemaVersionSummary)((SchemaVersionSummary.Builder)SchemaVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaVersions(Collection<SchemaVersionSummary.BuilderImpl> schemaVersions) {
            this.schemaVersions = ___listOfSchemaVersionSummaryCopier.copyFromBuilder(schemaVersions);
        }

        @Override
        public ListSchemaVersionsResponse build() {
            return new ListSchemaVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchemaVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder schemaVersions(Collection<SchemaVersionSummary> var1);

        public Builder schemaVersions(SchemaVersionSummary ... var1);

        public Builder schemaVersions(Consumer<SchemaVersionSummary.Builder> ... var1);
    }
}

