/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.schemas.model.SchemasRequest;
import software.amazon.awssdk.services.schemas.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSchemaRequest
extends SchemasRequest
implements ToCopyableBuilder<Builder, UpdateSchemaRequest> {
    private static final SdkField<String> CLIENT_TOKEN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientTokenId").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::clientTokenId)).setter(UpdateSchemaRequest.setter(Builder::clientTokenId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientTokenId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::content)).setter(UpdateSchemaRequest.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::description)).setter(UpdateSchemaRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryName").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::registryName)).setter(UpdateSchemaRequest.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("registryName").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::schemaName)).setter(UpdateSchemaRequest.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("schemaName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::typeAsString)).setter(UpdateSchemaRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_ID_FIELD, CONTENT_FIELD, DESCRIPTION_FIELD, REGISTRY_NAME_FIELD, SCHEMA_NAME_FIELD, TYPE_FIELD));
    private final String clientTokenId;
    private final String content;
    private final String description;
    private final String registryName;
    private final String schemaName;
    private final String type;

    private UpdateSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.clientTokenId = builder.clientTokenId;
        this.content = builder.content;
        this.description = builder.description;
        this.registryName = builder.registryName;
        this.schemaName = builder.schemaName;
        this.type = builder.type;
    }

    public String clientTokenId() {
        return this.clientTokenId;
    }

    public String content() {
        return this.content;
    }

    public String description() {
        return this.description;
    }

    public String registryName() {
        return this.registryName;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientTokenId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSchemaRequest)) {
            return false;
        }
        UpdateSchemaRequest other = (UpdateSchemaRequest)((Object)obj);
        return Objects.equals(this.clientTokenId(), other.clientTokenId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.registryName(), other.registryName()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSchemaRequest").add("ClientTokenId", (Object)this.clientTokenId()).add("Content", (Object)this.content()).add("Description", (Object)this.description()).add("RegistryName", (Object)this.registryName()).add("SchemaName", (Object)this.schemaName()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientTokenId": {
                return Optional.ofNullable(clazz.cast(this.clientTokenId()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSchemaRequest, T> g) {
        return obj -> g.apply((UpdateSchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasRequest.BuilderImpl
    implements Builder {
        private String clientTokenId;
        private String content;
        private String description;
        private String registryName;
        private String schemaName;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSchemaRequest model) {
            super(model);
            this.clientTokenId(model.clientTokenId);
            this.content(model.content);
            this.description(model.description);
            this.registryName(model.registryName);
            this.schemaName(model.schemaName);
            this.type(model.type);
        }

        public final String getClientTokenId() {
            return this.clientTokenId;
        }

        @Override
        public final Builder clientTokenId(String clientTokenId) {
            this.clientTokenId = clientTokenId;
            return this;
        }

        public final void setClientTokenId(String clientTokenId) {
            this.clientTokenId = clientTokenId;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSchemaRequest build() {
            return new UpdateSchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSchemaRequest> {
        public Builder clientTokenId(String var1);

        public Builder content(String var1);

        public Builder description(String var1);

        public Builder registryName(String var1);

        public Builder schemaName(String var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

