/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.schemas.model.SchemasRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSchemasRequest
extends SchemasRequest
implements ToCopyableBuilder<Builder, SearchSchemasRequest> {
    private static final SdkField<String> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Keywords").getter(SearchSchemasRequest.getter(SearchSchemasRequest::keywords)).setter(SearchSchemasRequest.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("keywords").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(SearchSchemasRequest.getter(SearchSchemasRequest::limit)).setter(SearchSchemasRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchSchemasRequest.getter(SearchSchemasRequest::nextToken)).setter(SearchSchemasRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryName").getter(SearchSchemasRequest.getter(SearchSchemasRequest::registryName)).setter(SearchSchemasRequest.setter(Builder::registryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("registryName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYWORDS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD, REGISTRY_NAME_FIELD));
    private final String keywords;
    private final Integer limit;
    private final String nextToken;
    private final String registryName;

    private SearchSchemasRequest(BuilderImpl builder) {
        super(builder);
        this.keywords = builder.keywords;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.registryName = builder.registryName;
    }

    public final String keywords() {
        return this.keywords;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String registryName() {
        return this.registryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSchemasRequest)) {
            return false;
        }
        SearchSchemasRequest other = (SearchSchemasRequest)((Object)obj);
        return Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.registryName(), other.registryName());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSchemasRequest").add("Keywords", (Object)this.keywords()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).add("RegistryName", (Object)this.registryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RegistryName": {
                return Optional.ofNullable(clazz.cast(this.registryName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchSchemasRequest, T> g) {
        return obj -> g.apply((SearchSchemasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasRequest.BuilderImpl
    implements Builder {
        private String keywords;
        private Integer limit;
        private String nextToken;
        private String registryName;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSchemasRequest model) {
            super(model);
            this.keywords(model.keywords);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
            this.registryName(model.registryName);
        }

        public final String getKeywords() {
            return this.keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRegistryName() {
            return this.registryName;
        }

        @Override
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchSchemasRequest build() {
            return new SearchSchemasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSchemasRequest> {
        public Builder keywords(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder registryName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

