/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.schemas.model.DiscovererState;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopDiscovererResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, StopDiscovererResponse> {
    private static final SdkField<String> DISCOVERER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscovererId").getter(StopDiscovererResponse.getter(StopDiscovererResponse::discovererId)).setter(StopDiscovererResponse.setter(Builder::discovererId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscovererId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(StopDiscovererResponse.getter(StopDiscovererResponse::stateAsString)).setter(StopDiscovererResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERER_ID_FIELD, STATE_FIELD));
    private final String discovererId;
    private final String state;

    private StopDiscovererResponse(BuilderImpl builder) {
        super(builder);
        this.discovererId = builder.discovererId;
        this.state = builder.state;
    }

    public final String discovererId() {
        return this.discovererId;
    }

    public final DiscovererState state() {
        return DiscovererState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.discovererId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDiscovererResponse)) {
            return false;
        }
        StopDiscovererResponse other = (StopDiscovererResponse)((Object)obj);
        return Objects.equals(this.discovererId(), other.discovererId()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StopDiscovererResponse").add("DiscovererId", (Object)this.discovererId()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiscovererId": {
                return Optional.ofNullable(clazz.cast(this.discovererId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopDiscovererResponse, T> g) {
        return obj -> g.apply((StopDiscovererResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String discovererId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDiscovererResponse model) {
            super(model);
            this.discovererId(model.discovererId);
            this.state(model.state);
        }

        public final String getDiscovererId() {
            return this.discovererId;
        }

        @Override
        public final Builder discovererId(String discovererId) {
            this.discovererId = discovererId;
            return this;
        }

        public final void setDiscovererId(String discovererId) {
            this.discovererId = discovererId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DiscovererState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public StopDiscovererResponse build() {
            return new StopDiscovererResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopDiscovererResponse> {
        public Builder discovererId(String var1);

        public Builder state(String var1);

        public Builder state(DiscovererState var1);
    }
}

