/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSchemaResponse extends SchemasResponse implements
        ToCopyableBuilder<CreateSchemaResponse.Builder, CreateSchemaResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateSchemaResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified")
            .getter(getter(CreateSchemaResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaArn").getter(getter(CreateSchemaResponse::schemaArn)).setter(setter(Builder::schemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaArn").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(CreateSchemaResponse::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersion").getter(getter(CreateSchemaResponse::schemaVersion))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSchemaResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateSchemaResponse::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> VERSION_CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("VersionCreatedDate")
            .getter(getter(CreateSchemaResponse::versionCreatedDate))
            .setter(setter(Builder::versionCreatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionCreatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            LAST_MODIFIED_FIELD, SCHEMA_ARN_FIELD, SCHEMA_NAME_FIELD, SCHEMA_VERSION_FIELD, TAGS_FIELD, TYPE_FIELD,
            VERSION_CREATED_DATE_FIELD));

    private final String description;

    private final Instant lastModified;

    private final String schemaArn;

    private final String schemaName;

    private final String schemaVersion;

    private final Map<String, String> tags;

    private final String type;

    private final Instant versionCreatedDate;

    private CreateSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.lastModified = builder.lastModified;
        this.schemaArn = builder.schemaArn;
        this.schemaName = builder.schemaName;
        this.schemaVersion = builder.schemaVersion;
        this.tags = builder.tags;
        this.type = builder.type;
        this.versionCreatedDate = builder.versionCreatedDate;
    }

    /**
     * <p>
     * The description of the schema.
     * </p>
     * 
     * @return The description of the schema.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time that schema was modified.
     * </p>
     * 
     * @return The date and time that schema was modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The ARN of the schema.
     * </p>
     * 
     * @return The ARN of the schema.
     */
    public final String schemaArn() {
        return schemaArn;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The version number of the schema
     * </p>
     * 
     * @return The version number of the schema
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of the schema.
     * </p>
     * 
     * @return The type of the schema.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The date the schema version was created.
     * </p>
     * 
     * @return The date the schema version was created.
     */
    public final Instant versionCreatedDate() {
        return versionCreatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(versionCreatedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSchemaResponse)) {
            return false;
        }
        CreateSchemaResponse other = (CreateSchemaResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(schemaArn(), other.schemaArn()) && Objects.equals(schemaName(), other.schemaName())
                && Objects.equals(schemaVersion(), other.schemaVersion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(type(), other.type())
                && Objects.equals(versionCreatedDate(), other.versionCreatedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSchemaResponse").add("Description", description()).add("LastModified", lastModified())
                .add("SchemaArn", schemaArn()).add("SchemaName", schemaName()).add("SchemaVersion", schemaVersion())
                .add("Tags", hasTags() ? tags() : null).add("Type", type()).add("VersionCreatedDate", versionCreatedDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "SchemaArn":
            return Optional.ofNullable(clazz.cast(schemaArn()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "SchemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "VersionCreatedDate":
            return Optional.ofNullable(clazz.cast(versionCreatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSchemaResponse, T> g) {
        return obj -> g.apply((CreateSchemaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSchemaResponse> {
        /**
         * <p>
         * The description of the schema.
         * </p>
         * 
         * @param description
         *        The description of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time that schema was modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time that schema was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The ARN of the schema.
         * </p>
         * 
         * @param schemaArn
         *        The ARN of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaArn(String schemaArn);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The version number of the schema
         * </p>
         * 
         * @param schemaVersion
         *        The version number of the schema
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of the schema.
         * </p>
         * 
         * @param type
         *        The type of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The date the schema version was created.
         * </p>
         * 
         * @param versionCreatedDate
         *        The date the schema version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionCreatedDate(Instant versionCreatedDate);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private String description;

        private Instant lastModified;

        private String schemaArn;

        private String schemaName;

        private String schemaVersion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private Instant versionCreatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSchemaResponse model) {
            super(model);
            description(model.description);
            lastModified(model.lastModified);
            schemaArn(model.schemaArn);
            schemaName(model.schemaName);
            schemaVersion(model.schemaVersion);
            tags(model.tags);
            type(model.type);
            versionCreatedDate(model.versionCreatedDate);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getSchemaArn() {
            return schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getVersionCreatedDate() {
            return versionCreatedDate;
        }

        @Override
        public final Builder versionCreatedDate(Instant versionCreatedDate) {
            this.versionCreatedDate = versionCreatedDate;
            return this;
        }

        public final void setVersionCreatedDate(Instant versionCreatedDate) {
            this.versionCreatedDate = versionCreatedDate;
        }

        @Override
        public CreateSchemaResponse build() {
            return new CreateSchemaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
