/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemaVersionsRequest extends SchemasRequest implements
        ToCopyableBuilder<ListSchemaVersionsRequest.Builder, ListSchemaVersionsRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListSchemaVersionsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSchemaVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> REGISTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryName").getter(getter(ListSchemaVersionsRequest::registryName))
            .setter(setter(Builder::registryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("registryName").build()).build();

    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(ListSchemaVersionsRequest::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("schemaName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, NEXT_TOKEN_FIELD,
            REGISTRY_NAME_FIELD, SCHEMA_NAME_FIELD));

    private final Integer limit;

    private final String nextToken;

    private final String registryName;

    private final String schemaName;

    private ListSchemaVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
        this.registryName = builder.registryName;
        this.schemaName = builder.schemaName;
    }

    /**
     * Returns the value of the Limit property for this object.
     * 
     * @return The value of the Limit property for this object.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The token that specifies the next page of results to return. To request the first page, leave NextToken empty.
     * The token will expire in 24 hours, and cannot be shared with other accounts.
     * </p>
     * 
     * @return The token that specifies the next page of results to return. To request the first page, leave NextToken
     *         empty. The token will expire in 24 hours, and cannot be shared with other accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the registry.
     * </p>
     * 
     * @return The name of the registry.
     */
    public final String registryName() {
        return registryName;
    }

    /**
     * <p>
     * The name of the schema.
     * </p>
     * 
     * @return The name of the schema.
     */
    public final String schemaName() {
        return schemaName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(registryName());
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaVersionsRequest)) {
            return false;
        }
        ListSchemaVersionsRequest other = (ListSchemaVersionsRequest) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(registryName(), other.registryName()) && Objects.equals(schemaName(), other.schemaName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemaVersionsRequest").add("Limit", limit()).add("NextToken", nextToken())
                .add("RegistryName", registryName()).add("SchemaName", schemaName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RegistryName":
            return Optional.ofNullable(clazz.cast(registryName()));
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaVersionsRequest, T> g) {
        return obj -> g.apply((ListSchemaVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSchemaVersionsRequest> {
        /**
         * Sets the value of the Limit property for this object.
         *
         * @param limit
         *        The new value for the Limit property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The token that specifies the next page of results to return. To request the first page, leave NextToken
         * empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results to return. To request the first page, leave
         *        NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the registry.
         * </p>
         * 
         * @param registryName
         *        The name of the registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryName(String registryName);

        /**
         * <p>
         * The name of the schema.
         * </p>
         * 
         * @param schemaName
         *        The name of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SchemasRequest.BuilderImpl implements Builder {
        private Integer limit;

        private String nextToken;

        private String registryName;

        private String schemaName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaVersionsRequest model) {
            super(model);
            limit(model.limit);
            nextToken(model.nextToken);
            registryName(model.registryName);
            schemaName(model.schemaName);
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRegistryName() {
            return registryName;
        }

        public final void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        @Transient
        public final Builder registryName(String registryName) {
            this.registryName = registryName;
            return this;
        }

        public final String getSchemaName() {
            return schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        @Transient
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSchemaVersionsRequest build() {
            return new ListSchemaVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
