/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegistriesResponse extends SchemasResponse implements
        ToCopyableBuilder<ListRegistriesResponse.Builder, ListRegistriesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRegistriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RegistrySummary>> REGISTRIES_FIELD = SdkField
            .<List<RegistrySummary>> builder(MarshallingType.LIST)
            .memberName("Registries")
            .getter(getter(ListRegistriesResponse::registries))
            .setter(setter(Builder::registries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Registries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistrySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistrySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REGISTRIES_FIELD));

    private final String nextToken;

    private final List<RegistrySummary> registries;

    private ListRegistriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.registries = builder.registries;
    }

    /**
     * <p>
     * The token that specifies the next page of results to return. To request the first page, leave NextToken empty.
     * The token will expire in 24 hours, and cannot be shared with other accounts.
     * </p>
     * 
     * @return The token that specifies the next page of results to return. To request the first page, leave NextToken
     *         empty. The token will expire in 24 hours, and cannot be shared with other accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Registries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegistries() {
        return registries != null && !(registries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of registry summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistries} method.
     * </p>
     * 
     * @return An array of registry summaries.
     */
    public final List<RegistrySummary> registries() {
        return registries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistries() ? registries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegistriesResponse)) {
            return false;
        }
        ListRegistriesResponse other = (ListRegistriesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRegistries() == other.hasRegistries()
                && Objects.equals(registries(), other.registries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRegistriesResponse").add("NextToken", nextToken())
                .add("Registries", hasRegistries() ? registries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Registries":
            return Optional.ofNullable(clazz.cast(registries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRegistriesResponse, T> g) {
        return obj -> g.apply((ListRegistriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRegistriesResponse> {
        /**
         * <p>
         * The token that specifies the next page of results to return. To request the first page, leave NextToken
         * empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results to return. To request the first page, leave
         *        NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of registry summaries.
         * </p>
         * 
         * @param registries
         *        An array of registry summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registries(Collection<RegistrySummary> registries);

        /**
         * <p>
         * An array of registry summaries.
         * </p>
         * 
         * @param registries
         *        An array of registry summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registries(RegistrySummary... registries);

        /**
         * <p>
         * An array of registry summaries.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RegistrySummary>.Builder} avoiding
         * the need to create one manually via {@link List<RegistrySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegistrySummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #registries(List<RegistrySummary>)}.
         * 
         * @param registries
         *        a consumer that will call methods on {@link List<RegistrySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registries(List<RegistrySummary>)
         */
        Builder registries(Consumer<RegistrySummary.Builder>... registries);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RegistrySummary> registries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegistriesResponse model) {
            super(model);
            nextToken(model.nextToken);
            registries(model.registries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RegistrySummary.Builder> getRegistries() {
            List<RegistrySummary.Builder> result = ___listOfRegistrySummaryCopier.copyToBuilder(this.registries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistries(Collection<RegistrySummary.BuilderImpl> registries) {
            this.registries = ___listOfRegistrySummaryCopier.copyFromBuilder(registries);
        }

        @Override
        public final Builder registries(Collection<RegistrySummary> registries) {
            this.registries = ___listOfRegistrySummaryCopier.copy(registries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(RegistrySummary... registries) {
            registries(Arrays.asList(registries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registries(Consumer<RegistrySummary.Builder>... registries) {
            registries(Stream.of(registries).map(c -> RegistrySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRegistriesResponse build() {
            return new ListRegistriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
