/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSchemaVersionsResponse extends SchemasResponse implements
        ToCopyableBuilder<ListSchemaVersionsResponse.Builder, ListSchemaVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSchemaVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SchemaVersionSummary>> SCHEMA_VERSIONS_FIELD = SdkField
            .<List<SchemaVersionSummary>> builder(MarshallingType.LIST)
            .memberName("SchemaVersions")
            .getter(getter(ListSchemaVersionsResponse::schemaVersions))
            .setter(setter(Builder::schemaVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCHEMA_VERSIONS_FIELD));

    private final String nextToken;

    private final List<SchemaVersionSummary> schemaVersions;

    private ListSchemaVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schemaVersions = builder.schemaVersions;
    }

    /**
     * <p>
     * The token that specifies the next page of results to return. To request the first page, leave NextToken empty.
     * The token will expire in 24 hours, and cannot be shared with other accounts.
     * </p>
     * 
     * @return The token that specifies the next page of results to return. To request the first page, leave NextToken
     *         empty. The token will expire in 24 hours, and cannot be shared with other accounts.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SchemaVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSchemaVersions() {
        return schemaVersions != null && !(schemaVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of schema version summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchemaVersions} method.
     * </p>
     * 
     * @return An array of schema version summaries.
     */
    public final List<SchemaVersionSummary> schemaVersions() {
        return schemaVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSchemaVersions() ? schemaVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemaVersionsResponse)) {
            return false;
        }
        ListSchemaVersionsResponse other = (ListSchemaVersionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSchemaVersions() == other.hasSchemaVersions()
                && Objects.equals(schemaVersions(), other.schemaVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSchemaVersionsResponse").add("NextToken", nextToken())
                .add("SchemaVersions", hasSchemaVersions() ? schemaVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SchemaVersions":
            return Optional.ofNullable(clazz.cast(schemaVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSchemaVersionsResponse, T> g) {
        return obj -> g.apply((ListSchemaVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SchemasResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSchemaVersionsResponse> {
        /**
         * <p>
         * The token that specifies the next page of results to return. To request the first page, leave NextToken
         * empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * </p>
         * 
         * @param nextToken
         *        The token that specifies the next page of results to return. To request the first page, leave
         *        NextToken empty. The token will expire in 24 hours, and cannot be shared with other accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * 
         * @param schemaVersions
         *        An array of schema version summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersions(Collection<SchemaVersionSummary> schemaVersions);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * 
         * @param schemaVersions
         *        An array of schema version summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersions(SchemaVersionSummary... schemaVersions);

        /**
         * <p>
         * An array of schema version summaries.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SchemaVersionSummary>.Builder}
         * avoiding the need to create one manually via {@link List<SchemaVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaVersionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #schemaVersions(List<SchemaVersionSummary>)}.
         * 
         * @param schemaVersions
         *        a consumer that will call methods on {@link List<SchemaVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaVersions(List<SchemaVersionSummary>)
         */
        Builder schemaVersions(Consumer<SchemaVersionSummary.Builder>... schemaVersions);
    }

    static final class BuilderImpl extends SchemasResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SchemaVersionSummary> schemaVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemaVersionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            schemaVersions(model.schemaVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SchemaVersionSummary.Builder> getSchemaVersions() {
            List<SchemaVersionSummary.Builder> result = ___listOfSchemaVersionSummaryCopier.copyToBuilder(this.schemaVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaVersions(Collection<SchemaVersionSummary.BuilderImpl> schemaVersions) {
            this.schemaVersions = ___listOfSchemaVersionSummaryCopier.copyFromBuilder(schemaVersions);
        }

        @Override
        public final Builder schemaVersions(Collection<SchemaVersionSummary> schemaVersions) {
            this.schemaVersions = ___listOfSchemaVersionSummaryCopier.copy(schemaVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(SchemaVersionSummary... schemaVersions) {
            schemaVersions(Arrays.asList(schemaVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersions(Consumer<SchemaVersionSummary.Builder>... schemaVersions) {
            schemaVersions(Stream.of(schemaVersions).map(c -> SchemaVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSchemaVersionsResponse build() {
            return new ListSchemaVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
