/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.schemas;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.CreateDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.CreateRegistryRequest;
import software.amazon.awssdk.services.schemas.model.CreateRegistryResponse;
import software.amazon.awssdk.services.schemas.model.CreateSchemaRequest;
import software.amazon.awssdk.services.schemas.model.CreateSchemaResponse;
import software.amazon.awssdk.services.schemas.model.DeleteDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.DeleteDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.DeleteRegistryRequest;
import software.amazon.awssdk.services.schemas.model.DeleteRegistryResponse;
import software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionResponse;
import software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest;
import software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse;
import software.amazon.awssdk.services.schemas.model.DescribeDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.DescribeDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.DescribeRegistryRequest;
import software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse;
import software.amazon.awssdk.services.schemas.model.DescribeSchemaRequest;
import software.amazon.awssdk.services.schemas.model.DescribeSchemaResponse;
import software.amazon.awssdk.services.schemas.model.ExportSchemaRequest;
import software.amazon.awssdk.services.schemas.model.ExportSchemaResponse;
import software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest;
import software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceResponse;
import software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest;
import software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaResponse;
import software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse;
import software.amazon.awssdk.services.schemas.model.ListRegistriesRequest;
import software.amazon.awssdk.services.schemas.model.ListRegistriesResponse;
import software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.schemas.model.ListSchemasRequest;
import software.amazon.awssdk.services.schemas.model.ListSchemasResponse;
import software.amazon.awssdk.services.schemas.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.schemas.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest;
import software.amazon.awssdk.services.schemas.model.PutCodeBindingResponse;
import software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.SearchSchemasRequest;
import software.amazon.awssdk.services.schemas.model.SearchSchemasResponse;
import software.amazon.awssdk.services.schemas.model.StartDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.StartDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.StopDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.StopDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.TagResourceRequest;
import software.amazon.awssdk.services.schemas.model.TagResourceResponse;
import software.amazon.awssdk.services.schemas.model.UntagResourceRequest;
import software.amazon.awssdk.services.schemas.model.UntagResourceResponse;
import software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.UpdateDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest;
import software.amazon.awssdk.services.schemas.model.UpdateRegistryResponse;
import software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.schemas.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.schemas.paginators.ListDiscoverersPublisher;
import software.amazon.awssdk.services.schemas.paginators.ListRegistriesPublisher;
import software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsPublisher;
import software.amazon.awssdk.services.schemas.paginators.ListSchemasPublisher;
import software.amazon.awssdk.services.schemas.paginators.SearchSchemasPublisher;
import software.amazon.awssdk.services.schemas.waiters.SchemasAsyncWaiter;

/**
 * Service client for accessing Schemas asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon EventBridge Schema Registry
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SchemasAsyncClient extends AwsClient {
    String SERVICE_NAME = "schemas";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "schemas";

    /**
     * <p>
     * Creates a discoverer.
     * </p>
     *
     * @param createDiscovererRequest
     * @return A Java Future containing the result of the CreateDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.CreateDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDiscovererResponse> createDiscoverer(CreateDiscovererRequest createDiscovererRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a discoverer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDiscovererRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDiscovererRequest#builder()}
     * </p>
     *
     * @param createDiscovererRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.CreateDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDiscovererResponse> createDiscoverer(
            Consumer<CreateDiscovererRequest.Builder> createDiscovererRequest) {
        return createDiscoverer(CreateDiscovererRequest.builder().applyMutation(createDiscovererRequest).build());
    }

    /**
     * <p>
     * Creates a registry.
     * </p>
     *
     * @param createRegistryRequest
     * @return A Java Future containing the result of the CreateRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.CreateRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRegistryResponse> createRegistry(CreateRegistryRequest createRegistryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRegistryRequest#builder()}
     * </p>
     *
     * @param createRegistryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.CreateRegistryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.CreateRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRegistryResponse> createRegistry(Consumer<CreateRegistryRequest.Builder> createRegistryRequest) {
        return createRegistry(CreateRegistryRequest.builder().applyMutation(createRegistryRequest).build());
    }

    /**
     * <p>
     * Creates a schema definition.
     * </p>
     * <note>
     * <p>
     * Inactive schemas will be deleted after two years.
     * </p>
     * </note>
     *
     * @param createSchemaRequest
     * @return A Java Future containing the result of the CreateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSchemaResponse> createSchema(CreateSchemaRequest createSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a schema definition.
     * </p>
     * <note>
     * <p>
     * Inactive schemas will be deleted after two years.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSchemaRequest#builder()}
     * </p>
     *
     * @param createSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.CreateSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.CreateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSchemaResponse> createSchema(Consumer<CreateSchemaRequest.Builder> createSchemaRequest) {
        return createSchema(CreateSchemaRequest.builder().applyMutation(createSchemaRequest).build());
    }

    /**
     * <p>
     * Deletes a discoverer.
     * </p>
     *
     * @param deleteDiscovererRequest
     * @return A Java Future containing the result of the DeleteDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDiscovererResponse> deleteDiscoverer(DeleteDiscovererRequest deleteDiscovererRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a discoverer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDiscovererRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDiscovererRequest#builder()}
     * </p>
     *
     * @param deleteDiscovererRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DeleteDiscovererRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDiscovererResponse> deleteDiscoverer(
            Consumer<DeleteDiscovererRequest.Builder> deleteDiscovererRequest) {
        return deleteDiscoverer(DeleteDiscovererRequest.builder().applyMutation(deleteDiscovererRequest).build());
    }

    /**
     * <p>
     * Deletes a Registry.
     * </p>
     *
     * @param deleteRegistryRequest
     * @return A Java Future containing the result of the DeleteRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRegistryResponse> deleteRegistry(DeleteRegistryRequest deleteRegistryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRegistryRequest#builder()}
     * </p>
     *
     * @param deleteRegistryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DeleteRegistryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRegistryResponse> deleteRegistry(Consumer<DeleteRegistryRequest.Builder> deleteRegistryRequest) {
        return deleteRegistry(DeleteRegistryRequest.builder().applyMutation(deleteRegistryRequest).build());
    }

    /**
     * <p>
     * Delete the resource-based policy attached to the specified registry.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the resource-based policy attached to the specified registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Delete a schema definition.
     * </p>
     *
     * @param deleteSchemaRequest
     * @return A Java Future containing the result of the DeleteSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSchemaResponse> deleteSchema(DeleteSchemaRequest deleteSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a schema definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSchemaRequest#builder()}
     * </p>
     *
     * @param deleteSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSchemaResponse> deleteSchema(Consumer<DeleteSchemaRequest.Builder> deleteSchemaRequest) {
        return deleteSchema(DeleteSchemaRequest.builder().applyMutation(deleteSchemaRequest).build());
    }

    /**
     * <p>
     * Delete the schema version definition
     * </p>
     *
     * @param deleteSchemaVersionRequest
     * @return A Java Future containing the result of the DeleteSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchemaVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSchemaVersionResponse> deleteSchemaVersion(
            DeleteSchemaVersionRequest deleteSchemaVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the schema version definition
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSchemaVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSchemaVersionRequest#builder()}
     * </p>
     *
     * @param deleteSchemaVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSchemaVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DeleteSchemaVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DeleteSchemaVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSchemaVersionResponse> deleteSchemaVersion(
            Consumer<DeleteSchemaVersionRequest.Builder> deleteSchemaVersionRequest) {
        return deleteSchemaVersion(DeleteSchemaVersionRequest.builder().applyMutation(deleteSchemaVersionRequest).build());
    }

    /**
     * <p>
     * Describe the code binding URI.
     * </p>
     *
     * @param describeCodeBindingRequest
     * @return A Java Future containing the result of the DescribeCodeBinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DescribeCodeBinding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeCodeBinding" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeCodeBindingResponse> describeCodeBinding(
            DescribeCodeBindingRequest describeCodeBindingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the code binding URI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCodeBindingRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCodeBindingRequest#builder()}
     * </p>
     *
     * @param describeCodeBindingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCodeBinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DescribeCodeBinding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeCodeBinding" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeCodeBindingResponse> describeCodeBinding(
            Consumer<DescribeCodeBindingRequest.Builder> describeCodeBindingRequest) {
        return describeCodeBinding(DescribeCodeBindingRequest.builder().applyMutation(describeCodeBindingRequest).build());
    }

    /**
     * <p>
     * Describes the discoverer.
     * </p>
     *
     * @param describeDiscovererRequest
     * @return A Java Future containing the result of the DescribeDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DescribeDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeDiscoverer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDiscovererResponse> describeDiscoverer(DescribeDiscovererRequest describeDiscovererRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the discoverer.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDiscovererRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDiscovererRequest#builder()}
     * </p>
     *
     * @param describeDiscovererRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DescribeDiscovererRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DescribeDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeDiscoverer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDiscovererResponse> describeDiscoverer(
            Consumer<DescribeDiscovererRequest.Builder> describeDiscovererRequest) {
        return describeDiscoverer(DescribeDiscovererRequest.builder().applyMutation(describeDiscovererRequest).build());
    }

    /**
     * <p>
     * Describes the registry.
     * </p>
     *
     * @param describeRegistryRequest
     * @return A Java Future containing the result of the DescribeRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DescribeRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRegistryResponse> describeRegistry(DescribeRegistryRequest describeRegistryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRegistryRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRegistryRequest#builder()}
     * </p>
     *
     * @param describeRegistryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DescribeRegistryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DescribeRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeRegistryResponse> describeRegistry(
            Consumer<DescribeRegistryRequest.Builder> describeRegistryRequest) {
        return describeRegistry(DescribeRegistryRequest.builder().applyMutation(describeRegistryRequest).build());
    }

    /**
     * <p>
     * Retrieve the schema definition.
     * </p>
     *
     * @param describeSchemaRequest
     * @return A Java Future containing the result of the DescribeSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DescribeSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSchemaResponse> describeSchema(DescribeSchemaRequest describeSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the schema definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSchemaRequest#builder()}
     * </p>
     *
     * @param describeSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.DescribeSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.DescribeSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/DescribeSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSchemaResponse> describeSchema(Consumer<DescribeSchemaRequest.Builder> describeSchemaRequest) {
        return describeSchema(DescribeSchemaRequest.builder().applyMutation(describeSchemaRequest).build());
    }

    /**
     * Invokes the ExportSchema operation asynchronously.
     *
     * @param exportSchemaRequest
     * @return A Java Future containing the result of the ExportSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ExportSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ExportSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportSchemaResponse> exportSchema(ExportSchemaRequest exportSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Invokes the ExportSchema operation asynchronously.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link ExportSchemaRequest#builder()}
     * </p>
     *
     * @param exportSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ExportSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ExportSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ExportSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ExportSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ExportSchemaResponse> exportSchema(Consumer<ExportSchemaRequest.Builder> exportSchemaRequest) {
        return exportSchema(ExportSchemaRequest.builder().applyMutation(exportSchemaRequest).build());
    }

    /**
     * <p>
     * Get the code binding source URI.
     * </p>
     *
     * @param getCodeBindingSourceRequest
     * @return A Java Future containing the result of the GetCodeBindingSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.GetCodeBindingSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetCodeBindingSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCodeBindingSourceResponse> getCodeBindingSource(
            GetCodeBindingSourceRequest getCodeBindingSourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the code binding source URI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCodeBindingSourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetCodeBindingSourceRequest#builder()}
     * </p>
     *
     * @param getCodeBindingSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCodeBindingSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.GetCodeBindingSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetCodeBindingSource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCodeBindingSourceResponse> getCodeBindingSource(
            Consumer<GetCodeBindingSourceRequest.Builder> getCodeBindingSourceRequest) {
        return getCodeBindingSource(GetCodeBindingSourceRequest.builder().applyMutation(getCodeBindingSourceRequest).build());
    }

    /**
     * <p>
     * Get the discovered schema that was generated based on sampled events.
     * </p>
     *
     * @param getDiscoveredSchemaRequest
     * @return A Java Future containing the result of the GetDiscoveredSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.GetDiscoveredSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetDiscoveredSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDiscoveredSchemaResponse> getDiscoveredSchema(
            GetDiscoveredSchemaRequest getDiscoveredSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the discovered schema that was generated based on sampled events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDiscoveredSchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetDiscoveredSchemaRequest#builder()}
     * </p>
     *
     * @param getDiscoveredSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDiscoveredSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.GetDiscoveredSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetDiscoveredSchema" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDiscoveredSchemaResponse> getDiscoveredSchema(
            Consumer<GetDiscoveredSchemaRequest.Builder> getDiscoveredSchemaRequest) {
        return getDiscoveredSchema(GetDiscoveredSchemaRequest.builder().applyMutation(getDiscoveredSchemaRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource-based policy attached to a given registry.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource-based policy attached to a given registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/GetResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * List the discoverers.
     * </p>
     *
     * @param listDiscoverersRequest
     * @return A Java Future containing the result of the ListDiscoverers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListDiscoverers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDiscoverersResponse> listDiscoverers(ListDiscoverersRequest listDiscoverersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the discoverers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoverersRequest.Builder} avoiding the need
     * to create one manually via {@link ListDiscoverersRequest#builder()}
     * </p>
     *
     * @param listDiscoverersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDiscoverers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListDiscoverers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDiscoverersResponse> listDiscoverers(
            Consumer<ListDiscoverersRequest.Builder> listDiscoverersRequest) {
        return listDiscoverers(ListDiscoverersRequest.builder().applyMutation(listDiscoverersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDiscoverers(software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListDiscoverersPublisher publisher = client.listDiscoverersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListDiscoverersPublisher publisher = client.listDiscoverersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoverers(software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest)} operation.</b>
     * </p>
     *
     * @param listDiscoverersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListDiscoverers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDiscoverersPublisher listDiscoverersPaginator(ListDiscoverersRequest listDiscoverersRequest) {
        return new ListDiscoverersPublisher(this, listDiscoverersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDiscoverers(software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListDiscoverersPublisher publisher = client.listDiscoverersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListDiscoverersPublisher publisher = client.listDiscoverersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDiscoverers(software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDiscoverersRequest.Builder} avoiding the need
     * to create one manually via {@link ListDiscoverersRequest#builder()}
     * </p>
     *
     * @param listDiscoverersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListDiscoverers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListDiscoverers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDiscoverersPublisher listDiscoverersPaginator(Consumer<ListDiscoverersRequest.Builder> listDiscoverersRequest) {
        return listDiscoverersPaginator(ListDiscoverersRequest.builder().applyMutation(listDiscoverersRequest).build());
    }

    /**
     * <p>
     * List the registries.
     * </p>
     *
     * @param listRegistriesRequest
     * @return A Java Future containing the result of the ListRegistries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRegistriesResponse> listRegistries(ListRegistriesRequest listRegistriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the registries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegistriesRequest#builder()}
     * </p>
     *
     * @param listRegistriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListRegistriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRegistries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRegistriesResponse> listRegistries(Consumer<ListRegistriesRequest.Builder> listRegistriesRequest) {
        return listRegistries(ListRegistriesRequest.builder().applyMutation(listRegistriesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRegistries(software.amazon.awssdk.services.schemas.model.ListRegistriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListRegistriesPublisher publisher = client.listRegistriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListRegistriesPublisher publisher = client.listRegistriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.ListRegistriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.ListRegistriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistries(software.amazon.awssdk.services.schemas.model.ListRegistriesRequest)} operation.</b>
     * </p>
     *
     * @param listRegistriesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesPublisher listRegistriesPaginator(ListRegistriesRequest listRegistriesRequest) {
        return new ListRegistriesPublisher(this, listRegistriesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRegistries(software.amazon.awssdk.services.schemas.model.ListRegistriesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListRegistriesPublisher publisher = client.listRegistriesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListRegistriesPublisher publisher = client.listRegistriesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.ListRegistriesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.ListRegistriesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegistries(software.amazon.awssdk.services.schemas.model.ListRegistriesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegistriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegistriesRequest#builder()}
     * </p>
     *
     * @param listRegistriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListRegistriesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListRegistries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRegistriesPublisher listRegistriesPaginator(Consumer<ListRegistriesRequest.Builder> listRegistriesRequest) {
        return listRegistriesPaginator(ListRegistriesRequest.builder().applyMutation(listRegistriesRequest).build());
    }

    /**
     * <p>
     * Provides a list of the schema versions and related information.
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return A Java Future containing the result of the ListSchemaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSchemaVersionsResponse> listSchemaVersions(ListSchemaVersionsRequest listSchemaVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of the schema versions and related information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSchemaVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSchemaVersionsResponse> listSchemaVersions(
            Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest) {
        return listSchemaVersions(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsPublisher publisher = client.listSchemaVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsPublisher publisher = client.listSchemaVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSchemaVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSchemaVersionsPublisher listSchemaVersionsPaginator(ListSchemaVersionsRequest listSchemaVersionsRequest) {
        return new ListSchemaVersionsPublisher(this, listSchemaVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSchemaVersions(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsPublisher publisher = client.listSchemaVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemaVersionsPublisher publisher = client.listSchemaVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemaVersions(software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemaVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSchemaVersionsRequest#builder()}
     * </p>
     *
     * @param listSchemaVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListSchemaVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemaVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSchemaVersionsPublisher listSchemaVersionsPaginator(
            Consumer<ListSchemaVersionsRequest.Builder> listSchemaVersionsRequest) {
        return listSchemaVersionsPaginator(ListSchemaVersionsRequest.builder().applyMutation(listSchemaVersionsRequest).build());
    }

    /**
     * <p>
     * List the schemas.
     * </p>
     *
     * @param listSchemasRequest
     * @return A Java Future containing the result of the ListSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSchemasResponse> listSchemas(ListSchemasRequest listSchemasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the schemas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListSchemasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSchemasResponse> listSchemas(Consumer<ListSchemasRequest.Builder> listSchemasRequest) {
        return listSchemas(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.schemas.model.ListSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemasPublisher publisher = client.listSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemasPublisher publisher = client.listSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.ListSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.ListSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.schemas.model.ListSchemasRequest)} operation.</b>
     * </p>
     *
     * @param listSchemasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasPublisher listSchemasPaginator(ListSchemasRequest listSchemasRequest) {
        return new ListSchemasPublisher(this, listSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.schemas.model.ListSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemasPublisher publisher = client.listSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.ListSchemasPublisher publisher = client.listSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.ListSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.ListSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.schemas.model.ListSchemasRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListSchemasRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasPublisher listSchemasPaginator(Consumer<ListSchemasRequest.Builder> listSchemasRequest) {
        return listSchemasPaginator(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Get tags for resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get tags for resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Put code binding URI
     * </p>
     *
     * @param putCodeBindingRequest
     * @return A Java Future containing the result of the PutCodeBinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GoneException 410 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.PutCodeBinding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutCodeBinding" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutCodeBindingResponse> putCodeBinding(PutCodeBindingRequest putCodeBindingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put code binding URI
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutCodeBindingRequest.Builder} avoiding the need to
     * create one manually via {@link PutCodeBindingRequest#builder()}
     * </p>
     *
     * @param putCodeBindingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutCodeBinding operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>GoneException 410 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.PutCodeBinding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutCodeBinding" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutCodeBindingResponse> putCodeBinding(Consumer<PutCodeBindingRequest.Builder> putCodeBindingRequest) {
        return putCodeBinding(PutCodeBindingRequest.builder().applyMutation(putCodeBindingRequest).build());
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     *
     * @param putResourcePolicyRequest
     *        The name of the policy.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>PreconditionFailedException 412 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest.Builder} to create a
     *        request. The name of the policy.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>PreconditionFailedException 412 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Search the schemas
     * </p>
     *
     * @param searchSchemasRequest
     * @return A Java Future containing the result of the SearchSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.SearchSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchSchemasResponse> searchSchemas(SearchSchemasRequest searchSchemasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Search the schemas
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link SearchSchemasRequest#builder()}
     * </p>
     *
     * @param searchSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.SearchSchemasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.SearchSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchSchemasResponse> searchSchemas(Consumer<SearchSchemasRequest.Builder> searchSchemasRequest) {
        return searchSchemas(SearchSchemasRequest.builder().applyMutation(searchSchemasRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #searchSchemas(software.amazon.awssdk.services.schemas.model.SearchSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.SearchSchemasPublisher publisher = client.searchSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.SearchSchemasPublisher publisher = client.searchSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.SearchSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.SearchSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSchemas(software.amazon.awssdk.services.schemas.model.SearchSchemasRequest)} operation.</b>
     * </p>
     *
     * @param searchSchemasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.SearchSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSchemasPublisher searchSchemasPaginator(SearchSchemasRequest searchSchemasRequest) {
        return new SearchSchemasPublisher(this, searchSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #searchSchemas(software.amazon.awssdk.services.schemas.model.SearchSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.SearchSchemasPublisher publisher = client.searchSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.schemas.paginators.SearchSchemasPublisher publisher = client.searchSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.schemas.model.SearchSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.schemas.model.SearchSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSchemas(software.amazon.awssdk.services.schemas.model.SearchSchemasRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link SearchSchemasRequest#builder()}
     * </p>
     *
     * @param searchSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.SearchSchemasRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.SearchSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/SearchSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchSchemasPublisher searchSchemasPaginator(Consumer<SearchSchemasRequest.Builder> searchSchemasRequest) {
        return searchSchemasPaginator(SearchSchemasRequest.builder().applyMutation(searchSchemasRequest).build());
    }

    /**
     * <p>
     * Starts the discoverer
     * </p>
     *
     * @param startDiscovererRequest
     * @return A Java Future containing the result of the StartDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.StartDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StartDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDiscovererResponse> startDiscoverer(StartDiscovererRequest startDiscovererRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the discoverer
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDiscovererRequest.Builder} avoiding the need
     * to create one manually via {@link StartDiscovererRequest#builder()}
     * </p>
     *
     * @param startDiscovererRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.StartDiscovererRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.StartDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StartDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDiscovererResponse> startDiscoverer(
            Consumer<StartDiscovererRequest.Builder> startDiscovererRequest) {
        return startDiscoverer(StartDiscovererRequest.builder().applyMutation(startDiscovererRequest).build());
    }

    /**
     * <p>
     * Stops the discoverer
     * </p>
     *
     * @param stopDiscovererRequest
     * @return A Java Future containing the result of the StopDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.StopDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StopDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDiscovererResponse> stopDiscoverer(StopDiscovererRequest stopDiscovererRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the discoverer
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDiscovererRequest.Builder} avoiding the need to
     * create one manually via {@link StopDiscovererRequest#builder()}
     * </p>
     *
     * @param stopDiscovererRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.StopDiscovererRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.StopDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/StopDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDiscovererResponse> stopDiscoverer(Consumer<StopDiscovererRequest.Builder> stopDiscovererRequest) {
        return stopDiscoverer(StopDiscovererRequest.builder().applyMutation(stopDiscovererRequest).build());
    }

    /**
     * <p>
     * Add tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the discoverer
     * </p>
     *
     * @param updateDiscovererRequest
     * @return A Java Future containing the result of the UpdateDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.UpdateDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDiscovererResponse> updateDiscoverer(UpdateDiscovererRequest updateDiscovererRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the discoverer
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDiscovererRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDiscovererRequest#builder()}
     * </p>
     *
     * @param updateDiscovererRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDiscoverer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.UpdateDiscoverer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateDiscoverer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDiscovererResponse> updateDiscoverer(
            Consumer<UpdateDiscovererRequest.Builder> updateDiscovererRequest) {
        return updateDiscoverer(UpdateDiscovererRequest.builder().applyMutation(updateDiscovererRequest).build());
    }

    /**
     * <p>
     * Updates a registry.
     * </p>
     *
     * @param updateRegistryRequest
     *        Updates the registry.
     * @return A Java Future containing the result of the UpdateRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.UpdateRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRegistryResponse> updateRegistry(UpdateRegistryRequest updateRegistryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a registry.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRegistryRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRegistryRequest#builder()}
     * </p>
     *
     * @param updateRegistryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest.Builder} to create a request.
     *        Updates the registry.
     * @return A Java Future containing the result of the UpdateRegistry operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>UnauthorizedException 401 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.UpdateRegistry
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateRegistry" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRegistryResponse> updateRegistry(Consumer<UpdateRegistryRequest.Builder> updateRegistryRequest) {
        return updateRegistry(UpdateRegistryRequest.builder().applyMutation(updateRegistryRequest).build());
    }

    /**
     * <p>
     * Updates the schema definition
     * </p>
     * <note>
     * <p>
     * Inactive schemas will be deleted after two years.
     * </p>
     * </note>
     *
     * @param updateSchemaRequest
     * @return A Java Future containing the result of the UpdateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.UpdateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSchemaResponse> updateSchema(UpdateSchemaRequest updateSchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the schema definition
     * </p>
     * <note>
     * <p>
     * Inactive schemas will be deleted after two years.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSchemaRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSchemaRequest#builder()}
     * </p>
     *
     * @param updateSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>ServiceUnavailableException 503 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SchemasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SchemasAsyncClient.UpdateSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/UpdateSchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSchemaResponse> updateSchema(Consumer<UpdateSchemaRequest.Builder> updateSchemaRequest) {
        return updateSchema(UpdateSchemaRequest.builder().applyMutation(updateSchemaRequest).build());
    }

    /**
     * Create an instance of {@link SchemasAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link SchemasAsyncWaiter}
     */
    default SchemasAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default SchemasServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SchemasAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SchemasAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SchemasAsyncClient}.
     */
    static SchemasAsyncClientBuilder builder() {
        return new DefaultSchemasAsyncClientBuilder();
    }
}
