/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.schemas.SchemasClient;
import software.amazon.awssdk.services.schemas.internal.UserAgentUtils;
import software.amazon.awssdk.services.schemas.model.ListSchemasRequest;
import software.amazon.awssdk.services.schemas.model.ListSchemasResponse;
import software.amazon.awssdk.services.schemas.model.SchemaSummary;

public class ListSchemasIterable
implements SdkIterable<ListSchemasResponse> {
    private final SchemasClient client;
    private final ListSchemasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSchemasIterable(SchemasClient client, ListSchemasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSchemasResponseFetcher();
    }

    public Iterator<ListSchemasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SchemaSummary> schemas() {
        Function<ListSchemasResponse, Iterator> getIterator = response -> {
            if (response != null && response.schemas() != null) {
                return response.schemas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSchemasResponseFetcher
    implements SyncPageFetcher<ListSchemasResponse> {
        private ListSchemasResponseFetcher() {
        }

        public boolean hasNextPage(ListSchemasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSchemasResponse nextPage(ListSchemasResponse previousPage) {
            if (previousPage == null) {
                return ListSchemasIterable.this.client.listSchemas(ListSchemasIterable.this.firstRequest);
            }
            return ListSchemasIterable.this.client.listSchemas((ListSchemasRequest)((Object)ListSchemasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

