/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.schemas.model.SchemaSummary;
import software.amazon.awssdk.services.schemas.model.SchemasResponse;
import software.amazon.awssdk.services.schemas.model.___listOfSchemaSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSchemasResponse
extends SchemasResponse
implements ToCopyableBuilder<Builder, ListSchemasResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSchemasResponse.getter(ListSchemasResponse::nextToken)).setter(ListSchemasResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SchemaSummary>> SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Schemas").getter(ListSchemasResponse.getter(ListSchemasResponse::schemas)).setter(ListSchemasResponse.setter(Builder::schemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEMAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSchemasResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SchemaSummary> schemas;

    private ListSchemasResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.schemas = builder.schemas;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSchemas() {
        return this.schemas != null && !(this.schemas instanceof SdkAutoConstructList);
    }

    public final List<SchemaSummary> schemas() {
        return this.schemas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemas() ? this.schemas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSchemasResponse)) {
            return false;
        }
        ListSchemasResponse other = (ListSchemasResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSchemas() == other.hasSchemas() && Objects.equals(this.schemas(), other.schemas());
    }

    public final String toString() {
        return ToString.builder((String)"ListSchemasResponse").add("NextToken", (Object)this.nextToken()).add("Schemas", this.hasSchemas() ? this.schemas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Schemas": {
                return Optional.ofNullable(clazz.cast(this.schemas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Schemas", SCHEMAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSchemasResponse, T> g) {
        return obj -> g.apply((ListSchemasResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SchemasResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SchemaSummary> schemas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSchemasResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.schemas(model.schemas);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SchemaSummary.Builder> getSchemas() {
            List<SchemaSummary.Builder> result = ___listOfSchemaSummaryCopier.copyToBuilder(this.schemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemas(Collection<SchemaSummary.BuilderImpl> schemas) {
            this.schemas = ___listOfSchemaSummaryCopier.copyFromBuilder(schemas);
        }

        @Override
        public final Builder schemas(Collection<SchemaSummary> schemas) {
            this.schemas = ___listOfSchemaSummaryCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(SchemaSummary ... schemas) {
            this.schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<SchemaSummary.Builder> ... schemas) {
            this.schemas(Stream.of(schemas).map(c -> (SchemaSummary)((SchemaSummary.Builder)SchemaSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSchemasResponse build() {
            return new ListSchemasResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SchemasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSchemasResponse> {
        public Builder nextToken(String var1);

        public Builder schemas(Collection<SchemaSummary> var1);

        public Builder schemas(SchemaSummary ... var1);

        public Builder schemas(Consumer<SchemaSummary.Builder> ... var1);
    }
}

