/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.schemas.SchemasAsyncClient;
import software.amazon.awssdk.services.schemas.SchemasServiceClientConfiguration;
import software.amazon.awssdk.services.schemas.internal.SchemasServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.schemas.model.BadRequestException;
import software.amazon.awssdk.services.schemas.model.ConflictException;
import software.amazon.awssdk.services.schemas.model.CreateDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.CreateDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.CreateRegistryRequest;
import software.amazon.awssdk.services.schemas.model.CreateRegistryResponse;
import software.amazon.awssdk.services.schemas.model.CreateSchemaRequest;
import software.amazon.awssdk.services.schemas.model.CreateSchemaResponse;
import software.amazon.awssdk.services.schemas.model.DeleteDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.DeleteDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.DeleteRegistryRequest;
import software.amazon.awssdk.services.schemas.model.DeleteRegistryResponse;
import software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionRequest;
import software.amazon.awssdk.services.schemas.model.DeleteSchemaVersionResponse;
import software.amazon.awssdk.services.schemas.model.DescribeCodeBindingRequest;
import software.amazon.awssdk.services.schemas.model.DescribeCodeBindingResponse;
import software.amazon.awssdk.services.schemas.model.DescribeDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.DescribeDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.DescribeRegistryRequest;
import software.amazon.awssdk.services.schemas.model.DescribeRegistryResponse;
import software.amazon.awssdk.services.schemas.model.DescribeSchemaRequest;
import software.amazon.awssdk.services.schemas.model.DescribeSchemaResponse;
import software.amazon.awssdk.services.schemas.model.ExportSchemaRequest;
import software.amazon.awssdk.services.schemas.model.ExportSchemaResponse;
import software.amazon.awssdk.services.schemas.model.ForbiddenException;
import software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceRequest;
import software.amazon.awssdk.services.schemas.model.GetCodeBindingSourceResponse;
import software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaRequest;
import software.amazon.awssdk.services.schemas.model.GetDiscoveredSchemaResponse;
import software.amazon.awssdk.services.schemas.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.GoneException;
import software.amazon.awssdk.services.schemas.model.InternalServerErrorException;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersRequest;
import software.amazon.awssdk.services.schemas.model.ListDiscoverersResponse;
import software.amazon.awssdk.services.schemas.model.ListRegistriesRequest;
import software.amazon.awssdk.services.schemas.model.ListRegistriesResponse;
import software.amazon.awssdk.services.schemas.model.ListSchemaVersionsRequest;
import software.amazon.awssdk.services.schemas.model.ListSchemaVersionsResponse;
import software.amazon.awssdk.services.schemas.model.ListSchemasRequest;
import software.amazon.awssdk.services.schemas.model.ListSchemasResponse;
import software.amazon.awssdk.services.schemas.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.schemas.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.schemas.model.NotFoundException;
import software.amazon.awssdk.services.schemas.model.PreconditionFailedException;
import software.amazon.awssdk.services.schemas.model.PutCodeBindingRequest;
import software.amazon.awssdk.services.schemas.model.PutCodeBindingResponse;
import software.amazon.awssdk.services.schemas.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.schemas.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.schemas.model.SchemasException;
import software.amazon.awssdk.services.schemas.model.SearchSchemasRequest;
import software.amazon.awssdk.services.schemas.model.SearchSchemasResponse;
import software.amazon.awssdk.services.schemas.model.ServiceUnavailableException;
import software.amazon.awssdk.services.schemas.model.StartDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.StartDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.StopDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.StopDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.TagResourceRequest;
import software.amazon.awssdk.services.schemas.model.TagResourceResponse;
import software.amazon.awssdk.services.schemas.model.TooManyRequestsException;
import software.amazon.awssdk.services.schemas.model.UnauthorizedException;
import software.amazon.awssdk.services.schemas.model.UntagResourceRequest;
import software.amazon.awssdk.services.schemas.model.UntagResourceResponse;
import software.amazon.awssdk.services.schemas.model.UpdateDiscovererRequest;
import software.amazon.awssdk.services.schemas.model.UpdateDiscovererResponse;
import software.amazon.awssdk.services.schemas.model.UpdateRegistryRequest;
import software.amazon.awssdk.services.schemas.model.UpdateRegistryResponse;
import software.amazon.awssdk.services.schemas.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.schemas.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.schemas.transform.CreateDiscovererRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.CreateRegistryRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.CreateSchemaRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DeleteDiscovererRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DeleteRegistryRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DeleteSchemaRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DeleteSchemaVersionRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DescribeCodeBindingRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DescribeDiscovererRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DescribeRegistryRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.DescribeSchemaRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.ExportSchemaRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.GetCodeBindingSourceRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.GetDiscoveredSchemaRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.ListDiscoverersRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.ListRegistriesRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.ListSchemaVersionsRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.ListSchemasRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.PutCodeBindingRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.SearchSchemasRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.StartDiscovererRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.StopDiscovererRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.UpdateDiscovererRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.UpdateRegistryRequestMarshaller;
import software.amazon.awssdk.services.schemas.transform.UpdateSchemaRequestMarshaller;
import software.amazon.awssdk.services.schemas.waiters.SchemasAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultSchemasAsyncClient
implements SchemasAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSchemasAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultSchemasAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"schemas#2.38.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<CreateDiscovererResponse> createDiscoverer(CreateDiscovererRequest createDiscovererRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDiscovererRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, createDiscovererRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDiscoverer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDiscovererResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDiscoverer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDiscovererRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDiscovererRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$createDiscoverer$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$createDiscoverer$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRegistryResponse> createRegistry(CreateRegistryRequest createRegistryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRegistryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, createRegistryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRegistry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRegistryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRegistry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRegistryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRegistryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$createRegistry$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$createRegistry$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSchemaResponse> createSchema(CreateSchemaRequest createSchemaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, createSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSchemaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSchemaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$createSchema$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$createSchema$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDiscovererResponse> deleteDiscoverer(DeleteDiscovererRequest deleteDiscovererRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDiscovererRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDiscovererRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDiscoverer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDiscovererResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDiscoverer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDiscovererRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDiscovererRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$deleteDiscoverer$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$deleteDiscoverer$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRegistryResponse> deleteRegistry(DeleteRegistryRequest deleteRegistryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRegistryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRegistryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRegistry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRegistryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRegistry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRegistryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRegistryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$deleteRegistry$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$deleteRegistry$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$deleteResourcePolicy$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$deleteResourcePolicy$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSchemaResponse> deleteSchema(DeleteSchemaRequest deleteSchemaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSchemaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSchemaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$deleteSchema$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$deleteSchema$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSchemaVersionResponse> deleteSchemaVersion(DeleteSchemaVersionRequest deleteSchemaVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSchemaVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSchemaVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSchemaVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSchemaVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSchemaVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSchemaVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSchemaVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$deleteSchemaVersion$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$deleteSchemaVersion$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCodeBindingResponse> describeCodeBinding(DescribeCodeBindingRequest describeCodeBindingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCodeBindingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, describeCodeBindingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCodeBinding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCodeBindingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCodeBinding").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCodeBindingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCodeBindingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$describeCodeBinding$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$describeCodeBinding$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDiscovererResponse> describeDiscoverer(DescribeDiscovererRequest describeDiscovererRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDiscovererRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, describeDiscovererRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDiscoverer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDiscovererResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDiscoverer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDiscovererRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDiscovererRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$describeDiscoverer$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$describeDiscoverer$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRegistryResponse> describeRegistry(DescribeRegistryRequest describeRegistryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRegistryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, describeRegistryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRegistry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRegistryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRegistry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRegistryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRegistryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$describeRegistry$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$describeRegistry$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSchemaResponse> describeSchema(DescribeSchemaRequest describeSchemaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, describeSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSchemaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSchemaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$describeSchema$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$describeSchema$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExportSchemaResponse> exportSchema(ExportSchemaRequest exportSchemaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)exportSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, exportSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportSchemaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ExportSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)exportSchemaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$exportSchema$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$exportSchema$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCodeBindingSourceResponse> getCodeBindingSource(GetCodeBindingSourceRequest getCodeBindingSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCodeBindingSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, getCodeBindingSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCodeBindingSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(false).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCodeBindingSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCodeBindingSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCodeBindingSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCodeBindingSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$getCodeBindingSource$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$getCodeBindingSource$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDiscoveredSchemaResponse> getDiscoveredSchema(GetDiscoveredSchemaRequest getDiscoveredSchemaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDiscoveredSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, getDiscoveredSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDiscoveredSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiscoveredSchemaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiscoveredSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDiscoveredSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDiscoveredSchemaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$getDiscoveredSchema$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$getDiscoveredSchema$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$getResourcePolicy$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$getResourcePolicy$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDiscoverersResponse> listDiscoverers(ListDiscoverersRequest listDiscoverersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDiscoverersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, listDiscoverersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDiscoverers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDiscoverersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDiscoverers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDiscoverersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDiscoverersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$listDiscoverers$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$listDiscoverers$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRegistriesResponse> listRegistries(ListRegistriesRequest listRegistriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRegistriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, listRegistriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRegistries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRegistriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRegistries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRegistriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRegistriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$listRegistries$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$listRegistries$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSchemaVersionsResponse> listSchemaVersions(ListSchemaVersionsRequest listSchemaVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSchemaVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, listSchemaVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchemaVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemaVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemaVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSchemaVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSchemaVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$listSchemaVersions$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$listSchemaVersions$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSchemasResponse> listSchemas(ListSchemasRequest listSchemasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSchemasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, listSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchemas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSchemasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$listSchemas$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$listSchemas$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$listTagsForResource$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$listTagsForResource$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutCodeBindingResponse> putCodeBinding(PutCodeBindingRequest putCodeBindingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putCodeBindingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, putCodeBindingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutCodeBinding");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutCodeBindingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutCodeBinding").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutCodeBindingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putCodeBindingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$putCodeBinding$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$putCodeBinding$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$putResourcePolicy$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$putResourcePolicy$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchSchemasResponse> searchSchemas(SearchSchemasRequest searchSchemasRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchSchemasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, searchSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchSchemas");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchSchemasResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchSchemas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchSchemasRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$searchSchemas$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$searchSchemas$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDiscovererResponse> startDiscoverer(StartDiscovererRequest startDiscovererRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDiscovererRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, startDiscovererRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDiscoverer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDiscovererResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDiscoverer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartDiscovererRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startDiscovererRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$startDiscoverer$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$startDiscoverer$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopDiscovererResponse> stopDiscoverer(StopDiscovererRequest stopDiscovererRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopDiscovererRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, stopDiscovererRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDiscoverer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDiscovererResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDiscoverer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopDiscovererRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopDiscovererRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$stopDiscoverer$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$stopDiscoverer$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$tagResource$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$tagResource$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$untagResource$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$untagResource$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDiscovererResponse> updateDiscoverer(UpdateDiscovererRequest updateDiscovererRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDiscovererRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, updateDiscovererRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDiscoverer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDiscovererResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDiscoverer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDiscovererRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDiscovererRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$updateDiscoverer$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$updateDiscoverer$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRegistryResponse> updateRegistry(UpdateRegistryRequest updateRegistryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRegistryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, updateRegistryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRegistry");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRegistryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRegistry").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRegistryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRegistryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$updateRegistry$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$updateRegistry$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSchemaResponse> updateSchema(UpdateSchemaRequest updateSchemaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSchemasAsyncClient.resolveMetricPublishers(clientConfiguration, updateSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"schemas");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSchemaResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GoneException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GoneException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(GoneException::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "UnauthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(UnauthorizedException::builder).build());
                    }
                    case "PreconditionFailedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("PreconditionFailedException").httpStatusCode(Integer.valueOf(412)).exceptionBuilderSupplier(PreconditionFailedException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSchemaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultSchemasAsyncClient.lambda$updateSchema$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultSchemasAsyncClient.lambda$updateSchema$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public SchemasAsyncWaiter waiter() {
        return SchemasAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final SchemasServiceClientConfiguration serviceClientConfiguration() {
        return new SchemasServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "schemas";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SchemasException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SchemasServiceClientConfigurationBuilder serviceConfigBuilder = new SchemasServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateSchema$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSchema$122(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRegistry$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRegistry$118(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRegistryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDiscoverer$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDiscoverer$114(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDiscovererResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$110(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$106(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopDiscoverer$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDiscoverer$102(List metricPublishers, MetricCollector apiCallMetricCollector, StopDiscovererResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startDiscoverer$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDiscoverer$98(List metricPublishers, MetricCollector apiCallMetricCollector, StartDiscovererResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchSchemas$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchSchemas$94(List metricPublishers, MetricCollector apiCallMetricCollector, SearchSchemasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putResourcePolicy$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$90(List metricPublishers, MetricCollector apiCallMetricCollector, PutResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putCodeBinding$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putCodeBinding$86(List metricPublishers, MetricCollector apiCallMetricCollector, PutCodeBindingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$82(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSchemas$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSchemas$78(List metricPublishers, MetricCollector apiCallMetricCollector, ListSchemasResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSchemaVersions$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSchemaVersions$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListSchemaVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRegistries$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRegistries$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListRegistriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDiscoverers$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDiscoverers$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListDiscoverersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResourcePolicy$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResourcePolicy$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDiscoveredSchema$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDiscoveredSchema$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetDiscoveredSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCodeBindingSource$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCodeBindingSource$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetCodeBindingSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$exportSchema$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportSchema$50(List metricPublishers, MetricCollector apiCallMetricCollector, ExportSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSchema$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSchema$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRegistry$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRegistry$42(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRegistryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDiscoverer$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDiscoverer$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDiscovererResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCodeBinding$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCodeBinding$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCodeBindingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSchemaVersion$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSchemaVersion$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSchemaVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSchema$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSchema$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRegistry$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRegistry$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRegistryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDiscoverer$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDiscoverer$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDiscovererResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSchema$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSchema$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRegistry$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRegistry$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRegistryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDiscoverer$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDiscoverer$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDiscovererResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

