/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteSecretRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<DeleteSecretRequest.Builder, DeleteSecretRequest> {
    private final String secretId;

    private final Long recoveryWindowInDays;

    private DeleteSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.recoveryWindowInDays = builder.recoveryWindowInDays;
    }

    /**
     * <p>
     * Specifies the secret that you want to delete. You can specify either the Amazon Resource Name (ARN) or the
     * friendly name of the secret.
     * </p>
     * 
     * @return Specifies the secret that you want to delete. You can specify either the Amazon Resource Name (ARN) or
     *         the friendly name of the secret.
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * (Optional) Specifies the number of days that Secrets Manager waits before it can delete the secret.
     * </p>
     * <p>
     * This value can range from 7 to 30 days. The default value is 30.
     * </p>
     * 
     * @return (Optional) Specifies the number of days that Secrets Manager waits before it can delete the secret.</p>
     *         <p>
     *         This value can range from 7 to 30 days. The default value is 30.
     */
    public Long recoveryWindowInDays() {
        return recoveryWindowInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryWindowInDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSecretRequest)) {
            return false;
        }
        DeleteSecretRequest other = (DeleteSecretRequest) obj;
        return Objects.equals(secretId(), other.secretId())
                && Objects.equals(recoveryWindowInDays(), other.recoveryWindowInDays());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteSecretRequest").add("SecretId", secretId())
                .add("RecoveryWindowInDays", recoveryWindowInDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.of(clazz.cast(secretId()));
        case "RecoveryWindowInDays":
            return Optional.of(clazz.cast(recoveryWindowInDays()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, DeleteSecretRequest> {
        /**
         * <p>
         * Specifies the secret that you want to delete. You can specify either the Amazon Resource Name (ARN) or the
         * friendly name of the secret.
         * </p>
         * 
         * @param secretId
         *        Specifies the secret that you want to delete. You can specify either the Amazon Resource Name (ARN) or
         *        the friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * (Optional) Specifies the number of days that Secrets Manager waits before it can delete the secret.
         * </p>
         * <p>
         * This value can range from 7 to 30 days. The default value is 30.
         * </p>
         * 
         * @param recoveryWindowInDays
         *        (Optional) Specifies the number of days that Secrets Manager waits before it can delete the
         *        secret.</p>
         *        <p>
         *        This value can range from 7 to 30 days. The default value is 30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryWindowInDays(Long recoveryWindowInDays);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private Long recoveryWindowInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSecretRequest model) {
            super(model);
            secretId(model.secretId);
            recoveryWindowInDays(model.recoveryWindowInDays);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final Long getRecoveryWindowInDays() {
            return recoveryWindowInDays;
        }

        @Override
        public final Builder recoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
            return this;
        }

        public final void setRecoveryWindowInDays(Long recoveryWindowInDays) {
            this.recoveryWindowInDays = recoveryWindowInDays;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteSecretRequest build() {
            return new DeleteSecretRequest(this);
        }
    }
}
