/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSecretRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<DescribeSecretRequest.Builder, DescribeSecretRequest> {
    private final String secretId;

    private DescribeSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
    }

    /**
     * <p>
     * The identifier of the secret whose details you want to retrieve. You can specify either the Amazon Resource Name
     * (ARN) or the friendly name of the secret.
     * </p>
     * 
     * @return The identifier of the secret whose details you want to retrieve. You can specify either the Amazon
     *         Resource Name (ARN) or the friendly name of the secret.
     */
    public String secretId() {
        return secretId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecretRequest)) {
            return false;
        }
        DescribeSecretRequest other = (DescribeSecretRequest) obj;
        return Objects.equals(secretId(), other.secretId());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSecretRequest").add("SecretId", secretId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.of(clazz.cast(secretId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, DescribeSecretRequest> {
        /**
         * <p>
         * The identifier of the secret whose details you want to retrieve. You can specify either the Amazon Resource
         * Name (ARN) or the friendly name of the secret.
         * </p>
         * 
         * @param secretId
         *        The identifier of the secret whose details you want to retrieve. You can specify either the Amazon
         *        Resource Name (ARN) or the friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecretRequest model) {
            super(model);
            secretId(model.secretId);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeSecretRequest build() {
            return new DescribeSecretRequest(this);
        }
    }
}
