/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSecretResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<DescribeSecretResponse.Builder, DescribeSecretResponse> {
    private final String arn;

    private final String name;

    private final String description;

    private final String kmsKeyId;

    private final Boolean rotationEnabled;

    private final String rotationLambdaARN;

    private final RotationRulesType rotationRules;

    private final Instant lastRotatedDate;

    private final Instant lastChangedDate;

    private final Instant lastAccessedDate;

    private final Instant deletedDate;

    private final List<Tag> tags;

    private final Map<String, List<String>> versionIdsToStages;

    private DescribeSecretResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.rotationEnabled = builder.rotationEnabled;
        this.rotationLambdaARN = builder.rotationLambdaARN;
        this.rotationRules = builder.rotationRules;
        this.lastRotatedDate = builder.lastRotatedDate;
        this.lastChangedDate = builder.lastChangedDate;
        this.lastAccessedDate = builder.lastAccessedDate;
        this.deletedDate = builder.deletedDate;
        this.tags = builder.tags;
        this.versionIdsToStages = builder.versionIdsToStages;
    }

    /**
     * <p>
     * The ARN of the secret.
     * </p>
     * 
     * @return The ARN of the secret.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The user-provided friendly name of the secret.
     * </p>
     * 
     * @return The user-provided friendly name of the secret.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The user-provided description of the secret.
     * </p>
     * 
     * @return The user-provided description of the secret.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ARN or alias of the AWS KMS customer master key (CMK) that's used to encrypt the <code>SecretString</code> or
     * <code>SecretBinary</code> fields in each version of the secret. If you don't provide a key, then Secrets Manager
     * defaults to encrypting the secret fields with the default KMS CMK (the one named <code>awssecretsmanager</code>)
     * for this account.
     * </p>
     * 
     * @return The ARN or alias of the AWS KMS customer master key (CMK) that's used to encrypt the
     *         <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret. If you don't
     *         provide a key, then Secrets Manager defaults to encrypting the secret fields with the default KMS CMK
     *         (the one named <code>awssecretsmanager</code>) for this account.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether automatic rotation is enabled for this secret.
     * </p>
     * <p>
     * To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a value greater
     * than 0. To disable rotation, use <a>CancelRotateSecret</a>.
     * </p>
     * 
     * @return Specifies whether automatic rotation is enabled for this secret.</p>
     *         <p>
     *         To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a value
     *         greater than 0. To disable rotation, use <a>CancelRotateSecret</a>.
     */
    public Boolean rotationEnabled() {
        return rotationEnabled;
    }

    /**
     * <p>
     * The ARN of a Lambda function that's invoked by Secrets Manager to rotate the secret either automatically per the
     * schedule or manually by a call to <code>RotateSecret</code>.
     * </p>
     * 
     * @return The ARN of a Lambda function that's invoked by Secrets Manager to rotate the secret either automatically
     *         per the schedule or manually by a call to <code>RotateSecret</code>.
     */
    public String rotationLambdaARN() {
        return rotationLambdaARN;
    }

    /**
     * <p>
     * A structure that contains the rotation configuration for this secret.
     * </p>
     * 
     * @return A structure that contains the rotation configuration for this secret.
     */
    public RotationRulesType rotationRules() {
        return rotationRules;
    }

    /**
     * <p>
     * The last date and time that the Secrets Manager rotation process for this secret was invoked.
     * </p>
     * 
     * @return The last date and time that the Secrets Manager rotation process for this secret was invoked.
     */
    public Instant lastRotatedDate() {
        return lastRotatedDate;
    }

    /**
     * <p>
     * The last date and time that this secret was modified in any way.
     * </p>
     * 
     * @return The last date and time that this secret was modified in any way.
     */
    public Instant lastChangedDate() {
        return lastChangedDate;
    }

    /**
     * <p>
     * The last date that this secret was accessed. This value is truncated to midnight of the date and therefore shows
     * only the date, not the time.
     * </p>
     * 
     * @return The last date that this secret was accessed. This value is truncated to midnight of the date and
     *         therefore shows only the date, not the time.
     */
    public Instant lastAccessedDate() {
        return lastAccessedDate;
    }

    /**
     * <p>
     * This value exists if the secret is scheduled for deletion. Some time after the specified date and time, Secrets
     * Manager deletes the secret and all of its versions.
     * </p>
     * <p>
     * If a secret is scheduled for deletion, then its details, including the encrypted secret information, is not
     * accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.
     * </p>
     * 
     * @return This value exists if the secret is scheduled for deletion. Some time after the specified date and time,
     *         Secrets Manager deletes the secret and all of its versions.</p>
     *         <p>
     *         If a secret is scheduled for deletion, then its details, including the encrypted secret information, is
     *         not accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.
     */
    public Instant deletedDate() {
        return deletedDate;
    }

    /**
     * <p>
     * The list of user-defined tags that are associated with the secret. To add tags to a secret, use
     * <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of user-defined tags that are associated with the secret. To add tags to a secret, use
     *         <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A list of all of the currently assigned <code>VersionStage</code> staging labels and the
     * <code>SecretVersionId</code> that each is attached to. Staging labels are used to keep track of the different
     * versions during the rotation process.
     * </p>
     * <note>
     * <p>
     * A version that does not have any staging labels attached is considered deprecated and subject to deletion. Such
     * versions are not included in this list.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of all of the currently assigned <code>VersionStage</code> staging labels and the
     *         <code>SecretVersionId</code> that each is attached to. Staging labels are used to keep track of the
     *         different versions during the rotation process.</p> <note>
     *         <p>
     *         A version that does not have any staging labels attached is considered deprecated and subject to
     *         deletion. Such versions are not included in this list.
     *         </p>
     */
    public Map<String, List<String>> versionIdsToStages() {
        return versionIdsToStages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(rotationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(rotationLambdaARN());
        hashCode = 31 * hashCode + Objects.hashCode(rotationRules());
        hashCode = 31 * hashCode + Objects.hashCode(lastRotatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastChangedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessedDate());
        hashCode = 31 * hashCode + Objects.hashCode(deletedDate());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(versionIdsToStages());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecretResponse)) {
            return false;
        }
        DescribeSecretResponse other = (DescribeSecretResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(rotationEnabled(), other.rotationEnabled())
                && Objects.equals(rotationLambdaARN(), other.rotationLambdaARN())
                && Objects.equals(rotationRules(), other.rotationRules())
                && Objects.equals(lastRotatedDate(), other.lastRotatedDate())
                && Objects.equals(lastChangedDate(), other.lastChangedDate())
                && Objects.equals(lastAccessedDate(), other.lastAccessedDate())
                && Objects.equals(deletedDate(), other.deletedDate()) && Objects.equals(tags(), other.tags())
                && Objects.equals(versionIdsToStages(), other.versionIdsToStages());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSecretResponse").add("ARN", arn()).add("Name", name()).add("Description", description())
                .add("KmsKeyId", kmsKeyId()).add("RotationEnabled", rotationEnabled())
                .add("RotationLambdaARN", rotationLambdaARN()).add("RotationRules", rotationRules())
                .add("LastRotatedDate", lastRotatedDate()).add("LastChangedDate", lastChangedDate())
                .add("LastAccessedDate", lastAccessedDate()).add("DeletedDate", deletedDate()).add("Tags", tags())
                .add("VersionIdsToStages", versionIdsToStages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.of(clazz.cast(arn()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "KmsKeyId":
            return Optional.of(clazz.cast(kmsKeyId()));
        case "RotationEnabled":
            return Optional.of(clazz.cast(rotationEnabled()));
        case "RotationLambdaARN":
            return Optional.of(clazz.cast(rotationLambdaARN()));
        case "RotationRules":
            return Optional.of(clazz.cast(rotationRules()));
        case "LastRotatedDate":
            return Optional.of(clazz.cast(lastRotatedDate()));
        case "LastChangedDate":
            return Optional.of(clazz.cast(lastChangedDate()));
        case "LastAccessedDate":
            return Optional.of(clazz.cast(lastAccessedDate()));
        case "DeletedDate":
            return Optional.of(clazz.cast(deletedDate()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "VersionIdsToStages":
            return Optional.of(clazz.cast(versionIdsToStages()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerResponse.Builder, CopyableBuilder<Builder, DescribeSecretResponse> {
        /**
         * <p>
         * The ARN of the secret.
         * </p>
         * 
         * @param arn
         *        The ARN of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The user-provided friendly name of the secret.
         * </p>
         * 
         * @param name
         *        The user-provided friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The user-provided description of the secret.
         * </p>
         * 
         * @param description
         *        The user-provided description of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN or alias of the AWS KMS customer master key (CMK) that's used to encrypt the
         * <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret. If you don't
         * provide a key, then Secrets Manager defaults to encrypting the secret fields with the default KMS CMK (the
         * one named <code>awssecretsmanager</code>) for this account.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN or alias of the AWS KMS customer master key (CMK) that's used to encrypt the
         *        <code>SecretString</code> or <code>SecretBinary</code> fields in each version of the secret. If you
         *        don't provide a key, then Secrets Manager defaults to encrypting the secret fields with the default
         *        KMS CMK (the one named <code>awssecretsmanager</code>) for this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether automatic rotation is enabled for this secret.
         * </p>
         * <p>
         * To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a value
         * greater than 0. To disable rotation, use <a>CancelRotateSecret</a>.
         * </p>
         * 
         * @param rotationEnabled
         *        Specifies whether automatic rotation is enabled for this secret.</p>
         *        <p>
         *        To enable rotation, use <a>RotateSecret</a> with <code>AutomaticallyRotateAfterDays</code> set to a
         *        value greater than 0. To disable rotation, use <a>CancelRotateSecret</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationEnabled(Boolean rotationEnabled);

        /**
         * <p>
         * The ARN of a Lambda function that's invoked by Secrets Manager to rotate the secret either automatically per
         * the schedule or manually by a call to <code>RotateSecret</code>.
         * </p>
         * 
         * @param rotationLambdaARN
         *        The ARN of a Lambda function that's invoked by Secrets Manager to rotate the secret either
         *        automatically per the schedule or manually by a call to <code>RotateSecret</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationLambdaARN(String rotationLambdaARN);

        /**
         * <p>
         * A structure that contains the rotation configuration for this secret.
         * </p>
         * 
         * @param rotationRules
         *        A structure that contains the rotation configuration for this secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationRules(RotationRulesType rotationRules);

        /**
         * <p>
         * A structure that contains the rotation configuration for this secret.
         * </p>
         * This is a convenience that creates an instance of the {@link RotationRulesType.Builder} avoiding the need to
         * create one manually via {@link RotationRulesType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RotationRulesType.Builder#build()} is called immediately and its
         * result is passed to {@link #rotationRules(RotationRulesType)}.
         * 
         * @param rotationRules
         *        a consumer that will call methods on {@link RotationRulesType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rotationRules(RotationRulesType)
         */
        default Builder rotationRules(Consumer<RotationRulesType.Builder> rotationRules) {
            return rotationRules(RotationRulesType.builder().apply(rotationRules).build());
        }

        /**
         * <p>
         * The last date and time that the Secrets Manager rotation process for this secret was invoked.
         * </p>
         * 
         * @param lastRotatedDate
         *        The last date and time that the Secrets Manager rotation process for this secret was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRotatedDate(Instant lastRotatedDate);

        /**
         * <p>
         * The last date and time that this secret was modified in any way.
         * </p>
         * 
         * @param lastChangedDate
         *        The last date and time that this secret was modified in any way.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastChangedDate(Instant lastChangedDate);

        /**
         * <p>
         * The last date that this secret was accessed. This value is truncated to midnight of the date and therefore
         * shows only the date, not the time.
         * </p>
         * 
         * @param lastAccessedDate
         *        The last date that this secret was accessed. This value is truncated to midnight of the date and
         *        therefore shows only the date, not the time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessedDate(Instant lastAccessedDate);

        /**
         * <p>
         * This value exists if the secret is scheduled for deletion. Some time after the specified date and time,
         * Secrets Manager deletes the secret and all of its versions.
         * </p>
         * <p>
         * If a secret is scheduled for deletion, then its details, including the encrypted secret information, is not
         * accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.
         * </p>
         * 
         * @param deletedDate
         *        This value exists if the secret is scheduled for deletion. Some time after the specified date and
         *        time, Secrets Manager deletes the secret and all of its versions.</p>
         *        <p>
         *        If a secret is scheduled for deletion, then its details, including the encrypted secret information,
         *        is not accessible. To cancel a scheduled deletion and restore access, use <a>RestoreSecret</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedDate(Instant deletedDate);

        /**
         * <p>
         * The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         * <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * </p>
         * 
         * @param tags
         *        The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         *        <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         * <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * </p>
         * 
         * @param tags
         *        The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         *        <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of user-defined tags that are associated with the secret. To add tags to a secret, use
         * <a>TagResource</a>. To remove tags, use <a>UntagResource</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A list of all of the currently assigned <code>VersionStage</code> staging labels and the
         * <code>SecretVersionId</code> that each is attached to. Staging labels are used to keep track of the different
         * versions during the rotation process.
         * </p>
         * <note>
         * <p>
         * A version that does not have any staging labels attached is considered deprecated and subject to deletion.
         * Such versions are not included in this list.
         * </p>
         * </note>
         * 
         * @param versionIdsToStages
         *        A list of all of the currently assigned <code>VersionStage</code> staging labels and the
         *        <code>SecretVersionId</code> that each is attached to. Staging labels are used to keep track of the
         *        different versions during the rotation process.</p> <note>
         *        <p>
         *        A version that does not have any staging labels attached is considered deprecated and subject to
         *        deletion. Such versions are not included in this list.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String description;

        private String kmsKeyId;

        private Boolean rotationEnabled;

        private String rotationLambdaARN;

        private RotationRulesType rotationRules;

        private Instant lastRotatedDate;

        private Instant lastChangedDate;

        private Instant lastAccessedDate;

        private Instant deletedDate;

        private List<Tag> tags;

        private Map<String, List<String>> versionIdsToStages;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecretResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            description(model.description);
            kmsKeyId(model.kmsKeyId);
            rotationEnabled(model.rotationEnabled);
            rotationLambdaARN(model.rotationLambdaARN);
            rotationRules(model.rotationRules);
            lastRotatedDate(model.lastRotatedDate);
            lastChangedDate(model.lastChangedDate);
            lastAccessedDate(model.lastAccessedDate);
            deletedDate(model.deletedDate);
            tags(model.tags);
            versionIdsToStages(model.versionIdsToStages);
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getRotationEnabled() {
            return rotationEnabled;
        }

        @Override
        public final Builder rotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
            return this;
        }

        public final void setRotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
        }

        public final String getRotationLambdaARN() {
            return rotationLambdaARN;
        }

        @Override
        public final Builder rotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
            return this;
        }

        public final void setRotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
        }

        public final RotationRulesType.Builder getRotationRules() {
            return rotationRules != null ? rotationRules.toBuilder() : null;
        }

        @Override
        public final Builder rotationRules(RotationRulesType rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        public final void setRotationRules(RotationRulesType.BuilderImpl rotationRules) {
            this.rotationRules = rotationRules != null ? rotationRules.build() : null;
        }

        public final Instant getLastRotatedDate() {
            return lastRotatedDate;
        }

        @Override
        public final Builder lastRotatedDate(Instant lastRotatedDate) {
            this.lastRotatedDate = lastRotatedDate;
            return this;
        }

        public final void setLastRotatedDate(Instant lastRotatedDate) {
            this.lastRotatedDate = lastRotatedDate;
        }

        public final Instant getLastChangedDate() {
            return lastChangedDate;
        }

        @Override
        public final Builder lastChangedDate(Instant lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
            return this;
        }

        public final void setLastChangedDate(Instant lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
        }

        public final Instant getLastAccessedDate() {
            return lastAccessedDate;
        }

        @Override
        public final Builder lastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
            return this;
        }

        public final void setLastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
        }

        public final Instant getDeletedDate() {
            return deletedDate;
        }

        @Override
        public final Builder deletedDate(Instant deletedDate) {
            this.deletedDate = deletedDate;
            return this;
        }

        public final void setDeletedDate(Instant deletedDate) {
            this.deletedDate = deletedDate;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListTypeCopier.copyFromBuilder(tags);
        }

        public final Map<String, ? extends Collection<String>> getVersionIdsToStages() {
            return versionIdsToStages;
        }

        @Override
        public final Builder versionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages) {
            this.versionIdsToStages = SecretVersionsToStagesMapTypeCopier.copy(versionIdsToStages);
            return this;
        }

        public final void setVersionIdsToStages(Map<String, ? extends Collection<String>> versionIdsToStages) {
            this.versionIdsToStages = SecretVersionsToStagesMapTypeCopier.copy(versionIdsToStages);
        }

        @Override
        public DescribeSecretResponse build() {
            return new DescribeSecretResponse(this);
        }
    }
}
