/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetRandomPasswordRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<GetRandomPasswordRequest.Builder, GetRandomPasswordRequest> {
    private final Long passwordLength;

    private final String excludeCharacters;

    private final Boolean excludeNumbers;

    private final Boolean excludePunctuation;

    private final Boolean excludeUppercase;

    private final Boolean excludeLowercase;

    private final Boolean includeSpace;

    private final Boolean requireEachIncludedType;

    private GetRandomPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.passwordLength = builder.passwordLength;
        this.excludeCharacters = builder.excludeCharacters;
        this.excludeNumbers = builder.excludeNumbers;
        this.excludePunctuation = builder.excludePunctuation;
        this.excludeUppercase = builder.excludeUppercase;
        this.excludeLowercase = builder.excludeLowercase;
        this.includeSpace = builder.includeSpace;
        this.requireEachIncludedType = builder.requireEachIncludedType;
    }

    /**
     * <p>
     * The desired length of the generated password. The default value if you do not include this parameter is 32
     * characters.
     * </p>
     * 
     * @return The desired length of the generated password. The default value if you do not include this parameter is
     *         32 characters.
     */
    public Long passwordLength() {
        return passwordLength;
    }

    /**
     * <p>
     * A string that includes characters that should not be included in the generated password. The default is that all
     * characters from the included sets can be used.
     * </p>
     * 
     * @return A string that includes characters that should not be included in the generated password. The default is
     *         that all characters from the included sets can be used.
     */
    public String excludeCharacters() {
        return excludeCharacters;
    }

    /**
     * <p>
     * Specifies that the generated password should not include digits. The default if you do not include this switch
     * parameter is that digits can be included.
     * </p>
     * 
     * @return Specifies that the generated password should not include digits. The default if you do not include this
     *         switch parameter is that digits can be included.
     */
    public Boolean excludeNumbers() {
        return excludeNumbers;
    }

    /**
     * <p>
     * Specifies that the generated password should not include punctuation characters. The default if you do not
     * include this switch parameter is that punctuation characters can be included.
     * </p>
     * 
     * @return Specifies that the generated password should not include punctuation characters. The default if you do
     *         not include this switch parameter is that punctuation characters can be included.
     */
    public Boolean excludePunctuation() {
        return excludePunctuation;
    }

    /**
     * <p>
     * Specifies that the generated password should not include uppercase letters. The default if you do not include
     * this switch parameter is that uppercase letters can be included.
     * </p>
     * 
     * @return Specifies that the generated password should not include uppercase letters. The default if you do not
     *         include this switch parameter is that uppercase letters can be included.
     */
    public Boolean excludeUppercase() {
        return excludeUppercase;
    }

    /**
     * <p>
     * Specifies that the generated password should not include lowercase letters. The default if you do not include
     * this switch parameter is that lowercase letters can be included.
     * </p>
     * 
     * @return Specifies that the generated password should not include lowercase letters. The default if you do not
     *         include this switch parameter is that lowercase letters can be included.
     */
    public Boolean excludeLowercase() {
        return excludeLowercase;
    }

    /**
     * <p>
     * Specifies that the generated password can include the space character. The default if you do not include this
     * switch parameter is that the space character is not included.
     * </p>
     * 
     * @return Specifies that the generated password can include the space character. The default if you do not include
     *         this switch parameter is that the space character is not included.
     */
    public Boolean includeSpace() {
        return includeSpace;
    }

    /**
     * <p>
     * A boolean value that specifies whether the generated password must include at least one of every allowed
     * character type. The default value is <code>True</code> and the operation requires at least one of every character
     * type.
     * </p>
     * 
     * @return A boolean value that specifies whether the generated password must include at least one of every allowed
     *         character type. The default value is <code>True</code> and the operation requires at least one of every
     *         character type.
     */
    public Boolean requireEachIncludedType() {
        return requireEachIncludedType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(passwordLength());
        hashCode = 31 * hashCode + Objects.hashCode(excludeCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(excludeNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(excludePunctuation());
        hashCode = 31 * hashCode + Objects.hashCode(excludeUppercase());
        hashCode = 31 * hashCode + Objects.hashCode(excludeLowercase());
        hashCode = 31 * hashCode + Objects.hashCode(includeSpace());
        hashCode = 31 * hashCode + Objects.hashCode(requireEachIncludedType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRandomPasswordRequest)) {
            return false;
        }
        GetRandomPasswordRequest other = (GetRandomPasswordRequest) obj;
        return Objects.equals(passwordLength(), other.passwordLength())
                && Objects.equals(excludeCharacters(), other.excludeCharacters())
                && Objects.equals(excludeNumbers(), other.excludeNumbers())
                && Objects.equals(excludePunctuation(), other.excludePunctuation())
                && Objects.equals(excludeUppercase(), other.excludeUppercase())
                && Objects.equals(excludeLowercase(), other.excludeLowercase())
                && Objects.equals(includeSpace(), other.includeSpace())
                && Objects.equals(requireEachIncludedType(), other.requireEachIncludedType());
    }

    @Override
    public String toString() {
        return ToString.builder("GetRandomPasswordRequest").add("PasswordLength", passwordLength())
                .add("ExcludeCharacters", excludeCharacters()).add("ExcludeNumbers", excludeNumbers())
                .add("ExcludePunctuation", excludePunctuation()).add("ExcludeUppercase", excludeUppercase())
                .add("ExcludeLowercase", excludeLowercase()).add("IncludeSpace", includeSpace())
                .add("RequireEachIncludedType", requireEachIncludedType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PasswordLength":
            return Optional.of(clazz.cast(passwordLength()));
        case "ExcludeCharacters":
            return Optional.of(clazz.cast(excludeCharacters()));
        case "ExcludeNumbers":
            return Optional.of(clazz.cast(excludeNumbers()));
        case "ExcludePunctuation":
            return Optional.of(clazz.cast(excludePunctuation()));
        case "ExcludeUppercase":
            return Optional.of(clazz.cast(excludeUppercase()));
        case "ExcludeLowercase":
            return Optional.of(clazz.cast(excludeLowercase()));
        case "IncludeSpace":
            return Optional.of(clazz.cast(includeSpace()));
        case "RequireEachIncludedType":
            return Optional.of(clazz.cast(requireEachIncludedType()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, GetRandomPasswordRequest> {
        /**
         * <p>
         * The desired length of the generated password. The default value if you do not include this parameter is 32
         * characters.
         * </p>
         * 
         * @param passwordLength
         *        The desired length of the generated password. The default value if you do not include this parameter
         *        is 32 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordLength(Long passwordLength);

        /**
         * <p>
         * A string that includes characters that should not be included in the generated password. The default is that
         * all characters from the included sets can be used.
         * </p>
         * 
         * @param excludeCharacters
         *        A string that includes characters that should not be included in the generated password. The default
         *        is that all characters from the included sets can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeCharacters(String excludeCharacters);

        /**
         * <p>
         * Specifies that the generated password should not include digits. The default if you do not include this
         * switch parameter is that digits can be included.
         * </p>
         * 
         * @param excludeNumbers
         *        Specifies that the generated password should not include digits. The default if you do not include
         *        this switch parameter is that digits can be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeNumbers(Boolean excludeNumbers);

        /**
         * <p>
         * Specifies that the generated password should not include punctuation characters. The default if you do not
         * include this switch parameter is that punctuation characters can be included.
         * </p>
         * 
         * @param excludePunctuation
         *        Specifies that the generated password should not include punctuation characters. The default if you do
         *        not include this switch parameter is that punctuation characters can be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludePunctuation(Boolean excludePunctuation);

        /**
         * <p>
         * Specifies that the generated password should not include uppercase letters. The default if you do not include
         * this switch parameter is that uppercase letters can be included.
         * </p>
         * 
         * @param excludeUppercase
         *        Specifies that the generated password should not include uppercase letters. The default if you do not
         *        include this switch parameter is that uppercase letters can be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeUppercase(Boolean excludeUppercase);

        /**
         * <p>
         * Specifies that the generated password should not include lowercase letters. The default if you do not include
         * this switch parameter is that lowercase letters can be included.
         * </p>
         * 
         * @param excludeLowercase
         *        Specifies that the generated password should not include lowercase letters. The default if you do not
         *        include this switch parameter is that lowercase letters can be included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeLowercase(Boolean excludeLowercase);

        /**
         * <p>
         * Specifies that the generated password can include the space character. The default if you do not include this
         * switch parameter is that the space character is not included.
         * </p>
         * 
         * @param includeSpace
         *        Specifies that the generated password can include the space character. The default if you do not
         *        include this switch parameter is that the space character is not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSpace(Boolean includeSpace);

        /**
         * <p>
         * A boolean value that specifies whether the generated password must include at least one of every allowed
         * character type. The default value is <code>True</code> and the operation requires at least one of every
         * character type.
         * </p>
         * 
         * @param requireEachIncludedType
         *        A boolean value that specifies whether the generated password must include at least one of every
         *        allowed character type. The default value is <code>True</code> and the operation requires at least one
         *        of every character type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireEachIncludedType(Boolean requireEachIncludedType);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private Long passwordLength;

        private String excludeCharacters;

        private Boolean excludeNumbers;

        private Boolean excludePunctuation;

        private Boolean excludeUppercase;

        private Boolean excludeLowercase;

        private Boolean includeSpace;

        private Boolean requireEachIncludedType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRandomPasswordRequest model) {
            super(model);
            passwordLength(model.passwordLength);
            excludeCharacters(model.excludeCharacters);
            excludeNumbers(model.excludeNumbers);
            excludePunctuation(model.excludePunctuation);
            excludeUppercase(model.excludeUppercase);
            excludeLowercase(model.excludeLowercase);
            includeSpace(model.includeSpace);
            requireEachIncludedType(model.requireEachIncludedType);
        }

        public final Long getPasswordLength() {
            return passwordLength;
        }

        @Override
        public final Builder passwordLength(Long passwordLength) {
            this.passwordLength = passwordLength;
            return this;
        }

        public final void setPasswordLength(Long passwordLength) {
            this.passwordLength = passwordLength;
        }

        public final String getExcludeCharacters() {
            return excludeCharacters;
        }

        @Override
        public final Builder excludeCharacters(String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        public final void setExcludeCharacters(String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
        }

        public final Boolean getExcludeNumbers() {
            return excludeNumbers;
        }

        @Override
        public final Builder excludeNumbers(Boolean excludeNumbers) {
            this.excludeNumbers = excludeNumbers;
            return this;
        }

        public final void setExcludeNumbers(Boolean excludeNumbers) {
            this.excludeNumbers = excludeNumbers;
        }

        public final Boolean getExcludePunctuation() {
            return excludePunctuation;
        }

        @Override
        public final Builder excludePunctuation(Boolean excludePunctuation) {
            this.excludePunctuation = excludePunctuation;
            return this;
        }

        public final void setExcludePunctuation(Boolean excludePunctuation) {
            this.excludePunctuation = excludePunctuation;
        }

        public final Boolean getExcludeUppercase() {
            return excludeUppercase;
        }

        @Override
        public final Builder excludeUppercase(Boolean excludeUppercase) {
            this.excludeUppercase = excludeUppercase;
            return this;
        }

        public final void setExcludeUppercase(Boolean excludeUppercase) {
            this.excludeUppercase = excludeUppercase;
        }

        public final Boolean getExcludeLowercase() {
            return excludeLowercase;
        }

        @Override
        public final Builder excludeLowercase(Boolean excludeLowercase) {
            this.excludeLowercase = excludeLowercase;
            return this;
        }

        public final void setExcludeLowercase(Boolean excludeLowercase) {
            this.excludeLowercase = excludeLowercase;
        }

        public final Boolean getIncludeSpace() {
            return includeSpace;
        }

        @Override
        public final Builder includeSpace(Boolean includeSpace) {
            this.includeSpace = includeSpace;
            return this;
        }

        public final void setIncludeSpace(Boolean includeSpace) {
            this.includeSpace = includeSpace;
        }

        public final Boolean getRequireEachIncludedType() {
            return requireEachIncludedType;
        }

        @Override
        public final Builder requireEachIncludedType(Boolean requireEachIncludedType) {
            this.requireEachIncludedType = requireEachIncludedType;
            return this;
        }

        public final void setRequireEachIncludedType(Boolean requireEachIncludedType) {
            this.requireEachIncludedType = requireEachIncludedType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetRandomPasswordRequest build() {
            return new GetRandomPasswordRequest(this);
        }
    }
}
