/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSecretValueRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<GetSecretValueRequest.Builder, GetSecretValueRequest> {
    private final String secretId;

    private final String versionId;

    private final String versionStage;

    private GetSecretValueRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.versionId = builder.versionId;
        this.versionStage = builder.versionStage;
    }

    /**
     * <p>
     * Specifies the secret containing the version that you want to retrieve. You can specify either the Amazon Resource
     * Name (ARN) or the friendly name of the secret.
     * </p>
     * 
     * @return Specifies the secret containing the version that you want to retrieve. You can specify either the Amazon
     *         Resource Name (ARN) or the friendly name of the secret.
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * Specifies the unique identifier of the version of the secret that you want to retrieve. If you specify this
     * parameter then don't specify <code>VersionStage</code>. If you don't specify either a <code>VersionStage</code>
     * or <code>SecretVersionId</code> then the default is to perform the operation on the version with the
     * <code>VersionStage</code> value of <code>AWSCURRENT</code>.
     * </p>
     * <p>
     * This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value
     * with 32 hexadecimal digits.
     * </p>
     * 
     * @return Specifies the unique identifier of the version of the secret that you want to retrieve. If you specify
     *         this parameter then don't specify <code>VersionStage</code>. If you don't specify either a
     *         <code>VersionStage</code> or <code>SecretVersionId</code> then the default is to perform the operation on
     *         the version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.</p>
     *         <p>
     *         This value is typically a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32 hexadecimal
     *         digits.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * Specifies the secret version that you want to retrieve by the staging label attached to the version.
     * </p>
     * <p>
     * Staging labels are used to keep track of different versions during the rotation process. If you use this
     * parameter then don't specify <code>SecretVersionId</code>. If you don't specify either a
     * <code>VersionStage</code> or <code>SecretVersionId</code>, then the default is to perform the operation on the
     * version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.
     * </p>
     * 
     * @return Specifies the secret version that you want to retrieve by the staging label attached to the version.</p>
     *         <p>
     *         Staging labels are used to keep track of different versions during the rotation process. If you use this
     *         parameter then don't specify <code>SecretVersionId</code>. If you don't specify either a
     *         <code>VersionStage</code> or <code>SecretVersionId</code>, then the default is to perform the operation
     *         on the version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.
     */
    public String versionStage() {
        return versionStage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(versionStage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSecretValueRequest)) {
            return false;
        }
        GetSecretValueRequest other = (GetSecretValueRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(versionStage(), other.versionStage());
    }

    @Override
    public String toString() {
        return ToString.builder("GetSecretValueRequest").add("SecretId", secretId()).add("VersionId", versionId())
                .add("VersionStage", versionStage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.of(clazz.cast(secretId()));
        case "VersionId":
            return Optional.of(clazz.cast(versionId()));
        case "VersionStage":
            return Optional.of(clazz.cast(versionStage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, GetSecretValueRequest> {
        /**
         * <p>
         * Specifies the secret containing the version that you want to retrieve. You can specify either the Amazon
         * Resource Name (ARN) or the friendly name of the secret.
         * </p>
         * 
         * @param secretId
         *        Specifies the secret containing the version that you want to retrieve. You can specify either the
         *        Amazon Resource Name (ARN) or the friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * Specifies the unique identifier of the version of the secret that you want to retrieve. If you specify this
         * parameter then don't specify <code>VersionStage</code>. If you don't specify either a
         * <code>VersionStage</code> or <code>SecretVersionId</code> then the default is to perform the operation on the
         * version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.
         * </p>
         * <p>
         * This value is typically a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a>
         * value with 32 hexadecimal digits.
         * </p>
         * 
         * @param versionId
         *        Specifies the unique identifier of the version of the secret that you want to retrieve. If you specify
         *        this parameter then don't specify <code>VersionStage</code>. If you don't specify either a
         *        <code>VersionStage</code> or <code>SecretVersionId</code> then the default is to perform the operation
         *        on the version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.</p>
         *        <p>
         *        This value is typically a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value with 32
         *        hexadecimal digits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * Specifies the secret version that you want to retrieve by the staging label attached to the version.
         * </p>
         * <p>
         * Staging labels are used to keep track of different versions during the rotation process. If you use this
         * parameter then don't specify <code>SecretVersionId</code>. If you don't specify either a
         * <code>VersionStage</code> or <code>SecretVersionId</code>, then the default is to perform the operation on
         * the version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.
         * </p>
         * 
         * @param versionStage
         *        Specifies the secret version that you want to retrieve by the staging label attached to the
         *        version.</p>
         *        <p>
         *        Staging labels are used to keep track of different versions during the rotation process. If you use
         *        this parameter then don't specify <code>SecretVersionId</code>. If you don't specify either a
         *        <code>VersionStage</code> or <code>SecretVersionId</code>, then the default is to perform the
         *        operation on the version with the <code>VersionStage</code> value of <code>AWSCURRENT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionStage(String versionStage);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String versionId;

        private String versionStage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSecretValueRequest model) {
            super(model);
            secretId(model.secretId);
            versionId(model.versionId);
            versionStage(model.versionStage);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getVersionStage() {
            return versionStage;
        }

        @Override
        public final Builder versionStage(String versionStage) {
            this.versionStage = versionStage;
            return this;
        }

        public final void setVersionStage(String versionStage) {
            this.versionStage = versionStage;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetSecretValueRequest build() {
            return new GetSecretValueRequest(this);
        }
    }
}
