/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutSecretValueResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<PutSecretValueResponse.Builder, PutSecretValueResponse> {
    private final String arn;

    private final String name;

    private final String versionId;

    private final List<String> versionStages;

    private PutSecretValueResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.versionId = builder.versionId;
        this.versionStages = builder.versionStages;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the secret for which you just created a version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the secret for which you just created a version.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name of the secret for which you just created or updated a version.
     * </p>
     * 
     * @return The friendly name of the secret for which you just created or updated a version.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The unique identifier of the version of the secret you just created or updated.
     * </p>
     * 
     * @return The unique identifier of the version of the secret you just created or updated.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The list of staging labels that are currently attached to this version of the secret. Staging labels are used to
     * track a version as it progresses through the secret rotation process.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of staging labels that are currently attached to this version of the secret. Staging labels are
     *         used to track a version as it progresses through the secret rotation process.
     */
    public List<String> versionStages() {
        return versionStages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(versionStages());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSecretValueResponse)) {
            return false;
        }
        PutSecretValueResponse other = (PutSecretValueResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(versionId(), other.versionId()) && Objects.equals(versionStages(), other.versionStages());
    }

    @Override
    public String toString() {
        return ToString.builder("PutSecretValueResponse").add("ARN", arn()).add("Name", name()).add("VersionId", versionId())
                .add("VersionStages", versionStages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.of(clazz.cast(arn()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "VersionId":
            return Optional.of(clazz.cast(versionId()));
        case "VersionStages":
            return Optional.of(clazz.cast(versionStages()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerResponse.Builder, CopyableBuilder<Builder, PutSecretValueResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the secret for which you just created a version.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the secret for which you just created a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name of the secret for which you just created or updated a version.
         * </p>
         * 
         * @param name
         *        The friendly name of the secret for which you just created or updated a version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The unique identifier of the version of the secret you just created or updated.
         * </p>
         * 
         * @param versionId
         *        The unique identifier of the version of the secret you just created or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The list of staging labels that are currently attached to this version of the secret. Staging labels are used
         * to track a version as it progresses through the secret rotation process.
         * </p>
         * 
         * @param versionStages
         *        The list of staging labels that are currently attached to this version of the secret. Staging labels
         *        are used to track a version as it progresses through the secret rotation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionStages(Collection<String> versionStages);

        /**
         * <p>
         * The list of staging labels that are currently attached to this version of the secret. Staging labels are used
         * to track a version as it progresses through the secret rotation process.
         * </p>
         * 
         * @param versionStages
         *        The list of staging labels that are currently attached to this version of the secret. Staging labels
         *        are used to track a version as it progresses through the secret rotation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionStages(String... versionStages);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String versionId;

        private List<String> versionStages;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSecretValueResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            versionId(model.versionId);
            versionStages(model.versionStages);
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Collection<String> getVersionStages() {
            return versionStages;
        }

        @Override
        public final Builder versionStages(Collection<String> versionStages) {
            this.versionStages = SecretVersionStagesTypeCopier.copy(versionStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionStages(String... versionStages) {
            versionStages(Arrays.asList(versionStages));
            return this;
        }

        public final void setVersionStages(Collection<String> versionStages) {
            this.versionStages = SecretVersionStagesTypeCopier.copy(versionStages);
        }

        @Override
        public PutSecretValueResponse build() {
            return new PutSecretValueResponse(this);
        }
    }
}
