/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RestoreSecretResponse extends SecretsManagerResponse implements
        ToCopyableBuilder<RestoreSecretResponse.Builder, RestoreSecretResponse> {
    private final String arn;

    private final String name;

    private RestoreSecretResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ARN of the secret that was restored.
     * </p>
     * 
     * @return The ARN of the secret that was restored.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The friendly name of the secret that was restored.
     * </p>
     * 
     * @return The friendly name of the secret that was restored.
     */
    public String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreSecretResponse)) {
            return false;
        }
        RestoreSecretResponse other = (RestoreSecretResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name());
    }

    @Override
    public String toString() {
        return ToString.builder("RestoreSecretResponse").add("ARN", arn()).add("Name", name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ARN":
            return Optional.of(clazz.cast(arn()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerResponse.Builder, CopyableBuilder<Builder, RestoreSecretResponse> {
        /**
         * <p>
         * The ARN of the secret that was restored.
         * </p>
         * 
         * @param arn
         *        The ARN of the secret that was restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The friendly name of the secret that was restored.
         * </p>
         * 
         * @param name
         *        The friendly name of the secret that was restored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl extends SecretsManagerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreSecretResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
        }

        public final String getARN() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public RestoreSecretResponse build() {
            return new RestoreSecretResponse(this);
        }
    }
}
