/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RotateSecretRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<RotateSecretRequest.Builder, RotateSecretRequest> {
    private final String secretId;

    private final String clientRequestToken;

    private final String rotationLambdaARN;

    private final RotationRulesType rotationRules;

    private RotateSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.clientRequestToken = builder.clientRequestToken;
        this.rotationLambdaARN = builder.rotationLambdaARN;
        this.rotationRules = builder.rotationRules;
    }

    /**
     * <p>
     * Specifies the secret that you want to rotate. You can specify either the Amazon Resource Name (ARN) or the
     * friendly name of the secret.
     * </p>
     * 
     * @return Specifies the secret that you want to rotate. You can specify either the Amazon Resource Name (ARN) or
     *         the friendly name of the secret.
     */
    public String secretId() {
        return secretId;
    }

    /**
     * <p>
     * (Optional) Specifies a unique identifier for the new version of the secret that helps ensure idempotency.
     * </p>
     * <p>
     * If you use the AWS CLI or one of the AWS SDK to call this operation, then you can leave this parameter empty. The
     * CLI or SDK generates a random UUID for you and includes that in the request for this parameter. If you don't use
     * the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
     * <code>ClientRequestToken</code> yourself for new versions and include that value in the request.
     * </p>
     * <p>
     * You only need to specify your own value if you are implementing your own retry logic and want to ensure that a
     * given secret is not created twice. We recommend that you generate a <a
     * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness within
     * the specified secret.
     * </p>
     * <p>
     * Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are failures
     * and retries during the function's processing.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new
     * version of the secret is created.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a version with this value already exists and that version's <code>SecretString</code> and
     * <code>SecretBinary</code> values are the same as the request, then the request is ignored (the operation is
     * idempotent).
     * </p>
     * </li>
     * <li>
     * <p>
     * If a version with this value already exists and that version's <code>SecretString</code> and
     * <code>SecretBinary</code> values are different from the request then an error occurs because you cannot modify an
     * existing secret value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This value becomes the <code>SecretVersionId</code> of the new version.
     * </p>
     * 
     * @return (Optional) Specifies a unique identifier for the new version of the secret that helps ensure idempotency.
     *         </p>
     *         <p>
     *         If you use the AWS CLI or one of the AWS SDK to call this operation, then you can leave this parameter
     *         empty. The CLI or SDK generates a random UUID for you and includes that in the request for this
     *         parameter. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager
     *         service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions and
     *         include that value in the request.
     *         </p>
     *         <p>
     *         You only need to specify your own value if you are implementing your own retry logic and want to ensure
     *         that a given secret is not created twice. We recommend that you generate a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness
     *         within the specified secret.
     *         </p>
     *         <p>
     *         Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are
     *         failures and retries during the function's processing.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a
     *         new version of the secret is created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If a version with this value already exists and that version's <code>SecretString</code> and
     *         <code>SecretBinary</code> values are the same as the request, then the request is ignored (the operation
     *         is idempotent).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If a version with this value already exists and that version's <code>SecretString</code> and
     *         <code>SecretBinary</code> values are different from the request then an error occurs because you cannot
     *         modify an existing secret value.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This value becomes the <code>SecretVersionId</code> of the new version.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * (Optional) Specifies the ARN of the Lambda function that can rotate the secret.
     * </p>
     * 
     * @return (Optional) Specifies the ARN of the Lambda function that can rotate the secret.
     */
    public String rotationLambdaARN() {
        return rotationLambdaARN;
    }

    /**
     * <p>
     * A structure that defines the rotation configuration for this secret.
     * </p>
     * 
     * @return A structure that defines the rotation configuration for this secret.
     */
    public RotationRulesType rotationRules() {
        return rotationRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(rotationLambdaARN());
        hashCode = 31 * hashCode + Objects.hashCode(rotationRules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateSecretRequest)) {
            return false;
        }
        RotateSecretRequest other = (RotateSecretRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(rotationLambdaARN(), other.rotationLambdaARN())
                && Objects.equals(rotationRules(), other.rotationRules());
    }

    @Override
    public String toString() {
        return ToString.builder("RotateSecretRequest").add("SecretId", secretId())
                .add("ClientRequestToken", clientRequestToken()).add("RotationLambdaARN", rotationLambdaARN())
                .add("RotationRules", rotationRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.of(clazz.cast(secretId()));
        case "ClientRequestToken":
            return Optional.of(clazz.cast(clientRequestToken()));
        case "RotationLambdaARN":
            return Optional.of(clazz.cast(rotationLambdaARN()));
        case "RotationRules":
            return Optional.of(clazz.cast(rotationRules()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends SecretsManagerRequest.Builder, CopyableBuilder<Builder, RotateSecretRequest> {
        /**
         * <p>
         * Specifies the secret that you want to rotate. You can specify either the Amazon Resource Name (ARN) or the
         * friendly name of the secret.
         * </p>
         * 
         * @param secretId
         *        Specifies the secret that you want to rotate. You can specify either the Amazon Resource Name (ARN) or
         *        the friendly name of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * (Optional) Specifies a unique identifier for the new version of the secret that helps ensure idempotency.
         * </p>
         * <p>
         * If you use the AWS CLI or one of the AWS SDK to call this operation, then you can leave this parameter empty.
         * The CLI or SDK generates a random UUID for you and includes that in the request for this parameter. If you
         * don't use the SDK and instead generate a raw HTTP request to the Secrets Manager service endpoint, then you
         * must generate a <code>ClientRequestToken</code> yourself for new versions and include that value in the
         * request.
         * </p>
         * <p>
         * You only need to specify your own value if you are implementing your own retry logic and want to ensure that
         * a given secret is not created twice. We recommend that you generate a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness
         * within the specified secret.
         * </p>
         * <p>
         * Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are
         * failures and retries during the function's processing.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret then a new
         * version of the secret is created.
         * </p>
         * </li>
         * <li>
         * <p>
         * If a version with this value already exists and that version's <code>SecretString</code> and
         * <code>SecretBinary</code> values are the same as the request, then the request is ignored (the operation is
         * idempotent).
         * </p>
         * </li>
         * <li>
         * <p>
         * If a version with this value already exists and that version's <code>SecretString</code> and
         * <code>SecretBinary</code> values are different from the request then an error occurs because you cannot
         * modify an existing secret value.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This value becomes the <code>SecretVersionId</code> of the new version.
         * </p>
         * 
         * @param clientRequestToken
         *        (Optional) Specifies a unique identifier for the new version of the secret that helps ensure
         *        idempotency. </p>
         *        <p>
         *        If you use the AWS CLI or one of the AWS SDK to call this operation, then you can leave this parameter
         *        empty. The CLI or SDK generates a random UUID for you and includes that in the request for this
         *        parameter. If you don't use the SDK and instead generate a raw HTTP request to the Secrets Manager
         *        service endpoint, then you must generate a <code>ClientRequestToken</code> yourself for new versions
         *        and include that value in the request.
         *        </p>
         *        <p>
         *        You only need to specify your own value if you are implementing your own retry logic and want to
         *        ensure that a given secret is not created twice. We recommend that you generate a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure
         *        uniqueness within the specified secret.
         *        </p>
         *        <p>
         *        Secrets Manager uses this value to prevent the accidental creation of duplicate versions if there are
         *        failures and retries during the function's processing.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the <code>ClientRequestToken</code> value isn't already associated with a version of the secret
         *        then a new version of the secret is created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a version with this value already exists and that version's <code>SecretString</code> and
         *        <code>SecretBinary</code> values are the same as the request, then the request is ignored (the
         *        operation is idempotent).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If a version with this value already exists and that version's <code>SecretString</code> and
         *        <code>SecretBinary</code> values are different from the request then an error occurs because you
         *        cannot modify an existing secret value.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This value becomes the <code>SecretVersionId</code> of the new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * (Optional) Specifies the ARN of the Lambda function that can rotate the secret.
         * </p>
         * 
         * @param rotationLambdaARN
         *        (Optional) Specifies the ARN of the Lambda function that can rotate the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationLambdaARN(String rotationLambdaARN);

        /**
         * <p>
         * A structure that defines the rotation configuration for this secret.
         * </p>
         * 
         * @param rotationRules
         *        A structure that defines the rotation configuration for this secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationRules(RotationRulesType rotationRules);

        /**
         * <p>
         * A structure that defines the rotation configuration for this secret.
         * </p>
         * This is a convenience that creates an instance of the {@link RotationRulesType.Builder} avoiding the need to
         * create one manually via {@link RotationRulesType#builder()}.
         *
         * When the {@link Consumer} completes, {@link RotationRulesType.Builder#build()} is called immediately and its
         * result is passed to {@link #rotationRules(RotationRulesType)}.
         * 
         * @param rotationRules
         *        a consumer that will call methods on {@link RotationRulesType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rotationRules(RotationRulesType)
         */
        default Builder rotationRules(Consumer<RotationRulesType.Builder> rotationRules) {
            return rotationRules(RotationRulesType.builder().apply(rotationRules).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String clientRequestToken;

        private String rotationLambdaARN;

        private RotationRulesType rotationRules;

        private BuilderImpl() {
        }

        private BuilderImpl(RotateSecretRequest model) {
            super(model);
            secretId(model.secretId);
            clientRequestToken(model.clientRequestToken);
            rotationLambdaARN(model.rotationLambdaARN);
            rotationRules(model.rotationRules);
        }

        public final String getSecretId() {
            return secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getRotationLambdaARN() {
            return rotationLambdaARN;
        }

        @Override
        public final Builder rotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
            return this;
        }

        public final void setRotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
        }

        public final RotationRulesType.Builder getRotationRules() {
            return rotationRules != null ? rotationRules.toBuilder() : null;
        }

        @Override
        public final Builder rotationRules(RotationRulesType rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        public final void setRotationRules(RotationRulesType.BuilderImpl rotationRules) {
            this.rotationRules = rotationRules != null ? rotationRules.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RotateSecretRequest build() {
            return new RotateSecretRequest(this);
        }
    }
}
