/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.secretsmanager.transform.RotationRulesTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines the rotation configuration for the secret.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RotationRulesType implements StructuredPojo, ToCopyableBuilder<RotationRulesType.Builder, RotationRulesType> {
    private final Long automaticallyAfterDays;

    private RotationRulesType(BuilderImpl builder) {
        this.automaticallyAfterDays = builder.automaticallyAfterDays;
    }

    /**
     * <p>
     * Specifies the number of days between automatic scheduled rotations of the secret.
     * </p>
     * 
     * @return Specifies the number of days between automatic scheduled rotations of the secret.
     */
    public Long automaticallyAfterDays() {
        return automaticallyAfterDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticallyAfterDays());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationRulesType)) {
            return false;
        }
        RotationRulesType other = (RotationRulesType) obj;
        return Objects.equals(automaticallyAfterDays(), other.automaticallyAfterDays());
    }

    @Override
    public String toString() {
        return ToString.builder("RotationRulesType").add("AutomaticallyAfterDays", automaticallyAfterDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticallyAfterDays":
            return Optional.of(clazz.cast(automaticallyAfterDays()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RotationRulesTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RotationRulesType> {
        /**
         * <p>
         * Specifies the number of days between automatic scheduled rotations of the secret.
         * </p>
         * 
         * @param automaticallyAfterDays
         *        Specifies the number of days between automatic scheduled rotations of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticallyAfterDays(Long automaticallyAfterDays);
    }

    static final class BuilderImpl implements Builder {
        private Long automaticallyAfterDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationRulesType model) {
            automaticallyAfterDays(model.automaticallyAfterDays);
        }

        public final Long getAutomaticallyAfterDays() {
            return automaticallyAfterDays;
        }

        @Override
        public final Builder automaticallyAfterDays(Long automaticallyAfterDays) {
            this.automaticallyAfterDays = automaticallyAfterDays;
            return this;
        }

        public final void setAutomaticallyAfterDays(Long automaticallyAfterDays) {
            this.automaticallyAfterDays = automaticallyAfterDays;
        }

        @Override
        public RotationRulesType build() {
            return new RotationRulesType(this);
        }
    }
}
