/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link SecretListEntry} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class SecretListEntryMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ARN").isBinary(false).build();

    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();

    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();

    private static final MarshallingInfo<Boolean> ROTATIONENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationEnabled").isBinary(false).build();

    private static final MarshallingInfo<String> ROTATIONLAMBDAARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationLambdaARN").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> ROTATIONRULES_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationRules")
            .isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTROTATEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastRotatedDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTCHANGEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastChangedDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> LASTACCESSEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessedDate").isBinary(false).build();

    private static final MarshallingInfo<Instant> DELETEDDATE_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeletedDate").isBinary(false).build();

    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();

    private static final MarshallingInfo<Map> SECRETVERSIONSTOSTAGES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretVersionsToStages").isBinary(false).build();

    private static final SecretListEntryMarshaller INSTANCE = new SecretListEntryMarshaller();

    private SecretListEntryMarshaller() {
    }

    public static SecretListEntryMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(SecretListEntry secretListEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(secretListEntry, "secretListEntry");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(secretListEntry.arn(), ARN_BINDING);
            protocolMarshaller.marshall(secretListEntry.name(), NAME_BINDING);
            protocolMarshaller.marshall(secretListEntry.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(secretListEntry.kmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall(secretListEntry.rotationEnabled(), ROTATIONENABLED_BINDING);
            protocolMarshaller.marshall(secretListEntry.rotationLambdaARN(), ROTATIONLAMBDAARN_BINDING);
            protocolMarshaller.marshall(secretListEntry.rotationRules(), ROTATIONRULES_BINDING);
            protocolMarshaller.marshall(secretListEntry.lastRotatedDate(), LASTROTATEDDATE_BINDING);
            protocolMarshaller.marshall(secretListEntry.lastChangedDate(), LASTCHANGEDDATE_BINDING);
            protocolMarshaller.marshall(secretListEntry.lastAccessedDate(), LASTACCESSEDDATE_BINDING);
            protocolMarshaller.marshall(secretListEntry.deletedDate(), DELETEDDATE_BINDING);
            protocolMarshaller.marshall(secretListEntry.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(secretListEntry.secretVersionsToStages(), SECRETVERSIONSTOSTAGES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
