/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.secretsmanager.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SecretListEntry JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SecretListEntryUnmarshaller implements Unmarshaller<SecretListEntry, JsonUnmarshallerContext> {

    public SecretListEntry unmarshall(JsonUnmarshallerContext context) throws Exception {
        SecretListEntry.Builder secretListEntryBuilder = SecretListEntry.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("ARN", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.arn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.description(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.kmsKeyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RotationEnabled", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.rotationEnabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("RotationLambdaARN", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.rotationLambdaARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RotationRules", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.rotationRules(RotationRulesTypeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("LastRotatedDate", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.lastRotatedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("LastChangedDate", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.lastChangedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("LastAccessedDate", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.lastAccessedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("DeletedDate", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.deletedDate(context.getUnmarshaller(java.time.Instant.class).unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.tags(new ListUnmarshaller<Tag>(TagUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("SecretVersionsToStages", targetDepth)) {
                    context.nextToken();
                    secretListEntryBuilder.secretVersionsToStages(new MapUnmarshaller<String, java.util.List<String>>(context
                            .getUnmarshaller(String.class), new ListUnmarshaller<String>(context.getUnmarshaller(String.class)))
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return secretListEntryBuilder.build();
    }

    private static final SecretListEntryUnmarshaller INSTANCE = new SecretListEntryUnmarshaller();

    public static SecretListEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}
